<?php
//Include Common Files @1-4BBF188B
define("RelativePath", ".");
define("PathToCurrentPage", "/");
define("FileName", "mst_vehicle.php");
include_once(RelativePath . "/Common.php");
include_once(RelativePath . "/Template.php");
include_once(RelativePath . "/Sorter.php");
include_once(RelativePath . "/Navigator.php");
//End Include Common Files

//Include Page implementation @2-DF385382
include_once(RelativePath . "/incl_left_panel.php");
//End Include Page implementation

//Include Page implementation @3-73D590C4
include_once(RelativePath . "/incl_header.php");
//End Include Page implementation

//Include Page implementation @4-16DCDEFB
include_once(RelativePath . "/incl_footer.php");
//End Include Page implementation

class clsGridclix_list { //clix_list class @5-9A031AD4

//Variables @5-6E51DF5A

    // Public variables
    public $ComponentType = "Grid";
    public $ComponentName;
    public $Visible;
    public $Errors;
    public $ErrorBlock;
    public $ds;
    public $DataSource;
    public $PageSize;
    public $IsEmpty;
    public $ForceIteration = false;
    public $HasRecord = false;
    public $SorterName = "";
    public $SorterDirection = "";
    public $PageNumber;
    public $RowNumber;
    public $ControlsVisible = array();

    public $CCSEvents = "";
    public $CCSEventResult;

    public $RelativePath = "";
    public $Attributes;

    // Grid Controls
    public $StaticControls;
    public $RowControls;
//End Variables

//Class_Initialize Event @5-7FDC44ED
    function clsGridclix_list($RelativePath, & $Parent)
    {
        global $FileName;
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->ComponentName = "clix_list";
        $this->Visible = True;
        $this->Parent = & $Parent;
        $this->RelativePath = $RelativePath;
        $this->Errors = new clsErrors();
        $this->ErrorBlock = "Grid clix_list";
        $this->Attributes = new clsAttributes($this->ComponentName . ":");
        $this->DataSource = new clsclix_listDataSource($this);
        $this->ds = & $this->DataSource;
        $this->PageSize = CCGetParam($this->ComponentName . "PageSize", "");
        if(!is_numeric($this->PageSize) || !strlen($this->PageSize))
            $this->PageSize = 2000;
        else
            $this->PageSize = intval($this->PageSize);
        if ($this->PageSize > 2000)
            $this->PageSize = 2000;
        if($this->PageSize == 0)
            $this->Errors->addError("<p>Form: Grid " . $this->ComponentName . "<br>Error: (CCS06) Invalid page size.</p>");
        $this->PageNumber = intval(CCGetParam($this->ComponentName . "Page", 1));
        if ($this->PageNumber <= 0) $this->PageNumber = 1;

        $this->v_no = new clsControl(ccsLabel, "v_no", "v_no", ccsText, "", CCGetRequestParam("v_no", ccsGet, NULL), $this);
        $this->v_capacity = new clsControl(ccsLabel, "v_capacity", "v_capacity", ccsText, "", CCGetRequestParam("v_capacity", ccsGet, NULL), $this);
        $this->v_length = new clsControl(ccsLabel, "v_length", "v_length", ccsText, "", CCGetRequestParam("v_length", ccsGet, NULL), $this);
        $this->from_branch = new clsControl(ccsLabel, "from_branch", "from_branch", ccsText, "", CCGetRequestParam("from_branch", ccsGet, NULL), $this);
        $this->v_id = new clsControl(ccsHidden, "v_id", "v_id", ccsInteger, "", CCGetRequestParam("v_id", ccsGet, NULL), $this);
        $this->s_v_id = new clsControl(ccsLabel, "s_v_id", "s_v_id", ccsInteger, array(True, 0, Null, "", False, array("0", "0", "0", "0", "0", "0"), "", 1, True, ""), CCGetRequestParam("s_v_id", ccsGet, NULL), $this);
    }
//End Class_Initialize Event

//Initialize Method @5-90E704C5
    function Initialize()
    {
        if(!$this->Visible) return;

        $this->DataSource->PageSize = & $this->PageSize;
        $this->DataSource->AbsolutePage = & $this->PageNumber;
        $this->DataSource->SetOrder($this->SorterName, $this->SorterDirection);
    }
//End Initialize Method

//Show Method @5-953AC886
    function Show()
    {
        global $Tpl;
        global $CCSLocales;
        if(!$this->Visible) return;

        $this->RowNumber = 0;

        $this->DataSource->Parameters["sescompany_code"] = CCGetSession("company_code", NULL);
        $this->DataSource->Parameters["expr103"] = N;

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeSelect", $this);


        $this->DataSource->Prepare();
        $this->DataSource->Open();
        $this->HasRecord = $this->DataSource->has_next_record();
        $this->IsEmpty = ! $this->HasRecord;
        $this->Attributes->Show();

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShow", $this);
        if(!$this->Visible) return;

        $GridBlock = "Grid " . $this->ComponentName;
        $ParentPath = $Tpl->block_path;
        $Tpl->block_path = $ParentPath . "/" . $GridBlock;


        if (!$this->IsEmpty) {
            $this->ControlsVisible["v_no"] = $this->v_no->Visible;
            $this->ControlsVisible["v_capacity"] = $this->v_capacity->Visible;
            $this->ControlsVisible["v_length"] = $this->v_length->Visible;
            $this->ControlsVisible["from_branch"] = $this->from_branch->Visible;
            $this->ControlsVisible["v_id"] = $this->v_id->Visible;
            $this->ControlsVisible["s_v_id"] = $this->s_v_id->Visible;
            while ($this->ForceIteration || (($this->RowNumber < $this->PageSize) &&  ($this->HasRecord = $this->DataSource->has_next_record()))) {
                $this->RowNumber++;
                if ($this->HasRecord) {
                    $this->DataSource->next_record();
                    $this->DataSource->SetValues();
                }
                $Tpl->block_path = $ParentPath . "/" . $GridBlock . "/Row";
                $this->v_no->SetValue($this->DataSource->v_no->GetValue());
                $this->v_capacity->SetValue($this->DataSource->v_capacity->GetValue());
                $this->v_length->SetValue($this->DataSource->v_length->GetValue());
                $this->from_branch->SetValue($this->DataSource->from_branch->GetValue());
                $this->v_id->SetValue($this->DataSource->v_id->GetValue());
                $this->s_v_id->SetValue($this->DataSource->s_v_id->GetValue());
                $this->Attributes->SetValue("rowNumber", $this->RowNumber);
                $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShowRow", $this);
                $this->Attributes->Show();
                $this->v_no->Show();
                $this->v_capacity->Show();
                $this->v_length->Show();
                $this->from_branch->Show();
                $this->v_id->Show();
                $this->s_v_id->Show();
                $Tpl->block_path = $ParentPath . "/" . $GridBlock;
                $Tpl->parse("Row", true);
            }
        }

        $errors = $this->GetErrors();
        if(strlen($errors))
        {
            $Tpl->replaceblock("", $errors);
            $Tpl->block_path = $ParentPath;
            return;
        }
        $Tpl->parse();
        $Tpl->block_path = $ParentPath;
        $this->DataSource->close();
    }
//End Show Method

//GetErrors Method @5-3A245D5A
    function GetErrors()
    {
        $errors = "";
        $errors = ComposeStrings($errors, $this->v_no->Errors->ToString());
        $errors = ComposeStrings($errors, $this->v_capacity->Errors->ToString());
        $errors = ComposeStrings($errors, $this->v_length->Errors->ToString());
        $errors = ComposeStrings($errors, $this->from_branch->Errors->ToString());
        $errors = ComposeStrings($errors, $this->v_id->Errors->ToString());
        $errors = ComposeStrings($errors, $this->s_v_id->Errors->ToString());
        $errors = ComposeStrings($errors, $this->Errors->ToString());
        $errors = ComposeStrings($errors, $this->DataSource->Errors->ToString());
        return $errors;
    }
//End GetErrors Method

} //End clix_list Class @5-FCB6E20C

class clsclix_listDataSource extends clsDBConnection1 {  //clix_listDataSource Class @5-E0C69A6C

//DataSource Variables @5-E28D6DC2
    public $Parent = "";
    public $CCSEvents = "";
    public $CCSEventResult;
    public $ErrorBlock;
    public $CmdExecution;

    public $CountSQL;
    public $wp;


    // Datasource fields
    public $v_no;
    public $v_capacity;
    public $v_length;
    public $from_branch;
    public $v_id;
    public $s_v_id;
//End DataSource Variables

//DataSourceClass_Initialize Event @5-CBF14BC6
    function clsclix_listDataSource(& $Parent)
    {
        $this->Parent = & $Parent;
        $this->ErrorBlock = "Grid clix_list";
        $this->Initialize();
        $this->v_no = new clsField("v_no", ccsText, "");
        
        $this->v_capacity = new clsField("v_capacity", ccsText, "");
        
        $this->v_length = new clsField("v_length", ccsText, "");
        
        $this->from_branch = new clsField("from_branch", ccsText, "");
        
        $this->v_id = new clsField("v_id", ccsInteger, "");
        
        $this->s_v_id = new clsField("s_v_id", ccsInteger, "");
        

    }
//End DataSourceClass_Initialize Event

//SetOrder Method @5-B61E35CC
    function SetOrder($SorterName, $SorterDirection)
    {
        $this->Order = "mst_vehicle.v_id desc";
        $this->Order = CCGetOrder($this->Order, $SorterName, $SorterDirection, 
            "");
    }
//End SetOrder Method

//Prepare Method @5-57A0427C
    function Prepare()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->wp = new clsSQLParameters($this->ErrorBlock);
        $this->wp->AddParameter("1", "sescompany_code", ccsInteger, "", "", $this->Parameters["sescompany_code"], -1, false);
        $this->wp->AddParameter("2", "expr103", ccsText, "", "", $this->Parameters["expr103"], "", false);
        $this->wp->Criterion[1] = $this->wp->Operation(opEqual, "mst_vehicle.prefix_company_code", $this->wp->GetDBValue("1"), $this->ToSQL($this->wp->GetDBValue("1"), ccsInteger),false);
        $this->wp->Criterion[2] = $this->wp->Operation(opEqual, "mst_vehicle.flg_delete", $this->wp->GetDBValue("2"), $this->ToSQL($this->wp->GetDBValue("2"), ccsText),false);
        $this->Where = $this->wp->opAND(
             false, 
             $this->wp->Criterion[1], 
             $this->wp->Criterion[2]);
    }
//End Prepare Method

//Open Method @5-EDCFD8B9
    function Open()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildSelect", $this->Parent);
        $this->CountSQL = "SELECT COUNT(*)\n\n" .
        "FROM (mst_vehicle INNER JOIN branch_mst ON\n\n" .
        "mst_vehicle.v_from = branch_mst.branch_code) LEFT JOIN mst_vehicle_type ON\n\n" .
        "mst_vehicle.v_type_id = mst_vehicle_type.vehicle_type_id";
        $this->SQL = "SELECT branch_name, v_id, v_no, flg_delete, vehicle_type_name, vehicle_capacity, vehicle_length \n\n" .
        "FROM (mst_vehicle INNER JOIN branch_mst ON\n\n" .
        "mst_vehicle.v_from = branch_mst.branch_code) LEFT JOIN mst_vehicle_type ON\n\n" .
        "mst_vehicle.v_type_id = mst_vehicle_type.vehicle_type_id {SQL_Where} {SQL_OrderBy}";
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteSelect", $this->Parent);
        if ($this->CountSQL) 
            $this->RecordsCount = CCGetDBValue(CCBuildSQL($this->CountSQL, $this->Where, ""), $this);
        else
            $this->RecordsCount = "CCS not counted";
        $this->query($this->OptimizeSQL(CCBuildSQL($this->SQL, $this->Where, $this->Order)));
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteSelect", $this->Parent);
    }
//End Open Method

//SetValues Method @5-403BE949
    function SetValues()
    {
        $this->v_no->SetDBValue($this->f("v_no"));
        $this->v_capacity->SetDBValue($this->f("vehicle_capacity"));
        $this->v_length->SetDBValue($this->f("vehicle_length"));
        $this->from_branch->SetDBValue($this->f("branch_name"));
        $this->v_id->SetDBValue(trim($this->f("v_id")));
        $this->s_v_id->SetDBValue(trim($this->f("v_id")));
    }
//End SetValues Method

} //End clix_listDataSource Class @5-FCB6E20C

//Initialize Page @1-D0DDAE58
// Variables
$FileName = "";
$Redirect = "";
$Tpl = "";
$TemplateFileName = "";
$BlockToParse = "";
$ComponentName = "";
$Attributes = "";

// Events;
$CCSEvents = "";
$CCSEventResult = "";

$FileName = FileName;
$Redirect = "";
$TemplateFileName = "mst_vehicle.html";
$BlockToParse = "main";
$TemplateEncoding = "CP1252";
$ContentType = "text/html";
$PathToRoot = "./";
//End Initialize Page

//Authenticate User @1-2C40F5EA
CCSecurityRedirect("10;3", "");
//End Authenticate User

//Before Initialize @1-E870CEBC
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeInitialize", $MainPage);
//End Before Initialize

//Initialize Objects @1-DF20E5AA
$DBConnection1 = new clsDBConnection1();
$MainPage->Connections["Connection1"] = & $DBConnection1;
$Attributes = new clsAttributes("page:");
$MainPage->Attributes = & $Attributes;

// Controls
$incl_left_panel = new clsincl_left_panel("", "incl_left_panel", $MainPage);
$incl_left_panel->Initialize();
$incl_header = new clsincl_header("", "incl_header", $MainPage);
$incl_header->Initialize();
$incl_footer = new clsincl_footer("", "incl_footer", $MainPage);
$incl_footer->Initialize();
$clix_list = new clsGridclix_list("", $MainPage);
$MainPage->incl_left_panel = & $incl_left_panel;
$MainPage->incl_header = & $incl_header;
$MainPage->incl_footer = & $incl_footer;
$MainPage->clix_list = & $clix_list;
$clix_list->Initialize();

$CCSEventResult = CCGetEvent($CCSEvents, "AfterInitialize", $MainPage);

if ($Charset) {
    header("Content-Type: " . $ContentType . "; charset=" . $Charset);
} else {
    header("Content-Type: " . $ContentType);
}
//End Initialize Objects

//Initialize HTML Template @1-E710DB26
$CCSEventResult = CCGetEvent($CCSEvents, "OnInitializeView", $MainPage);
$Tpl = new clsTemplate($FileEncoding, $TemplateEncoding);
$Tpl->LoadTemplate(PathToCurrentPage . $TemplateFileName, $BlockToParse, "CP1252");
$Tpl->block_path = "/$BlockToParse";
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeShow", $MainPage);
$Attributes->SetValue("pathToRoot", "");
$Attributes->Show();
//End Initialize HTML Template

//Execute Components @1-B74CF824
$incl_left_panel->Operations();
$incl_header->Operations();
$incl_footer->Operations();
//End Execute Components

//Go to destination page @1-D092419F
if($Redirect)
{
    $CCSEventResult = CCGetEvent($CCSEvents, "BeforeUnload", $MainPage);
    $DBConnection1->close();
    header("Location: " . $Redirect);
    $incl_left_panel->Class_Terminate();
    unset($incl_left_panel);
    $incl_header->Class_Terminate();
    unset($incl_header);
    $incl_footer->Class_Terminate();
    unset($incl_footer);
    unset($clix_list);
    unset($Tpl);
    exit;
}
//End Go to destination page

//Show Page @1-32053747
$incl_left_panel->Show();
$incl_header->Show();
$incl_footer->Show();
$clix_list->Show();
$Tpl->block_path = "";
$Tpl->Parse($BlockToParse, false);
if (!isset($main_block)) $main_block = $Tpl->GetVar($BlockToParse);
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeOutput", $MainPage);
if ($CCSEventResult) echo $main_block;
//End Show Page

//Unload Page @1-AEB75043
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeUnload", $MainPage);
$DBConnection1->close();
$incl_left_panel->Class_Terminate();
unset($incl_left_panel);
$incl_header->Class_Terminate();
unset($incl_header);
$incl_footer->Class_Terminate();
unset($incl_footer);
unset($clix_list);
unset($Tpl);
//End Unload Page


?>
