<?php
//Include Common Files @1-07275DB1
define("RelativePath", "..");
define("PathToCurrentPage", "/hotel_front/");
define("FileName", "checkout_login.php");
include_once(RelativePath . "/Common.php");
include_once(RelativePath . "/Template.php");
include_once(RelativePath . "/Sorter.php");
include_once(RelativePath . "/Navigator.php");
//End Include Common Files



class clsRecordLogin { //Login Class @17-58926B8F

//Variables @17-9E315808

    // Public variables
    public $ComponentType = "Record";
    public $ComponentName;
    public $Parent;
    public $HTMLFormAction;
    public $PressedButton;
    public $Errors;
    public $ErrorBlock;
    public $FormSubmitted;
    public $FormEnctype;
    public $Visible;
    public $IsEmpty;

    public $CCSEvents = "";
    public $CCSEventResult;

    public $RelativePath = "";

    public $InsertAllowed = false;
    public $UpdateAllowed = false;
    public $DeleteAllowed = false;
    public $ReadAllowed   = false;
    public $EditMode      = false;
    public $ds;
    public $DataSource;
    public $ValidatingControls;
    public $Controls;
    public $Attributes;

    // Class variables
//End Variables

//Class_Initialize Event @17-86C4655C
    function clsRecordLogin($RelativePath, & $Parent)
    {

        global $FileName;
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->Visible = true;
        $this->Parent = & $Parent;
        $this->RelativePath = $RelativePath;
        $this->Errors = new clsErrors();
        $this->ErrorBlock = "Record Login/Error";
        $this->DataSource = new clsLoginDataSource($this);
        $this->ds = & $this->DataSource;
        $this->ReadAllowed = true;
        if($this->Visible)
        {
            $this->ComponentName = "Login";
            $this->Attributes = new clsAttributes($this->ComponentName . ":");
            $CCSForm = explode(":", CCGetFromGet("ccsForm", ""), 2);
            if(sizeof($CCSForm) == 1)
                $CCSForm[1] = "";
            list($FormName, $FormMethod) = $CCSForm;
            $this->EditMode = ($FormMethod == "Edit");
            $this->FormEnctype = "application/x-www-form-urlencoded";
            $this->FormSubmitted = ($FormName == $this->ComponentName);
            $Method = $this->FormSubmitted ? ccsPost : ccsGet;
            $this->Button_DoLogin = new clsButton("Button_DoLogin", $Method, $this);
            $this->login = new clsControl(ccsTextBox, "login", "login", ccsText, "", CCGetRequestParam("login", $Method, NULL), $this);
            $this->password = new clsControl(ccsTextBox, "password", "password", ccsText, "", CCGetRequestParam("password", $Method, NULL), $this);
            $this->Button_Cancel = new clsButton("Button_Cancel", $Method, $this);
        }
    }
//End Class_Initialize Event

//Initialize Method @17-5D060BAC
    function Initialize()
    {

        if(!$this->Visible)
            return;

    }
//End Initialize Method

//Validate Method @17-C9284A6A
    function Validate()
    {
        global $CCSLocales;
        $Validation = true;
        $Where = "";
        $Validation = ($this->login->Validate() && $Validation);
        $Validation = ($this->password->Validate() && $Validation);
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "OnValidate", $this);
        $Validation =  $Validation && ($this->login->Errors->Count() == 0);
        $Validation =  $Validation && ($this->password->Errors->Count() == 0);
        return (($this->Errors->Count() == 0) && $Validation);
    }
//End Validate Method

//CheckErrors Method @17-9B532DF2
    function CheckErrors()
    {
        $errors = false;
        $errors = ($errors || $this->login->Errors->Count());
        $errors = ($errors || $this->password->Errors->Count());
        $errors = ($errors || $this->Errors->Count());
        $errors = ($errors || $this->DataSource->Errors->Count());
        return $errors;
    }
//End CheckErrors Method

//MasterDetail @17-ED598703
function SetPrimaryKeys($keyArray)
{
    $this->PrimaryKeys = $keyArray;
}
function GetPrimaryKeys()
{
    return $this->PrimaryKeys;
}
function GetPrimaryKey($keyName)
{
    return $this->PrimaryKeys[$keyName];
}
//End MasterDetail

//Operation Method @17-E98A8BF1
    function Operation()
    {
        if(!$this->Visible)
            return;

        global $Redirect;
        global $FileName;

        $this->DataSource->Prepare();
        if(!$this->FormSubmitted) {
            $this->EditMode = true;
            return;
        }

        if($this->FormSubmitted) {
            $this->PressedButton = "Button_DoLogin";
            if($this->Button_DoLogin->Pressed) {
                $this->PressedButton = "Button_DoLogin";
            } else if($this->Button_Cancel->Pressed) {
                $this->PressedButton = "Button_Cancel";
            }
        }
        $Redirect = $FileName . "?" . CCGetQueryString("QueryString", array("ccsForm", "logout"));
        if($this->PressedButton == "Button_Cancel") {
            $Redirect = "#" . "?" . CCGetQueryString("QueryString", array("ccsForm", "logout"));
            if(!CCGetEvent($this->Button_Cancel->CCSEvents, "OnClick", $this->Button_Cancel)) {
                $Redirect = "";
            }
        } else if($this->Validate()) {
            if($this->PressedButton == "Button_DoLogin") {
                $Redirect = $FileName . "?" . CCMergeQueryStrings(CCGetQueryString("Form", array("Button_DoLogin", "Button_DoLogin_x", "Button_DoLogin_y", "Button_Cancel", "Button_Cancel_x", "Button_Cancel_y", "logout")), CCGetQueryString("QueryString", array("login", "password", "ccsForm", "logout")));
                if(!CCGetEvent($this->Button_DoLogin->CCSEvents, "OnClick", $this->Button_DoLogin)) {
                    $Redirect = "";
                }
            }
        } else {
            $Redirect = "";
        }
        if ($Redirect)
            $this->DataSource->close();
    }
//End Operation Method

//Show Method @17-ADC09E1F
    function Show()
    {
        global $CCSUseAmp;
        global $Tpl;
        global $FileName;
        global $CCSLocales;
        $Error = "";

        if(!$this->Visible)
            return;

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeSelect", $this);


        $RecordBlock = "Record " . $this->ComponentName;
        $ParentPath = $Tpl->block_path;
        $Tpl->block_path = $ParentPath . "/" . $RecordBlock;
        $this->EditMode = $this->EditMode && $this->ReadAllowed;
        if($this->EditMode) {
            if($this->DataSource->Errors->Count()){
                $this->Errors->AddErrors($this->DataSource->Errors);
                $this->DataSource->Errors->clear();
            }
            $this->DataSource->Open();
            if($this->DataSource->Errors->Count() == 0 && $this->DataSource->next_record()) {
                $this->DataSource->SetValues();
            } else {
                $this->EditMode = false;
            }
        }
        if (!$this->FormSubmitted) {
        }

        if($this->FormSubmitted || $this->CheckErrors()) {
            $Error = "";
            $Error = ComposeStrings($Error, $this->login->Errors->ToString());
            $Error = ComposeStrings($Error, $this->password->Errors->ToString());
            $Error = ComposeStrings($Error, $this->Errors->ToString());
            $Error = ComposeStrings($Error, $this->DataSource->Errors->ToString());
            $Tpl->SetVar("Error", $Error);
            $Tpl->Parse("Error", false);
        }
        $CCSForm = $this->EditMode ? $this->ComponentName . ":" . "Edit" : $this->ComponentName;
        $this->HTMLFormAction = $FileName . "?" . CCAddParam(CCGetQueryString("QueryString", ""), "ccsForm", $CCSForm);
        $Tpl->SetVar("Action", !$CCSUseAmp ? $this->HTMLFormAction : str_replace("&", "&amp;", $this->HTMLFormAction));
        $Tpl->SetVar("HTMLFormName", $this->ComponentName);
        $Tpl->SetVar("HTMLFormEnctype", $this->FormEnctype);

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShow", $this);
        $this->Attributes->Show();
        if(!$this->Visible) {
            $Tpl->block_path = $ParentPath;
            return;
        }

        $this->Button_DoLogin->Show();
        $this->login->Show();
        $this->password->Show();
        $this->Button_Cancel->Show();
        $Tpl->parse();
        $Tpl->block_path = $ParentPath;
        $this->DataSource->close();
    }
//End Show Method

} //End Login Class @17-FCB6E20C

class clsLoginDataSource extends clsDBConnection1 {  //LoginDataSource Class @17-68CD7B92

//DataSource Variables @17-A068324D
    public $Parent = "";
    public $CCSEvents = "";
    public $CCSEventResult;
    public $ErrorBlock;
    public $CmdExecution;

    public $wp;
    public $AllParametersSet;


    // Datasource fields
    public $login;
    public $password;
//End DataSource Variables

//DataSourceClass_Initialize Event @17-7796A7B7
    function clsLoginDataSource(& $Parent)
    {
        $this->Parent = & $Parent;
        $this->ErrorBlock = "Record Login/Error";
        $this->Initialize();
        $this->login = new clsField("login", ccsText, "");
        
        $this->password = new clsField("password", ccsText, "");
        

    }
//End DataSourceClass_Initialize Event

//Prepare Method @17-14D6CD9D
    function Prepare()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
    }
//End Prepare Method

//Open Method @17-EEA7E372
    function Open()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildSelect", $this->Parent);
        $this->SQL = "SELECT * \n\n" .
        "FROM store_client {SQL_Where} {SQL_OrderBy}";
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteSelect", $this->Parent);
        $this->PageSize = 1;
        $this->query($this->OptimizeSQL(CCBuildSQL($this->SQL, $this->Where, $this->Order)));
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteSelect", $this->Parent);
    }
//End Open Method

//SetValues Method @17-BAF0975B
    function SetValues()
    {
    }
//End SetValues Method

} //End LoginDataSource Class @17-FCB6E20C



class clsRecordsignup { //signup Class @37-8EA8D0A6

//Variables @37-9E315808

    // Public variables
    public $ComponentType = "Record";
    public $ComponentName;
    public $Parent;
    public $HTMLFormAction;
    public $PressedButton;
    public $Errors;
    public $ErrorBlock;
    public $FormSubmitted;
    public $FormEnctype;
    public $Visible;
    public $IsEmpty;

    public $CCSEvents = "";
    public $CCSEventResult;

    public $RelativePath = "";

    public $InsertAllowed = false;
    public $UpdateAllowed = false;
    public $DeleteAllowed = false;
    public $ReadAllowed   = false;
    public $EditMode      = false;
    public $ds;
    public $DataSource;
    public $ValidatingControls;
    public $Controls;
    public $Attributes;

    // Class variables
//End Variables

//Class_Initialize Event @37-79161BAA
    function clsRecordsignup($RelativePath, & $Parent)
    {

        global $FileName;
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->Visible = true;
        $this->Parent = & $Parent;
        $this->RelativePath = $RelativePath;
        $this->Errors = new clsErrors();
        $this->ErrorBlock = "Record signup/Error";
        $this->DataSource = new clssignupDataSource($this);
        $this->ds = & $this->DataSource;
        $this->InsertAllowed = true;
        $this->UpdateAllowed = true;
        $this->ReadAllowed = true;
        if($this->Visible)
        {
            $this->ComponentName = "signup";
            $this->Attributes = new clsAttributes($this->ComponentName . ":");
            $CCSForm = explode(":", CCGetFromGet("ccsForm", ""), 2);
            if(sizeof($CCSForm) == 1)
                $CCSForm[1] = "";
            list($FormName, $FormMethod) = $CCSForm;
            $this->EditMode = ($FormMethod == "Edit");
            $this->FormEnctype = "application/x-www-form-urlencoded";
            $this->FormSubmitted = ($FormName == $this->ComponentName);
            $Method = $this->FormSubmitted ? ccsPost : ccsGet;
            $this->Button_Insert = new clsButton("Button_Insert", $Method, $this);
            $this->Button_Update = new clsButton("Button_Update", $Method, $this);
            $this->address = new clsControl(ccsTextArea, "address", "Address", ccsText, "", CCGetRequestParam("address", $Method, NULL), $this);
            $this->pin = new clsControl(ccsTextBox, "pin", "Pin", ccsText, "", CCGetRequestParam("pin", $Method, NULL), $this);
            $this->phone = new clsControl(ccsTextBox, "phone", "Phone", ccsText, "", CCGetRequestParam("phone", $Method, NULL), $this);
            $this->city = new clsControl(ccsTextBox, "city", "City", ccsText, "", CCGetRequestParam("city", $Method, NULL), $this);
            $this->country_id = new clsControl(ccsListBox, "country_id", "Country", ccsInteger, "", CCGetRequestParam("country_id", $Method, NULL), $this);
            $this->country_id->DSType = dsTable;
            $this->country_id->DataSource = new clsDBConnection1();
            $this->country_id->ds = & $this->country_id->DataSource;
            $this->country_id->DataSource->SQL = "SELECT * \n" .
"FROM mst_country {SQL_Where} {SQL_OrderBy}";
            $this->country_id->DataSource->Order = "country_name";
            list($this->country_id->BoundColumn, $this->country_id->TextColumn, $this->country_id->DBFormat) = array("country_id", "country_name", "");
            $this->country_id->DataSource->Order = "country_name";
            $this->fname = new clsControl(ccsTextBox, "fname", "First Name", ccsText, "", CCGetRequestParam("fname", $Method, NULL), $this);
            $this->lname = new clsControl(ccsTextBox, "lname", "Last Name", ccsText, "", CCGetRequestParam("lname", $Method, NULL), $this);
            $this->company = new clsControl(ccsTextBox, "company", "Organization", ccsText, "", CCGetRequestParam("company", $Method, NULL), $this);
            $this->state = new clsControl(ccsTextBox, "state", "State", ccsText, "", CCGetRequestParam("state", $Method, NULL), $this);
            $this->flg_enable = new clsControl(ccsHidden, "flg_enable", "flg_enable", ccsText, "", CCGetRequestParam("flg_enable", $Method, NULL), $this);
            $this->Captcha1 = new clsCaptcha("Captcha1", "Captcha1", CCGetRequestParam("Captcha1", $Method, NULL), 120, 40, "CaptchasignupCaptcha1", false, $this);
            $this->login_id = new clsControl(ccsTextBox, "login_id", "Email", ccsText, "", CCGetRequestParam("login_id", $Method, NULL), $this);
            $this->login_pw = new clsControl(ccsTextBox, "login_pw", "Password", ccsText, "", CCGetRequestParam("login_pw", $Method, NULL), $this);
            $this->login_pw1 = new clsControl(ccsTextBox, "login_pw1", "Confirm Password", ccsText, "", CCGetRequestParam("login_pw1", $Method, NULL), $this);
            if(!$this->FormSubmitted) {
                if(!is_array($this->country_id->Value) && !strlen($this->country_id->Value) && $this->country_id->Value !== false)
                    $this->country_id->SetText(99);
            }
        }
    }
//End Class_Initialize Event

//Initialize Method @37-7FB029A0
    function Initialize()
    {

        if(!$this->Visible)
            return;

        $this->DataSource->Parameters["sesclix_client_code"] = CCGetSession("clix_client_code", NULL);
    }
//End Initialize Method

//Validate Method @37-9326C8A2
    function Validate()
    {
        global $CCSLocales;
        $Validation = true;
        $Where = "";
        $Validation = ($this->address->Validate() && $Validation);
        $Validation = ($this->pin->Validate() && $Validation);
        $Validation = ($this->phone->Validate() && $Validation);
        $Validation = ($this->city->Validate() && $Validation);
        $Validation = ($this->country_id->Validate() && $Validation);
        $Validation = ($this->fname->Validate() && $Validation);
        $Validation = ($this->lname->Validate() && $Validation);
        $Validation = ($this->company->Validate() && $Validation);
        $Validation = ($this->state->Validate() && $Validation);
        $Validation = ($this->flg_enable->Validate() && $Validation);
        $Validation = ($this->Captcha1->Validate() && $Validation);
        $Validation = ($this->login_id->Validate() && $Validation);
        $Validation = ($this->login_pw->Validate() && $Validation);
        $Validation = ($this->login_pw1->Validate() && $Validation);
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "OnValidate", $this);
        $Validation =  $Validation && ($this->address->Errors->Count() == 0);
        $Validation =  $Validation && ($this->pin->Errors->Count() == 0);
        $Validation =  $Validation && ($this->phone->Errors->Count() == 0);
        $Validation =  $Validation && ($this->city->Errors->Count() == 0);
        $Validation =  $Validation && ($this->country_id->Errors->Count() == 0);
        $Validation =  $Validation && ($this->fname->Errors->Count() == 0);
        $Validation =  $Validation && ($this->lname->Errors->Count() == 0);
        $Validation =  $Validation && ($this->company->Errors->Count() == 0);
        $Validation =  $Validation && ($this->state->Errors->Count() == 0);
        $Validation =  $Validation && ($this->flg_enable->Errors->Count() == 0);
        $Validation =  $Validation && ($this->Captcha1->Errors->Count() == 0);
        $Validation =  $Validation && ($this->login_id->Errors->Count() == 0);
        $Validation =  $Validation && ($this->login_pw->Errors->Count() == 0);
        $Validation =  $Validation && ($this->login_pw1->Errors->Count() == 0);
        return (($this->Errors->Count() == 0) && $Validation);
    }
//End Validate Method

//CheckErrors Method @37-0D19793F
    function CheckErrors()
    {
        $errors = false;
        $errors = ($errors || $this->address->Errors->Count());
        $errors = ($errors || $this->pin->Errors->Count());
        $errors = ($errors || $this->phone->Errors->Count());
        $errors = ($errors || $this->city->Errors->Count());
        $errors = ($errors || $this->country_id->Errors->Count());
        $errors = ($errors || $this->fname->Errors->Count());
        $errors = ($errors || $this->lname->Errors->Count());
        $errors = ($errors || $this->company->Errors->Count());
        $errors = ($errors || $this->state->Errors->Count());
        $errors = ($errors || $this->flg_enable->Errors->Count());
        $errors = ($errors || $this->Captcha1->Errors->Count());
        $errors = ($errors || $this->login_id->Errors->Count());
        $errors = ($errors || $this->login_pw->Errors->Count());
        $errors = ($errors || $this->login_pw1->Errors->Count());
        $errors = ($errors || $this->Errors->Count());
        $errors = ($errors || $this->DataSource->Errors->Count());
        return $errors;
    }
//End CheckErrors Method

//MasterDetail @37-ED598703
function SetPrimaryKeys($keyArray)
{
    $this->PrimaryKeys = $keyArray;
}
function GetPrimaryKeys()
{
    return $this->PrimaryKeys;
}
function GetPrimaryKey($keyName)
{
    return $this->PrimaryKeys[$keyName];
}
//End MasterDetail

//Operation Method @37-E955BD63
    function Operation()
    {
        if(!$this->Visible)
            return;

        global $Redirect;
        global $FileName;

        $this->DataSource->Prepare();
        if(!$this->FormSubmitted) {
            $this->EditMode = $this->DataSource->AllParametersSet;
            return;
        }

        if($this->FormSubmitted) {
            $this->PressedButton = $this->EditMode ? "Button_Update" : "Button_Insert";
            if($this->Button_Insert->Pressed) {
                $this->PressedButton = "Button_Insert";
            } else if($this->Button_Update->Pressed) {
                $this->PressedButton = "Button_Update";
            }
        }
        $Redirect = $FileName . "?" . CCGetQueryString("QueryString", array("ccsForm"));
        if($this->Validate()) {
            if($this->PressedButton == "Button_Insert") {
                if(!CCGetEvent($this->Button_Insert->CCSEvents, "OnClick", $this->Button_Insert) || !$this->InsertRow()) {
                    $Redirect = "";
                }
            } else if($this->PressedButton == "Button_Update") {
                if(!CCGetEvent($this->Button_Update->CCSEvents, "OnClick", $this->Button_Update) || !$this->UpdateRow()) {
                    $Redirect = "";
                }
            }
        } else {
            $Redirect = "";
        }
        if ($Redirect)
            $this->DataSource->close();
    }
//End Operation Method

//InsertRow Method @37-6242A9C5
    function InsertRow()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeInsert", $this);
        if(!$this->InsertAllowed) return false;
        $this->DataSource->address->SetValue($this->address->GetValue(true));
        $this->DataSource->pin->SetValue($this->pin->GetValue(true));
        $this->DataSource->phone->SetValue($this->phone->GetValue(true));
        $this->DataSource->city->SetValue($this->city->GetValue(true));
        $this->DataSource->country_id->SetValue($this->country_id->GetValue(true));
        $this->DataSource->fname->SetValue($this->fname->GetValue(true));
        $this->DataSource->lname->SetValue($this->lname->GetValue(true));
        $this->DataSource->company->SetValue($this->company->GetValue(true));
        $this->DataSource->state->SetValue($this->state->GetValue(true));
        $this->DataSource->flg_enable->SetValue($this->flg_enable->GetValue(true));
        $this->DataSource->login_id->SetValue($this->login_id->GetValue(true));
        $this->DataSource->login_pw->SetValue($this->login_pw->GetValue(true));
        $this->DataSource->login_pw1->SetValue($this->login_pw1->GetValue(true));
        $this->DataSource->Insert();
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterInsert", $this);
        return (!$this->CheckErrors());
    }
//End InsertRow Method

//UpdateRow Method @37-9A3CD629
    function UpdateRow()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeUpdate", $this);
        if(!$this->UpdateAllowed) return false;
        $this->DataSource->address->SetValue($this->address->GetValue(true));
        $this->DataSource->pin->SetValue($this->pin->GetValue(true));
        $this->DataSource->phone->SetValue($this->phone->GetValue(true));
        $this->DataSource->city->SetValue($this->city->GetValue(true));
        $this->DataSource->country_id->SetValue($this->country_id->GetValue(true));
        $this->DataSource->fname->SetValue($this->fname->GetValue(true));
        $this->DataSource->lname->SetValue($this->lname->GetValue(true));
        $this->DataSource->company->SetValue($this->company->GetValue(true));
        $this->DataSource->state->SetValue($this->state->GetValue(true));
        $this->DataSource->flg_enable->SetValue($this->flg_enable->GetValue(true));
        $this->DataSource->login_id->SetValue($this->login_id->GetValue(true));
        $this->DataSource->login_pw->SetValue($this->login_pw->GetValue(true));
        $this->DataSource->login_pw1->SetValue($this->login_pw1->GetValue(true));
        $this->DataSource->Update();
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterUpdate", $this);
        return (!$this->CheckErrors());
    }
//End UpdateRow Method

//Show Method @37-E414201D
    function Show()
    {
        global $CCSUseAmp;
        global $Tpl;
        global $FileName;
        global $CCSLocales;
        $Error = "";

        if(!$this->Visible)
            return;

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeSelect", $this);

        $this->country_id->Prepare();

        $RecordBlock = "Record " . $this->ComponentName;
        $ParentPath = $Tpl->block_path;
        $Tpl->block_path = $ParentPath . "/" . $RecordBlock;
        $this->EditMode = $this->EditMode && $this->ReadAllowed;
        if($this->EditMode) {
            if($this->DataSource->Errors->Count()){
                $this->Errors->AddErrors($this->DataSource->Errors);
                $this->DataSource->Errors->clear();
            }
            $this->DataSource->Open();
            if($this->DataSource->Errors->Count() == 0 && $this->DataSource->next_record()) {
                $this->DataSource->SetValues();
                if(!$this->FormSubmitted){
                    $this->address->SetValue($this->DataSource->address->GetValue());
                    $this->pin->SetValue($this->DataSource->pin->GetValue());
                    $this->phone->SetValue($this->DataSource->phone->GetValue());
                    $this->city->SetValue($this->DataSource->city->GetValue());
                    $this->country_id->SetValue($this->DataSource->country_id->GetValue());
                    $this->fname->SetValue($this->DataSource->fname->GetValue());
                    $this->lname->SetValue($this->DataSource->lname->GetValue());
                    $this->company->SetValue($this->DataSource->company->GetValue());
                    $this->state->SetValue($this->DataSource->state->GetValue());
                    $this->login_id->SetValue($this->DataSource->login_id->GetValue());
                    $this->login_pw->SetValue($this->DataSource->login_pw->GetValue());
                }
            } else {
                $this->EditMode = false;
            }
        }
        if (!$this->FormSubmitted) {
        }

        if($this->FormSubmitted || $this->CheckErrors()) {
            $Error = "";
            $Error = ComposeStrings($Error, $this->address->Errors->ToString());
            $Error = ComposeStrings($Error, $this->pin->Errors->ToString());
            $Error = ComposeStrings($Error, $this->phone->Errors->ToString());
            $Error = ComposeStrings($Error, $this->city->Errors->ToString());
            $Error = ComposeStrings($Error, $this->country_id->Errors->ToString());
            $Error = ComposeStrings($Error, $this->fname->Errors->ToString());
            $Error = ComposeStrings($Error, $this->lname->Errors->ToString());
            $Error = ComposeStrings($Error, $this->company->Errors->ToString());
            $Error = ComposeStrings($Error, $this->state->Errors->ToString());
            $Error = ComposeStrings($Error, $this->flg_enable->Errors->ToString());
            $Error = ComposeStrings($Error, $this->Captcha1->Errors->ToString());
            $Error = ComposeStrings($Error, $this->login_id->Errors->ToString());
            $Error = ComposeStrings($Error, $this->login_pw->Errors->ToString());
            $Error = ComposeStrings($Error, $this->login_pw1->Errors->ToString());
            $Error = ComposeStrings($Error, $this->Errors->ToString());
            $Error = ComposeStrings($Error, $this->DataSource->Errors->ToString());
            $Tpl->SetVar("Error", $Error);
            $Tpl->Parse("Error", false);
        }
        $CCSForm = $this->EditMode ? $this->ComponentName . ":" . "Edit" : $this->ComponentName;
        $this->HTMLFormAction = $FileName . "?" . CCAddParam(CCGetQueryString("QueryString", ""), "ccsForm", $CCSForm);
        $Tpl->SetVar("Action", !$CCSUseAmp ? $this->HTMLFormAction : str_replace("&", "&amp;", $this->HTMLFormAction));
        $Tpl->SetVar("HTMLFormName", $this->ComponentName);
        $Tpl->SetVar("HTMLFormEnctype", $this->FormEnctype);
        $this->Button_Insert->Visible = !$this->EditMode && $this->InsertAllowed;
        $this->Button_Update->Visible = $this->EditMode && $this->UpdateAllowed;

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShow", $this);
        $this->Attributes->Show();
        if(!$this->Visible) {
            $Tpl->block_path = $ParentPath;
            return;
        }

        $this->Button_Insert->Show();
        $this->Button_Update->Show();
        $this->address->Show();
        $this->pin->Show();
        $this->phone->Show();
        $this->city->Show();
        $this->country_id->Show();
        $this->fname->Show();
        $this->lname->Show();
        $this->company->Show();
        $this->state->Show();
        $this->flg_enable->Show();
        $this->Captcha1->Show();
        $this->login_id->Show();
        $this->login_pw->Show();
        $this->login_pw1->Show();
        $Tpl->parse();
        $Tpl->block_path = $ParentPath;
        $this->DataSource->close();
    }
//End Show Method

} //End signup Class @37-FCB6E20C

class clssignupDataSource extends clsDBConnection1 {  //signupDataSource Class @37-334FC86E

//DataSource Variables @37-83EB0747
    public $Parent = "";
    public $CCSEvents = "";
    public $CCSEventResult;
    public $ErrorBlock;
    public $CmdExecution;

    public $InsertParameters;
    public $UpdateParameters;
    public $wp;
    public $AllParametersSet;

    public $InsertFields = array();
    public $UpdateFields = array();

    // Datasource fields
    public $address;
    public $pin;
    public $phone;
    public $city;
    public $country_id;
    public $fname;
    public $lname;
    public $company;
    public $state;
    public $flg_enable;
    public $login_id;
    public $login_pw;
    public $login_pw1;
//End DataSource Variables

//DataSourceClass_Initialize Event @37-A2B109BF
    function clssignupDataSource(& $Parent)
    {
        $this->Parent = & $Parent;
        $this->ErrorBlock = "Record signup/Error";
        $this->Initialize();
        $this->address = new clsField("address", ccsText, "");
        
        $this->pin = new clsField("pin", ccsText, "");
        
        $this->phone = new clsField("phone", ccsText, "");
        
        $this->city = new clsField("city", ccsText, "");
        
        $this->country_id = new clsField("country_id", ccsInteger, "");
        
        $this->fname = new clsField("fname", ccsText, "");
        
        $this->lname = new clsField("lname", ccsText, "");
        
        $this->company = new clsField("company", ccsText, "");
        
        $this->state = new clsField("state", ccsText, "");
        
        $this->flg_enable = new clsField("flg_enable", ccsText, "");
        
        $this->login_id = new clsField("login_id", ccsText, "");
        
        $this->login_pw = new clsField("login_pw", ccsText, "");
        
        $this->login_pw1 = new clsField("login_pw1", ccsText, "");
        

        $this->InsertFields["address"] = array("Name" => "address", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->InsertFields["pin"] = array("Name" => "pin", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->InsertFields["phone"] = array("Name" => "phone", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->InsertFields["city"] = array("Name" => "city", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->InsertFields["country_id"] = array("Name" => "country_id", "Value" => "", "DataType" => ccsInteger, "OmitIfEmpty" => 1);
        $this->InsertFields["fname"] = array("Name" => "fname", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->InsertFields["lname"] = array("Name" => "lname", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->InsertFields["company"] = array("Name" => "company", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->InsertFields["state"] = array("Name" => "state", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->InsertFields["login_id"] = array("Name" => "login_id", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->InsertFields["login_pw"] = array("Name" => "login_pw", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->UpdateFields["address"] = array("Name" => "address", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->UpdateFields["pin"] = array("Name" => "pin", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->UpdateFields["phone"] = array("Name" => "phone", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->UpdateFields["city"] = array("Name" => "city", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->UpdateFields["country_id"] = array("Name" => "country_id", "Value" => "", "DataType" => ccsInteger, "OmitIfEmpty" => 1);
        $this->UpdateFields["fname"] = array("Name" => "fname", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->UpdateFields["lname"] = array("Name" => "lname", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->UpdateFields["company"] = array("Name" => "company", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->UpdateFields["state"] = array("Name" => "state", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->UpdateFields["login_id"] = array("Name" => "login_id", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->UpdateFields["login_pw"] = array("Name" => "login_pw", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
    }
//End DataSourceClass_Initialize Event

//Prepare Method @37-ECA2F7EE
    function Prepare()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->wp = new clsSQLParameters($this->ErrorBlock);
        $this->wp->AddParameter("1", "sesclix_client_code", ccsInteger, "", "", $this->Parameters["sesclix_client_code"], "", false);
        $this->AllParametersSet = $this->wp->AllParamsSet();
        $this->wp->Criterion[1] = $this->wp->Operation(opEqual, "client_code", $this->wp->GetDBValue("1"), $this->ToSQL($this->wp->GetDBValue("1"), ccsInteger),false);
        $this->Where = 
             $this->wp->Criterion[1];
    }
//End Prepare Method

//Open Method @37-EEA7E372
    function Open()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildSelect", $this->Parent);
        $this->SQL = "SELECT * \n\n" .
        "FROM store_client {SQL_Where} {SQL_OrderBy}";
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteSelect", $this->Parent);
        $this->PageSize = 1;
        $this->query($this->OptimizeSQL(CCBuildSQL($this->SQL, $this->Where, $this->Order)));
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteSelect", $this->Parent);
    }
//End Open Method

//SetValues Method @37-33FF44D9
    function SetValues()
    {
        $this->address->SetDBValue($this->f("address"));
        $this->pin->SetDBValue($this->f("pin"));
        $this->phone->SetDBValue($this->f("phone"));
        $this->city->SetDBValue($this->f("city"));
        $this->country_id->SetDBValue(trim($this->f("country_id")));
        $this->fname->SetDBValue($this->f("fname"));
        $this->lname->SetDBValue($this->f("lname"));
        $this->company->SetDBValue($this->f("company"));
        $this->state->SetDBValue($this->f("state"));
        $this->login_id->SetDBValue($this->f("login_id"));
        $this->login_pw->SetDBValue($this->f("login_pw"));
    }
//End SetValues Method

//Insert Method @37-817BF1E9
    function Insert()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->CmdExecution = true;
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildInsert", $this->Parent);
        $this->InsertFields["address"]["Value"] = $this->address->GetDBValue(true);
        $this->InsertFields["pin"]["Value"] = $this->pin->GetDBValue(true);
        $this->InsertFields["phone"]["Value"] = $this->phone->GetDBValue(true);
        $this->InsertFields["city"]["Value"] = $this->city->GetDBValue(true);
        $this->InsertFields["country_id"]["Value"] = $this->country_id->GetDBValue(true);
        $this->InsertFields["fname"]["Value"] = $this->fname->GetDBValue(true);
        $this->InsertFields["lname"]["Value"] = $this->lname->GetDBValue(true);
        $this->InsertFields["company"]["Value"] = $this->company->GetDBValue(true);
        $this->InsertFields["state"]["Value"] = $this->state->GetDBValue(true);
        $this->InsertFields["login_id"]["Value"] = $this->login_id->GetDBValue(true);
        $this->InsertFields["login_pw"]["Value"] = $this->login_pw->GetDBValue(true);
        $this->SQL = CCBuildInsert("store_client", $this->InsertFields, $this);
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteInsert", $this->Parent);
        if($this->Errors->Count() == 0 && $this->CmdExecution) {
            $this->query($this->SQL);
            $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteInsert", $this->Parent);
        }
    }
//End Insert Method

//Update Method @37-3A830031
    function Update()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->CmdExecution = true;
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildUpdate", $this->Parent);
        $this->UpdateFields["address"]["Value"] = $this->address->GetDBValue(true);
        $this->UpdateFields["pin"]["Value"] = $this->pin->GetDBValue(true);
        $this->UpdateFields["phone"]["Value"] = $this->phone->GetDBValue(true);
        $this->UpdateFields["city"]["Value"] = $this->city->GetDBValue(true);
        $this->UpdateFields["country_id"]["Value"] = $this->country_id->GetDBValue(true);
        $this->UpdateFields["fname"]["Value"] = $this->fname->GetDBValue(true);
        $this->UpdateFields["lname"]["Value"] = $this->lname->GetDBValue(true);
        $this->UpdateFields["company"]["Value"] = $this->company->GetDBValue(true);
        $this->UpdateFields["state"]["Value"] = $this->state->GetDBValue(true);
        $this->UpdateFields["login_id"]["Value"] = $this->login_id->GetDBValue(true);
        $this->UpdateFields["login_pw"]["Value"] = $this->login_pw->GetDBValue(true);
        $this->SQL = CCBuildUpdate("store_client", $this->UpdateFields, $this);
        $this->SQL .= strlen($this->Where) ? " WHERE " . $this->Where : $this->Where;
        if (!strlen($this->Where) && $this->Errors->Count() == 0) 
            $this->Errors->addError($CCSLocales->GetText("CCS_CustomOperationError_MissingParameters"));
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteUpdate", $this->Parent);
        if($this->Errors->Count() == 0 && $this->CmdExecution) {
            $this->query($this->SQL);
            $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteUpdate", $this->Parent);
        }
    }
//End Update Method

} //End signupDataSource Class @37-FCB6E20C

class clsRecordlogin_success { //login_success Class @71-79CB821A

//Variables @71-9E315808

    // Public variables
    public $ComponentType = "Record";
    public $ComponentName;
    public $Parent;
    public $HTMLFormAction;
    public $PressedButton;
    public $Errors;
    public $ErrorBlock;
    public $FormSubmitted;
    public $FormEnctype;
    public $Visible;
    public $IsEmpty;

    public $CCSEvents = "";
    public $CCSEventResult;

    public $RelativePath = "";

    public $InsertAllowed = false;
    public $UpdateAllowed = false;
    public $DeleteAllowed = false;
    public $ReadAllowed   = false;
    public $EditMode      = false;
    public $ds;
    public $DataSource;
    public $ValidatingControls;
    public $Controls;
    public $Attributes;

    // Class variables
//End Variables

//Class_Initialize Event @71-4BDEEB73
    function clsRecordlogin_success($RelativePath, & $Parent)
    {

        global $FileName;
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->Visible = true;
        $this->Parent = & $Parent;
        $this->RelativePath = $RelativePath;
        $this->Errors = new clsErrors();
        $this->ErrorBlock = "Record login_success/Error";
        $this->DataSource = new clslogin_successDataSource($this);
        $this->ds = & $this->DataSource;
        $this->UpdateAllowed = true;
        $this->ReadAllowed = true;
        if($this->Visible)
        {
            $this->ComponentName = "login_success";
            $this->Attributes = new clsAttributes($this->ComponentName . ":");
            $CCSForm = explode(":", CCGetFromGet("ccsForm", ""), 2);
            if(sizeof($CCSForm) == 1)
                $CCSForm[1] = "";
            list($FormName, $FormMethod) = $CCSForm;
            $this->EditMode = ($FormMethod == "Edit");
            $this->FormEnctype = "application/x-www-form-urlencoded";
            $this->FormSubmitted = ($FormName == $this->ComponentName);
            $Method = $this->FormSubmitted ? ccsPost : ccsGet;
            $this->Button_Insert = new clsButton("Button_Insert", $Method, $this);
            $this->Button_Update = new clsButton("Button_Update", $Method, $this);
            $this->address = new clsControl(ccsTextArea, "address", "Address", ccsText, "", CCGetRequestParam("address", $Method, NULL), $this);
            $this->pin = new clsControl(ccsTextBox, "pin", "Pin", ccsText, "", CCGetRequestParam("pin", $Method, NULL), $this);
            $this->phone = new clsControl(ccsTextBox, "phone", "Phone", ccsText, "", CCGetRequestParam("phone", $Method, NULL), $this);
            $this->city = new clsControl(ccsTextBox, "city", "City", ccsText, "", CCGetRequestParam("city", $Method, NULL), $this);
            $this->country_id = new clsControl(ccsListBox, "country_id", "Country", ccsInteger, "", CCGetRequestParam("country_id", $Method, NULL), $this);
            $this->country_id->DSType = dsTable;
            $this->country_id->DataSource = new clsDBConnection1();
            $this->country_id->ds = & $this->country_id->DataSource;
            $this->country_id->DataSource->SQL = "SELECT * \n" .
"FROM mst_country {SQL_Where} {SQL_OrderBy}";
            $this->country_id->DataSource->Order = "country_name";
            list($this->country_id->BoundColumn, $this->country_id->TextColumn, $this->country_id->DBFormat) = array("country_id", "country_name", "");
            $this->country_id->DataSource->Order = "country_name";
            $this->fname = new clsControl(ccsTextBox, "fname", "First Name", ccsText, "", CCGetRequestParam("fname", $Method, NULL), $this);
            $this->lname = new clsControl(ccsTextBox, "lname", "Last Name", ccsText, "", CCGetRequestParam("lname", $Method, NULL), $this);
            $this->company = new clsControl(ccsTextBox, "company", "Organization", ccsText, "", CCGetRequestParam("company", $Method, NULL), $this);
            $this->state = new clsControl(ccsTextBox, "state", "State", ccsText, "", CCGetRequestParam("state", $Method, NULL), $this);
            $this->flg_enable = new clsControl(ccsHidden, "flg_enable", "flg_enable", ccsText, "", CCGetRequestParam("flg_enable", $Method, NULL), $this);
            $this->login_id = new clsControl(ccsTextBox, "login_id", "Email", ccsText, "", CCGetRequestParam("login_id", $Method, NULL), $this);
            if(!$this->FormSubmitted) {
                if(!is_array($this->country_id->Value) && !strlen($this->country_id->Value) && $this->country_id->Value !== false)
                    $this->country_id->SetText(99);
            }
        }
    }
//End Class_Initialize Event

//Initialize Method @71-EA6A74AB
    function Initialize()
    {

        if(!$this->Visible)
            return;

        $this->DataSource->Parameters["sesWUserID"] = CCGetSession("WUserID", NULL);
    }
//End Initialize Method

//Validate Method @71-36819173
    function Validate()
    {
        global $CCSLocales;
        $Validation = true;
        $Where = "";
        $Validation = ($this->address->Validate() && $Validation);
        $Validation = ($this->pin->Validate() && $Validation);
        $Validation = ($this->phone->Validate() && $Validation);
        $Validation = ($this->city->Validate() && $Validation);
        $Validation = ($this->country_id->Validate() && $Validation);
        $Validation = ($this->fname->Validate() && $Validation);
        $Validation = ($this->lname->Validate() && $Validation);
        $Validation = ($this->company->Validate() && $Validation);
        $Validation = ($this->state->Validate() && $Validation);
        $Validation = ($this->flg_enable->Validate() && $Validation);
        $Validation = ($this->login_id->Validate() && $Validation);
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "OnValidate", $this);
        $Validation =  $Validation && ($this->address->Errors->Count() == 0);
        $Validation =  $Validation && ($this->pin->Errors->Count() == 0);
        $Validation =  $Validation && ($this->phone->Errors->Count() == 0);
        $Validation =  $Validation && ($this->city->Errors->Count() == 0);
        $Validation =  $Validation && ($this->country_id->Errors->Count() == 0);
        $Validation =  $Validation && ($this->fname->Errors->Count() == 0);
        $Validation =  $Validation && ($this->lname->Errors->Count() == 0);
        $Validation =  $Validation && ($this->company->Errors->Count() == 0);
        $Validation =  $Validation && ($this->state->Errors->Count() == 0);
        $Validation =  $Validation && ($this->flg_enable->Errors->Count() == 0);
        $Validation =  $Validation && ($this->login_id->Errors->Count() == 0);
        return (($this->Errors->Count() == 0) && $Validation);
    }
//End Validate Method

//CheckErrors Method @71-1EFE6C86
    function CheckErrors()
    {
        $errors = false;
        $errors = ($errors || $this->address->Errors->Count());
        $errors = ($errors || $this->pin->Errors->Count());
        $errors = ($errors || $this->phone->Errors->Count());
        $errors = ($errors || $this->city->Errors->Count());
        $errors = ($errors || $this->country_id->Errors->Count());
        $errors = ($errors || $this->fname->Errors->Count());
        $errors = ($errors || $this->lname->Errors->Count());
        $errors = ($errors || $this->company->Errors->Count());
        $errors = ($errors || $this->state->Errors->Count());
        $errors = ($errors || $this->flg_enable->Errors->Count());
        $errors = ($errors || $this->login_id->Errors->Count());
        $errors = ($errors || $this->Errors->Count());
        $errors = ($errors || $this->DataSource->Errors->Count());
        return $errors;
    }
//End CheckErrors Method

//MasterDetail @71-ED598703
function SetPrimaryKeys($keyArray)
{
    $this->PrimaryKeys = $keyArray;
}
function GetPrimaryKeys()
{
    return $this->PrimaryKeys;
}
function GetPrimaryKey($keyName)
{
    return $this->PrimaryKeys[$keyName];
}
//End MasterDetail

//Operation Method @71-F39BE638
    function Operation()
    {
        if(!$this->Visible)
            return;

        global $Redirect;
        global $FileName;

        $this->DataSource->Prepare();
        if(!$this->FormSubmitted) {
            $this->EditMode = $this->DataSource->AllParametersSet;
            return;
        }

        if($this->FormSubmitted) {
            $this->PressedButton = $this->EditMode ? "Button_Update" : "Button_Insert";
            if($this->Button_Insert->Pressed) {
                $this->PressedButton = "Button_Insert";
            } else if($this->Button_Update->Pressed) {
                $this->PressedButton = "Button_Update";
            }
        }
        $Redirect = $FileName . "?" . CCGetQueryString("QueryString", array("ccsForm"));
        if($this->Validate()) {
            if($this->PressedButton == "Button_Insert") {
                if(!CCGetEvent($this->Button_Insert->CCSEvents, "OnClick", $this->Button_Insert)) {
                    $Redirect = "";
                }
            } else if($this->PressedButton == "Button_Update") {
                if(!CCGetEvent($this->Button_Update->CCSEvents, "OnClick", $this->Button_Update) || !$this->UpdateRow()) {
                    $Redirect = "";
                }
            }
        } else {
            $Redirect = "";
        }
        if ($Redirect)
            $this->DataSource->close();
    }
//End Operation Method

//UpdateRow Method @71-11CF2B02
    function UpdateRow()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeUpdate", $this);
        if(!$this->UpdateAllowed) return false;
        $this->DataSource->address->SetValue($this->address->GetValue(true));
        $this->DataSource->pin->SetValue($this->pin->GetValue(true));
        $this->DataSource->phone->SetValue($this->phone->GetValue(true));
        $this->DataSource->city->SetValue($this->city->GetValue(true));
        $this->DataSource->country_id->SetValue($this->country_id->GetValue(true));
        $this->DataSource->fname->SetValue($this->fname->GetValue(true));
        $this->DataSource->lname->SetValue($this->lname->GetValue(true));
        $this->DataSource->company->SetValue($this->company->GetValue(true));
        $this->DataSource->state->SetValue($this->state->GetValue(true));
        $this->DataSource->flg_enable->SetValue($this->flg_enable->GetValue(true));
        $this->DataSource->login_id->SetValue($this->login_id->GetValue(true));
        $this->DataSource->Update();
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterUpdate", $this);
        return (!$this->CheckErrors());
    }
//End UpdateRow Method

//Show Method @71-6296DD76
    function Show()
    {
        global $CCSUseAmp;
        global $Tpl;
        global $FileName;
        global $CCSLocales;
        $Error = "";

        if(!$this->Visible)
            return;

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeSelect", $this);

        $this->country_id->Prepare();

        $RecordBlock = "Record " . $this->ComponentName;
        $ParentPath = $Tpl->block_path;
        $Tpl->block_path = $ParentPath . "/" . $RecordBlock;
        $this->EditMode = $this->EditMode && $this->ReadAllowed;
        if($this->EditMode) {
            if($this->DataSource->Errors->Count()){
                $this->Errors->AddErrors($this->DataSource->Errors);
                $this->DataSource->Errors->clear();
            }
            $this->DataSource->Open();
            if($this->DataSource->Errors->Count() == 0 && $this->DataSource->next_record()) {
                $this->DataSource->SetValues();
                if(!$this->FormSubmitted){
                    $this->address->SetValue($this->DataSource->address->GetValue());
                    $this->pin->SetValue($this->DataSource->pin->GetValue());
                    $this->phone->SetValue($this->DataSource->phone->GetValue());
                    $this->city->SetValue($this->DataSource->city->GetValue());
                    $this->country_id->SetValue($this->DataSource->country_id->GetValue());
                    $this->fname->SetValue($this->DataSource->fname->GetValue());
                    $this->lname->SetValue($this->DataSource->lname->GetValue());
                    $this->company->SetValue($this->DataSource->company->GetValue());
                    $this->state->SetValue($this->DataSource->state->GetValue());
                    $this->login_id->SetValue($this->DataSource->login_id->GetValue());
                }
            } else {
                $this->EditMode = false;
            }
        }
        if (!$this->FormSubmitted) {
        }

        if($this->FormSubmitted || $this->CheckErrors()) {
            $Error = "";
            $Error = ComposeStrings($Error, $this->address->Errors->ToString());
            $Error = ComposeStrings($Error, $this->pin->Errors->ToString());
            $Error = ComposeStrings($Error, $this->phone->Errors->ToString());
            $Error = ComposeStrings($Error, $this->city->Errors->ToString());
            $Error = ComposeStrings($Error, $this->country_id->Errors->ToString());
            $Error = ComposeStrings($Error, $this->fname->Errors->ToString());
            $Error = ComposeStrings($Error, $this->lname->Errors->ToString());
            $Error = ComposeStrings($Error, $this->company->Errors->ToString());
            $Error = ComposeStrings($Error, $this->state->Errors->ToString());
            $Error = ComposeStrings($Error, $this->flg_enable->Errors->ToString());
            $Error = ComposeStrings($Error, $this->login_id->Errors->ToString());
            $Error = ComposeStrings($Error, $this->Errors->ToString());
            $Error = ComposeStrings($Error, $this->DataSource->Errors->ToString());
            $Tpl->SetVar("Error", $Error);
            $Tpl->Parse("Error", false);
        }
        $CCSForm = $this->EditMode ? $this->ComponentName . ":" . "Edit" : $this->ComponentName;
        $this->HTMLFormAction = $FileName . "?" . CCAddParam(CCGetQueryString("QueryString", ""), "ccsForm", $CCSForm);
        $Tpl->SetVar("Action", !$CCSUseAmp ? $this->HTMLFormAction : str_replace("&", "&amp;", $this->HTMLFormAction));
        $Tpl->SetVar("HTMLFormName", $this->ComponentName);
        $Tpl->SetVar("HTMLFormEnctype", $this->FormEnctype);
        $this->Button_Insert->Visible = !$this->EditMode && $this->InsertAllowed;
        $this->Button_Update->Visible = $this->EditMode && $this->UpdateAllowed;

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShow", $this);
        $this->Attributes->Show();
        if(!$this->Visible) {
            $Tpl->block_path = $ParentPath;
            return;
        }

        $this->Button_Insert->Show();
        $this->Button_Update->Show();
        $this->address->Show();
        $this->pin->Show();
        $this->phone->Show();
        $this->city->Show();
        $this->country_id->Show();
        $this->fname->Show();
        $this->lname->Show();
        $this->company->Show();
        $this->state->Show();
        $this->flg_enable->Show();
        $this->login_id->Show();
        $Tpl->parse();
        $Tpl->block_path = $ParentPath;
        $this->DataSource->close();
    }
//End Show Method

} //End login_success Class @71-FCB6E20C

class clslogin_successDataSource extends clsDBConnection1 {  //login_successDataSource Class @71-DA807CF7

//DataSource Variables @71-C14669C4
    public $Parent = "";
    public $CCSEvents = "";
    public $CCSEventResult;
    public $ErrorBlock;
    public $CmdExecution;

    public $UpdateParameters;
    public $wp;
    public $AllParametersSet;

    public $UpdateFields = array();

    // Datasource fields
    public $address;
    public $pin;
    public $phone;
    public $city;
    public $country_id;
    public $fname;
    public $lname;
    public $company;
    public $state;
    public $flg_enable;
    public $login_id;
//End DataSource Variables

//DataSourceClass_Initialize Event @71-37BA5463
    function clslogin_successDataSource(& $Parent)
    {
        $this->Parent = & $Parent;
        $this->ErrorBlock = "Record login_success/Error";
        $this->Initialize();
        $this->address = new clsField("address", ccsText, "");
        
        $this->pin = new clsField("pin", ccsText, "");
        
        $this->phone = new clsField("phone", ccsText, "");
        
        $this->city = new clsField("city", ccsText, "");
        
        $this->country_id = new clsField("country_id", ccsInteger, "");
        
        $this->fname = new clsField("fname", ccsText, "");
        
        $this->lname = new clsField("lname", ccsText, "");
        
        $this->company = new clsField("company", ccsText, "");
        
        $this->state = new clsField("state", ccsText, "");
        
        $this->flg_enable = new clsField("flg_enable", ccsText, "");
        
        $this->login_id = new clsField("login_id", ccsText, "");
        

        $this->UpdateFields["address"] = array("Name" => "address", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->UpdateFields["pin"] = array("Name" => "pin", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->UpdateFields["phone"] = array("Name" => "phone", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->UpdateFields["city"] = array("Name" => "city", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->UpdateFields["country_id"] = array("Name" => "country_id", "Value" => "", "DataType" => ccsInteger, "OmitIfEmpty" => 1);
        $this->UpdateFields["fname"] = array("Name" => "fname", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->UpdateFields["lname"] = array("Name" => "lname", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->UpdateFields["company"] = array("Name" => "company", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->UpdateFields["state"] = array("Name" => "state", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->UpdateFields["login_id"] = array("Name" => "login_id", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
    }
//End DataSourceClass_Initialize Event

//Prepare Method @71-105EFEC8
    function Prepare()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->wp = new clsSQLParameters($this->ErrorBlock);
        $this->wp->AddParameter("1", "sesWUserID", ccsInteger, "", "", $this->Parameters["sesWUserID"], "", false);
        $this->AllParametersSet = $this->wp->AllParamsSet();
        $this->wp->Criterion[1] = $this->wp->Operation(opEqual, "client_code", $this->wp->GetDBValue("1"), $this->ToSQL($this->wp->GetDBValue("1"), ccsInteger),false);
        $this->Where = 
             $this->wp->Criterion[1];
    }
//End Prepare Method

//Open Method @71-EEA7E372
    function Open()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildSelect", $this->Parent);
        $this->SQL = "SELECT * \n\n" .
        "FROM store_client {SQL_Where} {SQL_OrderBy}";
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteSelect", $this->Parent);
        $this->PageSize = 1;
        $this->query($this->OptimizeSQL(CCBuildSQL($this->SQL, $this->Where, $this->Order)));
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteSelect", $this->Parent);
    }
//End Open Method

//SetValues Method @71-5E933B2A
    function SetValues()
    {
        $this->address->SetDBValue($this->f("address"));
        $this->pin->SetDBValue($this->f("pin"));
        $this->phone->SetDBValue($this->f("phone"));
        $this->city->SetDBValue($this->f("city"));
        $this->country_id->SetDBValue(trim($this->f("country_id")));
        $this->fname->SetDBValue($this->f("fname"));
        $this->lname->SetDBValue($this->f("lname"));
        $this->company->SetDBValue($this->f("company"));
        $this->state->SetDBValue($this->f("state"));
        $this->login_id->SetDBValue($this->f("login_id"));
    }
//End SetValues Method

//Update Method @71-32914BDE
    function Update()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->CmdExecution = true;
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildUpdate", $this->Parent);
        $this->UpdateFields["address"]["Value"] = $this->address->GetDBValue(true);
        $this->UpdateFields["pin"]["Value"] = $this->pin->GetDBValue(true);
        $this->UpdateFields["phone"]["Value"] = $this->phone->GetDBValue(true);
        $this->UpdateFields["city"]["Value"] = $this->city->GetDBValue(true);
        $this->UpdateFields["country_id"]["Value"] = $this->country_id->GetDBValue(true);
        $this->UpdateFields["fname"]["Value"] = $this->fname->GetDBValue(true);
        $this->UpdateFields["lname"]["Value"] = $this->lname->GetDBValue(true);
        $this->UpdateFields["company"]["Value"] = $this->company->GetDBValue(true);
        $this->UpdateFields["state"]["Value"] = $this->state->GetDBValue(true);
        $this->UpdateFields["login_id"]["Value"] = $this->login_id->GetDBValue(true);
        $this->SQL = CCBuildUpdate("store_client", $this->UpdateFields, $this);
        $this->SQL .= strlen($this->Where) ? " WHERE " . $this->Where : $this->Where;
        if (!strlen($this->Where) && $this->Errors->Count() == 0) 
            $this->Errors->addError($CCSLocales->GetText("CCS_CustomOperationError_MissingParameters"));
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteUpdate", $this->Parent);
        if($this->Errors->Count() == 0 && $this->CmdExecution) {
            $this->query($this->SQL);
            $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteUpdate", $this->Parent);
        }
    }
//End Update Method

} //End login_successDataSource Class @71-FCB6E20C

//Initialize Page @1-21A2BCDE
// Variables
$FileName = "";
$Redirect = "";
$Tpl = "";
$TemplateFileName = "";
$BlockToParse = "";
$ComponentName = "";
$Attributes = "";

// Events;
$CCSEvents = "";
$CCSEventResult = "";

$FileName = FileName;
$Redirect = "";
$TemplateFileName = "checkout_login.html";
$BlockToParse = "main";
$TemplateEncoding = "UTF-8";
$ContentType = "text/html";
$PathToRoot = "../";
$Charset = $Charset ? $Charset : "utf-8";
//End Initialize Page

//Include events file @1-3FB57673
include_once("./checkout_login_events.php");
//End Include events file

//BeforeInitialize Binding @1-17AC9191
$CCSEvents["BeforeInitialize"] = "Page_BeforeInitialize";
//End BeforeInitialize Binding

//Before Initialize @1-E870CEBC
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeInitialize", $MainPage);
//End Before Initialize

//Initialize Objects @1-67CD1FD8
$DBConnection1 = new clsDBConnection1();
$MainPage->Connections["Connection1"] = & $DBConnection1;
$Attributes = new clsAttributes("page:");
$MainPage->Attributes = & $Attributes;

// Controls
$Login = new clsRecordLogin("", $MainPage);
$signup = new clsRecordsignup("", $MainPage);
$login_success = new clsRecordlogin_success("", $MainPage);
$MainPage->Login = & $Login;
$MainPage->signup = & $signup;
$MainPage->login_success = & $login_success;
$Login->Initialize();
$signup->Initialize();
$login_success->Initialize();

BindEvents();

$CCSEventResult = CCGetEvent($CCSEvents, "AfterInitialize", $MainPage);

if ($Charset) {
    header("Content-Type: " . $ContentType . "; charset=" . $Charset);
} else {
    header("Content-Type: " . $ContentType);
}
//End Initialize Objects

//Initialize HTML Template @1-FD7047F5
$CCSEventResult = CCGetEvent($CCSEvents, "OnInitializeView", $MainPage);
$Tpl = new clsTemplate($FileEncoding, $TemplateEncoding);
$Tpl->LoadTemplate(PathToCurrentPage . $TemplateFileName, $BlockToParse, "UTF-8", "replace");
$Tpl->block_path = "/$BlockToParse";
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeShow", $MainPage);
$Attributes->SetValue("pathToRoot", "../");
$Attributes->Show();
//End Initialize HTML Template

//Execute Components @1-0A8DB678
$Login->Operation();
$signup->Operation();
$login_success->Operation();
//End Execute Components

//Go to destination page @1-7F584048
if($Redirect)
{
    $CCSEventResult = CCGetEvent($CCSEvents, "BeforeUnload", $MainPage);
    $DBConnection1->close();
    header("Location: " . $Redirect);
    unset($Login);
    unset($signup);
    unset($login_success);
    unset($Tpl);
    exit;
}
//End Go to destination page

//Show Page @1-5C18ACB2
$Login->Show();
$signup->Show();
$login_success->Show();
$Tpl->block_path = "";
$Tpl->Parse($BlockToParse, false);
if (!isset($main_block)) $main_block = $Tpl->GetVar($BlockToParse);
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeOutput", $MainPage);
if ($CCSEventResult) echo $main_block;
//End Show Page

//Unload Page @1-12CB4D55
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeUnload", $MainPage);
$DBConnection1->close();
unset($Login);
unset($signup);
unset($login_success);
unset($Tpl);
//End Unload Page


?>
