<?php
//Include Common Files @1-51CD88CB
define("RelativePath", ".");
define("PathToCurrentPage", "/");
define("FileName", "z_received_enquiry.php");
include_once(RelativePath . "/Common.php");
include_once(RelativePath . "/Template.php");
include_once(RelativePath . "/Sorter.php");
include_once(RelativePath . "/Navigator.php");
//End Include Common Files

class clsGridbook_showcase_store_order { //book_showcase_store_order class @2-102AF140

//Variables @2-6E51DF5A

    // Public variables
    public $ComponentType = "Grid";
    public $ComponentName;
    public $Visible;
    public $Errors;
    public $ErrorBlock;
    public $ds;
    public $DataSource;
    public $PageSize;
    public $IsEmpty;
    public $ForceIteration = false;
    public $HasRecord = false;
    public $SorterName = "";
    public $SorterDirection = "";
    public $PageNumber;
    public $RowNumber;
    public $ControlsVisible = array();

    public $CCSEvents = "";
    public $CCSEventResult;

    public $RelativePath = "";
    public $Attributes;

    // Grid Controls
    public $StaticControls;
    public $RowControls;
//End Variables

//Class_Initialize Event @2-4EC79967
    function clsGridbook_showcase_store_order($RelativePath, & $Parent)
    {
        global $FileName;
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->ComponentName = "book_showcase_store_order";
        $this->Visible = True;
        $this->Parent = & $Parent;
        $this->RelativePath = $RelativePath;
        $this->Errors = new clsErrors();
        $this->ErrorBlock = "Grid book_showcase_store_order";
        $this->Attributes = new clsAttributes($this->ComponentName . ":");
        $this->DataSource = new clsbook_showcase_store_orderDataSource($this);
        $this->ds = & $this->DataSource;
        $this->PageSize = CCGetParam($this->ComponentName . "PageSize", "");
        if(!is_numeric($this->PageSize) || !strlen($this->PageSize))
            $this->PageSize = 100;
        else
            $this->PageSize = intval($this->PageSize);
        if ($this->PageSize > 100)
            $this->PageSize = 100;
        if($this->PageSize == 0)
            $this->Errors->addError("<p>Form: Grid " . $this->ComponentName . "<br>Error: (CCS06) Invalid page size.</p>");
        $this->PageNumber = intval(CCGetParam($this->ComponentName . "Page", 1));
        if ($this->PageNumber <= 0) $this->PageNumber = 1;

        $this->image_full = new clsControl(ccsImage, "image_full", "image_full", ccsText, "", CCGetRequestParam("image_full", ccsGet, NULL), $this);
        $this->item = new clsControl(ccsLabel, "item", "item", ccsText, "", CCGetRequestParam("item", ccsGet, NULL), $this);
        $this->isbn = new clsControl(ccsLabel, "isbn", "isbn", ccsText, "", CCGetRequestParam("isbn", ccsGet, NULL), $this);
        $this->net_price = new clsControl(ccsLabel, "net_price", "net_price", ccsFloat, array(False, 2, Null, Null, False, "", "", 1, True, ""), CCGetRequestParam("net_price", ccsGet, NULL), $this);
        $this->quantity = new clsControl(ccsLabel, "quantity", "quantity", ccsInteger, "", CCGetRequestParam("quantity", ccsGet, NULL), $this);
        $this->amount = new clsControl(ccsLabel, "amount", "amount", ccsFloat, array(False, 2, Null, Null, False, "", "", 1, True, ""), CCGetRequestParam("amount", ccsGet, NULL), $this);
    }
//End Class_Initialize Event

//Initialize Method @2-90E704C5
    function Initialize()
    {
        if(!$this->Visible) return;

        $this->DataSource->PageSize = & $this->PageSize;
        $this->DataSource->AbsolutePage = & $this->PageNumber;
        $this->DataSource->SetOrder($this->SorterName, $this->SorterDirection);
    }
//End Initialize Method

//Show Method @2-8ECC04E8
    function Show()
    {
        global $Tpl;
        global $CCSLocales;
        if(!$this->Visible) return;

        $this->RowNumber = 0;

        $this->DataSource->Parameters["urlenq"] = CCGetFromGet("enq", NULL);

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeSelect", $this);


        $this->DataSource->Prepare();
        $this->DataSource->Open();
        $this->HasRecord = $this->DataSource->has_next_record();
        $this->IsEmpty = ! $this->HasRecord;
        $this->Attributes->Show();

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShow", $this);
        if(!$this->Visible) return;

        $GridBlock = "Grid " . $this->ComponentName;
        $ParentPath = $Tpl->block_path;
        $Tpl->block_path = $ParentPath . "/" . $GridBlock;


        if (!$this->IsEmpty) {
            $this->ControlsVisible["image_full"] = $this->image_full->Visible;
            $this->ControlsVisible["item"] = $this->item->Visible;
            $this->ControlsVisible["isbn"] = $this->isbn->Visible;
            $this->ControlsVisible["net_price"] = $this->net_price->Visible;
            $this->ControlsVisible["quantity"] = $this->quantity->Visible;
            $this->ControlsVisible["amount"] = $this->amount->Visible;
            while ($this->ForceIteration || (($this->RowNumber < $this->PageSize) &&  ($this->HasRecord = $this->DataSource->has_next_record()))) {
                $this->RowNumber++;
                if ($this->HasRecord) {
                    $this->DataSource->next_record();
                    $this->DataSource->SetValues();
                }
                $Tpl->block_path = $ParentPath . "/" . $GridBlock . "/Row";
                $this->image_full->SetValue($this->DataSource->image_full->GetValue());
                $this->item->SetValue($this->DataSource->item->GetValue());
                $this->isbn->SetValue($this->DataSource->isbn->GetValue());
                $this->net_price->SetValue($this->DataSource->net_price->GetValue());
                $this->quantity->SetValue($this->DataSource->quantity->GetValue());
                $this->amount->SetValue($this->DataSource->amount->GetValue());
                $this->Attributes->SetValue("rowNumber", $this->RowNumber);
                $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShowRow", $this);
                $this->Attributes->Show();
                $this->image_full->Show();
                $this->item->Show();
                $this->isbn->Show();
                $this->net_price->Show();
                $this->quantity->Show();
                $this->amount->Show();
                $Tpl->block_path = $ParentPath . "/" . $GridBlock;
                $Tpl->parse("Row", true);
            }
        }
        else { // Show NoRecords block if no records are found
            $this->Attributes->Show();
            $Tpl->parse("NoRecords", false);
        }

        $errors = $this->GetErrors();
        if(strlen($errors))
        {
            $Tpl->replaceblock("", $errors);
            $Tpl->block_path = $ParentPath;
            return;
        }
        $Tpl->parse();
        $Tpl->block_path = $ParentPath;
        $this->DataSource->close();
    }
//End Show Method

//GetErrors Method @2-660E3B94
    function GetErrors()
    {
        $errors = "";
        $errors = ComposeStrings($errors, $this->image_full->Errors->ToString());
        $errors = ComposeStrings($errors, $this->item->Errors->ToString());
        $errors = ComposeStrings($errors, $this->isbn->Errors->ToString());
        $errors = ComposeStrings($errors, $this->net_price->Errors->ToString());
        $errors = ComposeStrings($errors, $this->quantity->Errors->ToString());
        $errors = ComposeStrings($errors, $this->amount->Errors->ToString());
        $errors = ComposeStrings($errors, $this->Errors->ToString());
        $errors = ComposeStrings($errors, $this->DataSource->Errors->ToString());
        return $errors;
    }
//End GetErrors Method

} //End book_showcase_store_order Class @2-FCB6E20C

class clsbook_showcase_store_orderDataSource extends clsDBConnection1 {  //book_showcase_store_orderDataSource Class @2-CCF1F78F

//DataSource Variables @2-959258B8
    public $Parent = "";
    public $CCSEvents = "";
    public $CCSEventResult;
    public $ErrorBlock;
    public $CmdExecution;

    public $CountSQL;
    public $wp;


    // Datasource fields
    public $image_full;
    public $item;
    public $isbn;
    public $net_price;
    public $quantity;
    public $amount;
//End DataSource Variables

//DataSourceClass_Initialize Event @2-94A7D061
    function clsbook_showcase_store_orderDataSource(& $Parent)
    {
        $this->Parent = & $Parent;
        $this->ErrorBlock = "Grid book_showcase_store_order";
        $this->Initialize();
        $this->image_full = new clsField("image_full", ccsText, "");
        
        $this->item = new clsField("item", ccsText, "");
        
        $this->isbn = new clsField("isbn", ccsText, "");
        
        $this->net_price = new clsField("net_price", ccsFloat, "");
        
        $this->quantity = new clsField("quantity", ccsInteger, "");
        
        $this->amount = new clsField("amount", ccsFloat, "");
        

    }
//End DataSourceClass_Initialize Event

//SetOrder Method @2-9E1383D1
    function SetOrder($SorterName, $SorterDirection)
    {
        $this->Order = "";
        $this->Order = CCGetOrder($this->Order, $SorterName, $SorterDirection, 
            "");
    }
//End SetOrder Method

//Prepare Method @2-29CE4ED1
    function Prepare()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->wp = new clsSQLParameters($this->ErrorBlock);
        $this->wp->AddParameter("1", "urlenq", ccsInteger, "", "", $this->Parameters["urlenq"], -1, false);
        $this->wp->Criterion[1] = $this->wp->Operation(opEqual, "store_order_items.order_id", $this->wp->GetDBValue("1"), $this->ToSQL($this->wp->GetDBValue("1"), ccsInteger),false);
        $this->Where = 
             $this->wp->Criterion[1];
    }
//End Prepare Method

//Open Method @2-7A231A9D
    function Open()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildSelect", $this->Parent);
        $this->CountSQL = "SELECT COUNT(*)\n\n" .
        "FROM (store_order_items INNER JOIN book_showcase ON\n\n" .
        "store_order_items.item_id = book_showcase.content_id) INNER JOIN store_orders ON\n\n" .
        "store_order_items.order_id = store_orders.order_id";
        $this->SQL = "SELECT quantity, amount, item, image_full, isbn, net_price, store_orders.order_id AS store_orders_order_id, order_date, name, company,\n\n" .
        "email, phone, address, message, total \n\n" .
        "FROM (store_order_items INNER JOIN book_showcase ON\n\n" .
        "store_order_items.item_id = book_showcase.content_id) INNER JOIN store_orders ON\n\n" .
        "store_order_items.order_id = store_orders.order_id {SQL_Where} {SQL_OrderBy}";
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteSelect", $this->Parent);
        if ($this->CountSQL) 
            $this->RecordsCount = CCGetDBValue(CCBuildSQL($this->CountSQL, $this->Where, ""), $this);
        else
            $this->RecordsCount = "CCS not counted";
        $this->query($this->OptimizeSQL(CCBuildSQL($this->SQL, $this->Where, $this->Order)));
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteSelect", $this->Parent);
    }
//End Open Method

//SetValues Method @2-05366784
    function SetValues()
    {
        $this->image_full->SetDBValue($this->f("image_full"));
        $this->item->SetDBValue($this->f("item"));
        $this->isbn->SetDBValue($this->f("isbn"));
        $this->net_price->SetDBValue(trim($this->f("net_price")));
        $this->quantity->SetDBValue(trim($this->f("quantity")));
        $this->amount->SetDBValue(trim($this->f("amount")));
    }
//End SetValues Method

} //End book_showcase_store_orderDataSource Class @2-FCB6E20C

//store_orders ReportGroup class @40-562DEF45
class clsReportGroupstore_orders {
    public $GroupType;
    public $mode; //1 - open, 2 - close
    public $order_id, $_order_idAttributes;
    public $order_date, $_order_dateAttributes;
    public $total, $_totalAttributes;
    public $name, $_nameAttributes;
    public $company, $_companyAttributes;
    public $email, $_emailAttributes;
    public $phone, $_phoneAttributes;
    public $website, $_websiteAttributes;
    public $address, $_addressAttributes;
    public $message, $_messageAttributes;
    public $Attributes;
    public $ReportTotalIndex = 0;
    public $PageTotalIndex;
    public $PageNumber;
    public $RowNumber;
    public $Parent;

    function clsReportGroupstore_orders(& $parent) {
        $this->Parent = & $parent;
        $this->Attributes = $this->Parent->Attributes->GetAsArray();
    }
    function SetControls($PrevGroup = "") {
        $this->order_id = $this->Parent->order_id->Value;
        $this->order_date = $this->Parent->order_date->Value;
        $this->total = $this->Parent->total->Value;
        $this->name = $this->Parent->name->Value;
        $this->company = $this->Parent->company->Value;
        $this->email = $this->Parent->email->Value;
        $this->phone = $this->Parent->phone->Value;
        $this->website = $this->Parent->website->Value;
        $this->address = $this->Parent->address->Value;
        $this->message = $this->Parent->message->Value;
    }

    function SetTotalControls($mode = "", $PrevGroup = "") {
        $this->_order_idAttributes = $this->Parent->order_id->Attributes->GetAsArray();
        $this->_order_dateAttributes = $this->Parent->order_date->Attributes->GetAsArray();
        $this->_totalAttributes = $this->Parent->total->Attributes->GetAsArray();
        $this->_nameAttributes = $this->Parent->name->Attributes->GetAsArray();
        $this->_companyAttributes = $this->Parent->company->Attributes->GetAsArray();
        $this->_emailAttributes = $this->Parent->email->Attributes->GetAsArray();
        $this->_phoneAttributes = $this->Parent->phone->Attributes->GetAsArray();
        $this->_websiteAttributes = $this->Parent->website->Attributes->GetAsArray();
        $this->_addressAttributes = $this->Parent->address->Attributes->GetAsArray();
        $this->_messageAttributes = $this->Parent->message->Attributes->GetAsArray();
    }
    function SyncWithHeader(& $Header) {
        $this->order_id = $Header->order_id;
        $Header->_order_idAttributes = $this->_order_idAttributes;
        $this->Parent->order_id->Value = $Header->order_id;
        $this->Parent->order_id->Attributes->RestoreFromArray($Header->_order_idAttributes);
        $this->order_date = $Header->order_date;
        $Header->_order_dateAttributes = $this->_order_dateAttributes;
        $this->Parent->order_date->Value = $Header->order_date;
        $this->Parent->order_date->Attributes->RestoreFromArray($Header->_order_dateAttributes);
        $this->total = $Header->total;
        $Header->_totalAttributes = $this->_totalAttributes;
        $this->Parent->total->Value = $Header->total;
        $this->Parent->total->Attributes->RestoreFromArray($Header->_totalAttributes);
        $this->name = $Header->name;
        $Header->_nameAttributes = $this->_nameAttributes;
        $this->Parent->name->Value = $Header->name;
        $this->Parent->name->Attributes->RestoreFromArray($Header->_nameAttributes);
        $this->company = $Header->company;
        $Header->_companyAttributes = $this->_companyAttributes;
        $this->Parent->company->Value = $Header->company;
        $this->Parent->company->Attributes->RestoreFromArray($Header->_companyAttributes);
        $this->email = $Header->email;
        $Header->_emailAttributes = $this->_emailAttributes;
        $this->Parent->email->Value = $Header->email;
        $this->Parent->email->Attributes->RestoreFromArray($Header->_emailAttributes);
        $this->phone = $Header->phone;
        $Header->_phoneAttributes = $this->_phoneAttributes;
        $this->Parent->phone->Value = $Header->phone;
        $this->Parent->phone->Attributes->RestoreFromArray($Header->_phoneAttributes);
        $this->website = $Header->website;
        $Header->_websiteAttributes = $this->_websiteAttributes;
        $this->Parent->website->Value = $Header->website;
        $this->Parent->website->Attributes->RestoreFromArray($Header->_websiteAttributes);
        $this->address = $Header->address;
        $Header->_addressAttributes = $this->_addressAttributes;
        $this->Parent->address->Value = $Header->address;
        $this->Parent->address->Attributes->RestoreFromArray($Header->_addressAttributes);
        $this->message = $Header->message;
        $Header->_messageAttributes = $this->_messageAttributes;
        $this->Parent->message->Value = $Header->message;
        $this->Parent->message->Attributes->RestoreFromArray($Header->_messageAttributes);
    }
    function ChangeTotalControls() {
    }
}
//End store_orders ReportGroup class

//store_orders GroupsCollection class @40-BC664AC4
class clsGroupsCollectionstore_orders {
    public $Groups;
    public $mPageCurrentHeaderIndex;
    public $PageSize;
    public $TotalPages = 0;
    public $TotalRows = 0;
    public $CurrentPageSize = 0;
    public $Pages;
    public $Parent;
    public $LastDetailIndex;

    function clsGroupsCollectionstore_orders(& $parent) {
        $this->Parent = & $parent;
        $this->Groups = array();
        $this->Pages  = array();
        $this->mReportTotalIndex = 0;
        $this->mPageTotalIndex = 1;
    }

    function & InitGroup() {
        $group = new clsReportGroupstore_orders($this->Parent);
        $group->RowNumber = $this->TotalRows + 1;
        $group->PageNumber = $this->TotalPages;
        $group->PageTotalIndex = $this->mPageCurrentHeaderIndex;
        return $group;
    }

    function RestoreValues() {
        $this->Parent->order_id->Value = $this->Parent->order_id->initialValue;
        $this->Parent->order_date->Value = $this->Parent->order_date->initialValue;
        $this->Parent->total->Value = $this->Parent->total->initialValue;
        $this->Parent->name->Value = $this->Parent->name->initialValue;
        $this->Parent->company->Value = $this->Parent->company->initialValue;
        $this->Parent->email->Value = $this->Parent->email->initialValue;
        $this->Parent->phone->Value = $this->Parent->phone->initialValue;
        $this->Parent->website->Value = $this->Parent->website->initialValue;
        $this->Parent->address->Value = $this->Parent->address->initialValue;
        $this->Parent->message->Value = $this->Parent->message->initialValue;
    }

    function OpenPage() {
        $this->TotalPages++;
        $Group = & $this->InitGroup();
        $this->Parent->Page_Header->CCSEventResult = CCGetEvent($this->Parent->Page_Header->CCSEvents, "OnInitialize", $this->Parent->Page_Header);
        if ($this->Parent->Page_Header->Visible)
            $this->CurrentPageSize = $this->CurrentPageSize + $this->Parent->Page_Header->Height;
        $Group->SetTotalControls("GetNextValue");
        $this->Parent->Page_Header->CCSEventResult = CCGetEvent($this->Parent->Page_Header->CCSEvents, "OnCalculate", $this->Parent->Page_Header);
        $Group->SetControls();
        $Group->Mode = 1;
        $Group->GroupType = "Page";
        $Group->PageTotalIndex = count($this->Groups);
        $this->mPageCurrentHeaderIndex = count($this->Groups);
        $this->Groups[] =  & $Group;
        $this->Pages[] =  count($this->Groups) == 2 ? 0 : count($this->Groups) - 1;
    }

    function OpenGroup($groupName) {
        $Group = "";
        $OpenFlag = false;
        if ($groupName == "Report") {
            $Group = & $this->InitGroup(true);
            $this->Parent->Report_Header->CCSEventResult = CCGetEvent($this->Parent->Report_Header->CCSEvents, "OnInitialize", $this->Parent->Report_Header);
            if ($this->Parent->Report_Header->Visible) 
                $this->CurrentPageSize = $this->CurrentPageSize + $this->Parent->Report_Header->Height;
                $Group->SetTotalControls("GetNextValue");
            $this->Parent->Report_Header->CCSEventResult = CCGetEvent($this->Parent->Report_Header->CCSEvents, "OnCalculate", $this->Parent->Report_Header);
            $Group->SetControls();
            $Group->Mode = 1;
            $Group->GroupType = "Report";
            $this->Groups[] = & $Group;
            $this->OpenPage();
        }
    }

    function ClosePage() {
        $Group = & $this->InitGroup();
        $this->Parent->Page_Footer->CCSEventResult = CCGetEvent($this->Parent->Page_Footer->CCSEvents, "OnInitialize", $this->Parent->Page_Footer);
        $Group->SetTotalControls("GetPrevValue");
        $Group->SyncWithHeader($this->Groups[$this->mPageCurrentHeaderIndex]);
        $this->Parent->Page_Footer->CCSEventResult = CCGetEvent($this->Parent->Page_Footer->CCSEvents, "OnCalculate", $this->Parent->Page_Footer);
        $Group->SetControls();
        $this->RestoreValues();
        $this->CurrentPageSize = 0;
        $Group->Mode = 2;
        $Group->GroupType = "Page";
        $this->Groups[] = & $Group;
    }

    function CloseGroup($groupName)
    {
        $Group = "";
        if ($groupName == "Report") {
            $Group = & $this->InitGroup(true);
            $this->Parent->Report_Footer->CCSEventResult = CCGetEvent($this->Parent->Report_Footer->CCSEvents, "OnInitialize", $this->Parent->Report_Footer);
            if ($this->Parent->Page_Footer->Visible) 
                $OverSize = $this->Parent->Report_Footer->Height + $this->Parent->Page_Footer->Height;
            else
                $OverSize = $this->Parent->Report_Footer->Height;
            if (($this->PageSize > 0) and $this->Parent->Report_Footer->Visible and ($this->CurrentPageSize + $OverSize > $this->PageSize)) {
                $this->ClosePage();
                $this->OpenPage();
            }
            $Group->SetTotalControls("GetPrevValue");
            $Group->SyncWithHeader($this->Groups[0]);
            if ($this->Parent->Report_Footer->Visible)
                $this->CurrentPageSize = $this->CurrentPageSize + $this->Parent->Report_Footer->Height;
            $this->Parent->Report_Footer->CCSEventResult = CCGetEvent($this->Parent->Report_Footer->CCSEvents, "OnCalculate", $this->Parent->Report_Footer);
            $Group->SetControls();
            $this->RestoreValues();
            $Group->Mode = 2;
            $Group->GroupType = "Report";
            $this->Groups[] = & $Group;
            $this->ClosePage();
            return;
        }
    }

    function AddItem()
    {
        $Group = & $this->InitGroup(true);
        $this->Parent->Detail->CCSEventResult = CCGetEvent($this->Parent->Detail->CCSEvents, "OnInitialize", $this->Parent->Detail);
        if ($this->Parent->Page_Footer->Visible) 
            $OverSize = $this->Parent->Detail->Height + $this->Parent->Page_Footer->Height;
        else
            $OverSize = $this->Parent->Detail->Height;
        if (($this->PageSize > 0) and $this->Parent->Detail->Visible and ($this->CurrentPageSize + $OverSize > $this->PageSize)) {
            $this->ClosePage();
            $this->OpenPage();
        }
        $this->TotalRows++;
        if ($this->LastDetailIndex)
            $PrevGroup = & $this->Groups[$this->LastDetailIndex];
        else
            $PrevGroup = "";
        $Group->SetTotalControls("", $PrevGroup);
        if ($this->Parent->Detail->Visible)
            $this->CurrentPageSize = $this->CurrentPageSize + $this->Parent->Detail->Height;
        $this->Parent->Detail->CCSEventResult = CCGetEvent($this->Parent->Detail->CCSEvents, "OnCalculate", $this->Parent->Detail);
        $Group->SetControls($PrevGroup);
        $this->LastDetailIndex = count($this->Groups);
        $this->Groups[] = & $Group;
    }
}
//End store_orders GroupsCollection class

class clsReportstore_orders { //store_orders Class @40-0E8E7752

//store_orders Variables @40-944D286E

    public $ComponentType = "Report";
    public $PageSize;
    public $ComponentName;
    public $Visible;
    public $Errors;
    public $CCSEvents = array();
    public $CCSEventResult;
    public $RelativePath = "";
    public $ViewMode = "Web";
    public $TemplateBlock;
    public $PageNumber;
    public $RowNumber;
    public $TotalRows;
    public $TotalPages;
    public $ControlsVisible = array();
    public $IsEmpty;
    public $Attributes;
    public $DetailBlock, $Detail;
    public $Report_FooterBlock, $Report_Footer;
    public $Report_HeaderBlock, $Report_Header;
    public $Page_FooterBlock, $Page_Footer;
    public $Page_HeaderBlock, $Page_Header;
    public $SorterName, $SorterDirection;

    public $ds;
    public $DataSource;
    public $UseClientPaging = false;

    //Report Controls
    public $StaticControls, $RowControls, $Report_FooterControls, $Report_HeaderControls;
    public $Page_FooterControls, $Page_HeaderControls;
//End store_orders Variables

//Class_Initialize Event @40-C3BC0C7C
    function clsReportstore_orders($RelativePath = "", & $Parent)
    {
        global $FileName;
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->ComponentName = "store_orders";
        $this->Visible = True;
        $this->Parent = & $Parent;
        $this->RelativePath = $RelativePath;
        $this->Attributes = new clsAttributes($this->ComponentName . ":");
        $this->Detail = new clsSection($this);
        $MinPageSize = 0;
        $MaxSectionSize = 0;
        $this->Detail->Height = 10;
        $MaxSectionSize = max($MaxSectionSize, $this->Detail->Height);
        $this->Report_Footer = new clsSection($this);
        $this->Report_Header = new clsSection($this);
        $this->Page_Footer = new clsSection($this);
        $this->Page_Header = new clsSection($this);
        $this->Errors = new clsErrors();
        $this->DataSource = new clsstore_ordersDataSource($this);
        $this->ds = & $this->DataSource;
        $PageSize = CCGetParam($this->ComponentName . "PageSize", "");
        if(is_numeric($PageSize) && $PageSize > 0) {
            $this->PageSize = $PageSize;
        } else {
            if (!is_numeric($PageSize) || $PageSize < 0)
                $this->PageSize = 40;
             else if ($PageSize == "0")
                $this->PageSize = 100;
             else 
                $this->PageSize = min(100, $PageSize);
        }
        $MinPageSize += $MaxSectionSize;
        if ($this->PageSize && $MinPageSize && $this->PageSize < $MinPageSize)
            $this->PageSize = $MinPageSize;
        $this->PageNumber = $this->ViewMode == "Print" ? 1 : intval(CCGetParam($this->ComponentName . "Page", 1));
        if ($this->PageNumber <= 0 ) {
            $this->PageNumber = 1;
        }

        $this->order_id = new clsControl(ccsReportLabel, "order_id", "order_id", ccsInteger, "", "", $this);
        $this->order_date = new clsControl(ccsReportLabel, "order_date", "order_date", ccsDate, array("dd", " ", "mmm", ", ", "yyyy"), "", $this);
        $this->total = new clsControl(ccsReportLabel, "total", "total", ccsFloat, "", "", $this);
        $this->name = new clsControl(ccsReportLabel, "name", "name", ccsText, "", "", $this);
        $this->company = new clsControl(ccsReportLabel, "company", "company", ccsText, "", "", $this);
        $this->email = new clsControl(ccsReportLabel, "email", "email", ccsText, "", "", $this);
        $this->phone = new clsControl(ccsReportLabel, "phone", "phone", ccsText, "", "", $this);
        $this->website = new clsControl(ccsReportLabel, "website", "website", ccsText, "", "", $this);
        $this->address = new clsControl(ccsReportLabel, "address", "address", ccsText, "", "", $this);
        $this->message = new clsControl(ccsReportLabel, "message", "message", ccsMemo, "", "", $this);
        $this->NoRecords = new clsPanel("NoRecords", $this);
    }
//End Class_Initialize Event

//Initialize Method @40-6C59EE65
    function Initialize()
    {
        if(!$this->Visible) return;

        $this->DataSource->PageSize = $this->PageSize;
        $this->DataSource->AbsolutePage = $this->PageNumber;
        $this->DataSource->SetOrder($this->SorterName, $this->SorterDirection);
    }
//End Initialize Method

//CheckErrors Method @40-D93AB290
    function CheckErrors()
    {
        $errors = false;
        $errors = ($errors || $this->order_id->Errors->Count());
        $errors = ($errors || $this->order_date->Errors->Count());
        $errors = ($errors || $this->total->Errors->Count());
        $errors = ($errors || $this->name->Errors->Count());
        $errors = ($errors || $this->company->Errors->Count());
        $errors = ($errors || $this->email->Errors->Count());
        $errors = ($errors || $this->phone->Errors->Count());
        $errors = ($errors || $this->website->Errors->Count());
        $errors = ($errors || $this->address->Errors->Count());
        $errors = ($errors || $this->message->Errors->Count());
        $errors = ($errors || $this->Errors->Count());
        $errors = ($errors || $this->DataSource->Errors->Count());
        return $errors;
    }
//End CheckErrors Method

//GetErrors Method @40-CCF2C0A0
    function GetErrors()
    {
        $errors = "";
        $errors = ComposeStrings($errors, $this->order_id->Errors->ToString());
        $errors = ComposeStrings($errors, $this->order_date->Errors->ToString());
        $errors = ComposeStrings($errors, $this->total->Errors->ToString());
        $errors = ComposeStrings($errors, $this->name->Errors->ToString());
        $errors = ComposeStrings($errors, $this->company->Errors->ToString());
        $errors = ComposeStrings($errors, $this->email->Errors->ToString());
        $errors = ComposeStrings($errors, $this->phone->Errors->ToString());
        $errors = ComposeStrings($errors, $this->website->Errors->ToString());
        $errors = ComposeStrings($errors, $this->address->Errors->ToString());
        $errors = ComposeStrings($errors, $this->message->Errors->ToString());
        $errors = ComposeStrings($errors, $this->Errors->ToString());
        $errors = ComposeStrings($errors, $this->DataSource->Errors->ToString());
        return $errors;
    }
//End GetErrors Method

//Show Method @40-F51163D1
    function Show()
    {
        global $Tpl;
        global $CCSLocales;
        if(!$this->Visible) return;

        $ShownRecords = 0;

        $this->DataSource->Parameters["urlenq"] = CCGetFromGet("enq", NULL);

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeSelect", $this);


        $this->DataSource->Prepare();
        $this->DataSource->Open();

        $Groups = new clsGroupsCollectionstore_orders($this);
        $Groups->PageSize = $this->PageSize > 0 ? $this->PageSize : 0;

        $is_next_record = $this->DataSource->next_record();
        $this->IsEmpty = ! $is_next_record;
        while($is_next_record) {
            $this->DataSource->SetValues();
            $this->order_id->SetValue($this->DataSource->order_id->GetValue());
            $this->order_date->SetValue($this->DataSource->order_date->GetValue());
            $this->total->SetValue($this->DataSource->total->GetValue());
            $this->name->SetValue($this->DataSource->name->GetValue());
            $this->company->SetValue($this->DataSource->company->GetValue());
            $this->email->SetValue($this->DataSource->email->GetValue());
            $this->phone->SetValue($this->DataSource->phone->GetValue());
            $this->website->SetValue($this->DataSource->website->GetValue());
            $this->address->SetValue($this->DataSource->address->GetValue());
            $this->message->SetValue($this->DataSource->message->GetValue());
            if (count($Groups->Groups) == 0) $Groups->OpenGroup("Report");
            $Groups->AddItem();
            $is_next_record = $this->DataSource->next_record();
        }
        if (!count($Groups->Groups)) 
            $Groups->OpenGroup("Report");
        else
            $this->NoRecords->Visible = false;
        $Groups->CloseGroup("Report");
        $this->TotalPages = $Groups->TotalPages;
        $this->TotalRows = $Groups->TotalRows;

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShow", $this);
        if(!$this->Visible) return;

        $this->Attributes->Show();
        $ReportBlock = "Report " . $this->ComponentName;
        $ParentPath = $Tpl->block_path;
        $Tpl->block_path = $ParentPath . "/" . $ReportBlock;

        if($this->CheckErrors()) {
            $Tpl->replaceblock("", $this->GetErrors());
            $Tpl->block_path = $ParentPath;
            return;
        } else {
            $items = & $Groups->Groups;
            $i = $Groups->Pages[min($this->PageNumber, $Groups->TotalPages) - 1];
            $this->ControlsVisible["order_id"] = $this->order_id->Visible;
            $this->ControlsVisible["order_date"] = $this->order_date->Visible;
            $this->ControlsVisible["total"] = $this->total->Visible;
            $this->ControlsVisible["name"] = $this->name->Visible;
            $this->ControlsVisible["company"] = $this->company->Visible;
            $this->ControlsVisible["email"] = $this->email->Visible;
            $this->ControlsVisible["phone"] = $this->phone->Visible;
            $this->ControlsVisible["website"] = $this->website->Visible;
            $this->ControlsVisible["address"] = $this->address->Visible;
            $this->ControlsVisible["message"] = $this->message->Visible;
            do {
                $this->Attributes->RestoreFromArray($items[$i]->Attributes);
                $this->RowNumber = $items[$i]->RowNumber;
                switch ($items[$i]->GroupType) {
                    Case "":
                        $Tpl->block_path = $ParentPath . "/" . $ReportBlock . "/Section Detail";
                        $this->order_id->SetValue($items[$i]->order_id);
                        $this->order_id->Attributes->RestoreFromArray($items[$i]->_order_idAttributes);
                        $this->order_date->SetValue($items[$i]->order_date);
                        $this->order_date->Attributes->RestoreFromArray($items[$i]->_order_dateAttributes);
                        $this->total->SetValue($items[$i]->total);
                        $this->total->Attributes->RestoreFromArray($items[$i]->_totalAttributes);
                        $this->name->SetValue($items[$i]->name);
                        $this->name->Attributes->RestoreFromArray($items[$i]->_nameAttributes);
                        $this->company->SetValue($items[$i]->company);
                        $this->company->Attributes->RestoreFromArray($items[$i]->_companyAttributes);
                        $this->email->SetValue($items[$i]->email);
                        $this->email->Attributes->RestoreFromArray($items[$i]->_emailAttributes);
                        $this->phone->SetValue($items[$i]->phone);
                        $this->phone->Attributes->RestoreFromArray($items[$i]->_phoneAttributes);
                        $this->website->SetValue($items[$i]->website);
                        $this->website->Attributes->RestoreFromArray($items[$i]->_websiteAttributes);
                        $this->address->SetValue($items[$i]->address);
                        $this->address->Attributes->RestoreFromArray($items[$i]->_addressAttributes);
                        $this->message->SetValue($items[$i]->message);
                        $this->message->Attributes->RestoreFromArray($items[$i]->_messageAttributes);
                        $this->Detail->CCSEventResult = CCGetEvent($this->Detail->CCSEvents, "BeforeShow", $this->Detail);
                        $this->Attributes->Show();
                        $this->order_id->Show();
                        $this->order_date->Show();
                        $this->total->Show();
                        $this->name->Show();
                        $this->company->Show();
                        $this->email->Show();
                        $this->phone->Show();
                        $this->website->Show();
                        $this->address->Show();
                        $this->message->Show();
                        $Tpl->block_path = $ParentPath . "/" . $ReportBlock;
                        if ($this->Detail->Visible)
                            $Tpl->parseto("Section Detail", true, "Section Detail");
                        break;
                    case "Report":
                        if ($items[$i]->Mode == 1) {
                            $this->Report_Header->CCSEventResult = CCGetEvent($this->Report_Header->CCSEvents, "BeforeShow", $this->Report_Header);
                            if ($this->Report_Header->Visible) {
                                $Tpl->block_path = $ParentPath . "/" . $ReportBlock . "/Section Report_Header";
                                $this->Attributes->Show();
                                $Tpl->block_path = $ParentPath . "/" . $ReportBlock;
                                $Tpl->parseto("Section Report_Header", true, "Section Detail");
                            }
                        }
                        if ($items[$i]->Mode == 2) {
                            $this->Report_Footer->CCSEventResult = CCGetEvent($this->Report_Footer->CCSEvents, "BeforeShow", $this->Report_Footer);
                            if ($this->Report_Footer->Visible) {
                                $Tpl->block_path = $ParentPath . "/" . $ReportBlock . "/Section Report_Footer";
                                $this->NoRecords->Show();
                                $this->Attributes->Show();
                                $Tpl->block_path = $ParentPath . "/" . $ReportBlock;
                                $Tpl->parseto("Section Report_Footer", true, "Section Detail");
                            }
                        }
                        break;
                    case "Page":
                        if ($items[$i]->Mode == 1) {
                            $this->Page_Header->CCSEventResult = CCGetEvent($this->Page_Header->CCSEvents, "BeforeShow", $this->Page_Header);
                            if ($this->Page_Header->Visible) {
                                $Tpl->block_path = $ParentPath . "/" . $ReportBlock . "/Section Page_Header";
                                $this->Attributes->Show();
                                $Tpl->block_path = $ParentPath . "/" . $ReportBlock;
                                $Tpl->parseto("Section Page_Header", true, "Section Detail");
                            }
                        }
                        if ($items[$i]->Mode == 2 && !$this->UseClientPaging || $items[$i]->Mode == 1 && $this->UseClientPaging) {
                            $this->Page_Footer->CCSEventResult = CCGetEvent($this->Page_Footer->CCSEvents, "BeforeShow", $this->Page_Footer);
                            if ($this->Page_Footer->Visible) {
                                $Tpl->block_path = $ParentPath . "/" . $ReportBlock . "/Section Page_Footer";
                                $this->Attributes->Show();
                                $Tpl->block_path = $ParentPath . "/" . $ReportBlock;
                                $Tpl->parseto("Section Page_Footer", true, "Section Detail");
                            }
                        }
                        break;
                }
                $i++;
            } while ($i < count($items) && ($this->ViewMode == "Print" ||  !($i > 1 && $items[$i]->GroupType == 'Page' && $items[$i]->Mode == 1)));
            $Tpl->block_path = $ParentPath;
            $Tpl->parse($ReportBlock);
            $this->DataSource->close();
        }

    }
//End Show Method

} //End store_orders Class @40-FCB6E20C

class clsstore_ordersDataSource extends clsDBConnection1 {  //store_ordersDataSource Class @40-8686E7D7

//DataSource Variables @40-78D809AE
    public $Parent = "";
    public $CCSEvents = "";
    public $CCSEventResult;
    public $ErrorBlock;
    public $CmdExecution;

    public $wp;


    // Datasource fields
    public $order_id;
    public $order_date;
    public $total;
    public $name;
    public $company;
    public $email;
    public $phone;
    public $website;
    public $address;
    public $message;
//End DataSource Variables

//DataSourceClass_Initialize Event @40-9874312C
    function clsstore_ordersDataSource(& $Parent)
    {
        $this->Parent = & $Parent;
        $this->ErrorBlock = "Report store_orders";
        $this->Initialize();
        $this->order_id = new clsField("order_id", ccsInteger, "");
        
        $this->order_date = new clsField("order_date", ccsDate, array("yyyy", "-", "mm", "-", "dd", " ", "HH", ":", "nn", ":", "ss"));
        
        $this->total = new clsField("total", ccsFloat, "");
        
        $this->name = new clsField("name", ccsText, "");
        
        $this->company = new clsField("company", ccsText, "");
        
        $this->email = new clsField("email", ccsText, "");
        
        $this->phone = new clsField("phone", ccsText, "");
        
        $this->website = new clsField("website", ccsText, "");
        
        $this->address = new clsField("address", ccsText, "");
        
        $this->message = new clsField("message", ccsMemo, "");
        

    }
//End DataSourceClass_Initialize Event

//SetOrder Method @40-9E1383D1
    function SetOrder($SorterName, $SorterDirection)
    {
        $this->Order = "";
        $this->Order = CCGetOrder($this->Order, $SorterName, $SorterDirection, 
            "");
    }
//End SetOrder Method

//Prepare Method @40-EF442A34
    function Prepare()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->wp = new clsSQLParameters($this->ErrorBlock);
        $this->wp->AddParameter("1", "urlenq", ccsInteger, "", "", $this->Parameters["urlenq"], -1, false);
        $this->wp->Criterion[1] = $this->wp->Operation(opEqual, "order_id", $this->wp->GetDBValue("1"), $this->ToSQL($this->wp->GetDBValue("1"), ccsInteger),false);
        $this->Where = 
             $this->wp->Criterion[1];
    }
//End Prepare Method

//Open Method @40-7C289E44
    function Open()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildSelect", $this->Parent);
        $this->SQL = "SELECT * \n\n" .
        "FROM store_orders {SQL_Where} {SQL_OrderBy}";
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteSelect", $this->Parent);
        $this->query(CCBuildSQL($this->SQL, $this->Where, $this->Order));
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteSelect", $this->Parent);
    }
//End Open Method

//SetValues Method @40-27476669
    function SetValues()
    {
        $this->order_id->SetDBValue(trim($this->f("order_id")));
        $this->order_date->SetDBValue(trim($this->f("order_date")));
        $this->total->SetDBValue(trim($this->f("total")));
        $this->name->SetDBValue($this->f("name"));
        $this->company->SetDBValue($this->f("company"));
        $this->email->SetDBValue($this->f("email"));
        $this->phone->SetDBValue($this->f("phone"));
        $this->website->SetDBValue($this->f("website"));
        $this->address->SetDBValue($this->f("address"));
        $this->message->SetDBValue($this->f("message"));
    }
//End SetValues Method

} //End store_ordersDataSource Class @40-FCB6E20C

//Initialize Page @1-26DDB6F1
// Variables
$FileName = "";
$Redirect = "";
$Tpl = "";
$TemplateFileName = "";
$BlockToParse = "";
$ComponentName = "";
$Attributes = "";

// Events;
$CCSEvents = "";
$CCSEventResult = "";

$FileName = FileName;
$Redirect = "";
$TemplateFileName = "z_received_enquiry.html";
$BlockToParse = "main";
$TemplateEncoding = "UTF-8";
$ContentType = "text/html";
$PathToRoot = "./";
$Charset = $Charset ? $Charset : "utf-8";
//End Initialize Page

//Include events file @1-E26A15D5
include_once("./z_received_enquiry_events.php");
//End Include events file

//Before Initialize @1-E870CEBC
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeInitialize", $MainPage);
//End Before Initialize

//Initialize Objects @1-4BACB24D
$DBConnection1 = new clsDBConnection1();
$MainPage->Connections["Connection1"] = & $DBConnection1;
$Attributes = new clsAttributes("page:");
$MainPage->Attributes = & $Attributes;

// Controls
$book_showcase_store_order = new clsGridbook_showcase_store_order("", $MainPage);
$store_orders = new clsReportstore_orders("", $MainPage);
$MainPage->book_showcase_store_order = & $book_showcase_store_order;
$MainPage->store_orders = & $store_orders;
$book_showcase_store_order->Initialize();
$store_orders->Initialize();

BindEvents();

$CCSEventResult = CCGetEvent($CCSEvents, "AfterInitialize", $MainPage);

if ($Charset) {
    header("Content-Type: " . $ContentType . "; charset=" . $Charset);
} else {
    header("Content-Type: " . $ContentType);
}
//End Initialize Objects

//Initialize HTML Template @1-51EC165D
$CCSEventResult = CCGetEvent($CCSEvents, "OnInitializeView", $MainPage);
$Tpl = new clsTemplate($FileEncoding, $TemplateEncoding);
$Tpl->LoadTemplate(PathToCurrentPage . $TemplateFileName, $BlockToParse, "UTF-8");
$Tpl->block_path = "/$BlockToParse";
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeShow", $MainPage);
$Attributes->SetValue("pathToRoot", "");
$Attributes->Show();
//End Initialize HTML Template

//Go to destination page @1-0AB894B8
if($Redirect)
{
    $CCSEventResult = CCGetEvent($CCSEvents, "BeforeUnload", $MainPage);
    $DBConnection1->close();
    header("Location: " . $Redirect);
    unset($book_showcase_store_order);
    unset($store_orders);
    unset($Tpl);
    exit;
}
//End Go to destination page

//Show Page @1-B1F1C398
$book_showcase_store_order->Show();
$store_orders->Show();
$Tpl->block_path = "";
$Tpl->Parse($BlockToParse, false);
if (!isset($main_block)) $main_block = $Tpl->GetVar($BlockToParse);
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeOutput", $MainPage);
if ($CCSEventResult) echo $main_block;
//End Show Page

//Unload Page @1-1E4124C0
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeUnload", $MainPage);
$DBConnection1->close();
unset($book_showcase_store_order);
unset($store_orders);
unset($Tpl);
//End Unload Page


?>
