<?php
//Include Common Files @1-6AE62973
define("RelativePath", ".");
define("PathToCurrentPage", "/");
define("FileName", "common_gallery.php");
include_once(RelativePath . "/Common.php");
include_once(RelativePath . "/Template.php");
include_once(RelativePath . "/Sorter.php");
include_once(RelativePath . "/Navigator.php");
//End Include Common Files

//Include Page implementation @2-1B12872F
include_once(RelativePath . "/incl_ClixTop.php");
//End Include Page implementation



//Include Page implementation @24-16DCDEFB
include_once(RelativePath . "/incl_footer.php");
//End Include Page implementation

//Include Page implementation @26-B92CD63A
include_once(RelativePath . "/incl_sidebar.php");
//End Include Page implementation

class clsGridclix_list { //clix_list class @27-9A031AD4

//Variables @27-CAEBE2EE

    // Public variables
    var $ComponentType = "Grid";
    var $ComponentName;
    var $Visible;
    var $Errors;
    var $ErrorBlock;
    var $ds;
    var $DataSource;
    var $PageSize;
    var $IsEmpty;
    var $ForceIteration = false;
    var $HasRecord = false;
    var $SorterName = "";
    var $SorterDirection = "";
    var $PageNumber;
    var $RowNumber;
    var $ControlsVisible = array();

    var $CCSEvents = "";
    var $CCSEventResult;

    var $RelativePath = "";
    var $Attributes;

    // Grid Controls
    var $StaticControls;
    var $RowControls;
    var $Sorter_sl;
    var $Sorter_title1;
//End Variables

//Class_Initialize Event @27-E9D5C2FD
    function clsGridclix_list($RelativePath, & $Parent)
    {
        global $FileName;
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->ComponentName = "clix_list";
        $this->Visible = True;
        $this->Parent = & $Parent;
        $this->RelativePath = $RelativePath;
        $this->Errors = new clsErrors();
        $this->ErrorBlock = "Grid clix_list";
        $this->Attributes = new clsAttributes($this->ComponentName . ":");
        $this->DataSource = new clsclix_listDataSource($this);
        $this->ds = & $this->DataSource;
        $this->PageSize = CCGetParam($this->ComponentName . "PageSize", "");
        if(!is_numeric($this->PageSize) || !strlen($this->PageSize))
            $this->PageSize = 40;
        else
            $this->PageSize = intval($this->PageSize);
        if ($this->PageSize > 100)
            $this->PageSize = 100;
        if($this->PageSize == 0)
            $this->Errors->addError("<p>Form: Grid " . $this->ComponentName . "<br>Error: (CCS06) Invalid page size.</p>");
        $this->PageNumber = intval(CCGetParam($this->ComponentName . "Page", 1));
        if ($this->PageNumber <= 0) $this->PageNumber = 1;
        $this->SorterName = CCGetParam("clix_listOrder", "");
        $this->SorterDirection = CCGetParam("clix_listDir", "");

        $this->ImageLink1 = & new clsControl(ccsImageLink, "ImageLink1", "ImageLink1", ccsText, "", CCGetRequestParam("ImageLink1", ccsGet, NULL), $this);
        $this->ImageLink1->Page = "common_gallery.php";
        $this->ImageLink2 = & new clsControl(ccsImageLink, "ImageLink2", "ImageLink2", ccsText, "", CCGetRequestParam("ImageLink2", ccsGet, NULL), $this);
        $this->ImageLink2->Parameters = CCGetQueryString("QueryString", array("n~", "e~", "ccsForm"));
        $this->ImageLink2->Page = "#";
        $this->cat_id = & new clsControl(ccsHidden, "cat_id", "cat_id", ccsInteger, "", CCGetRequestParam("cat_id", ccsGet, NULL), $this);
        $this->cat_name = & new clsControl(ccsHidden, "cat_name", "cat_name", ccsText, "", CCGetRequestParam("cat_name", ccsGet, NULL), $this);
        $this->image_full = & new clsControl(ccsImageLink, "image_full", "image_full", ccsText, "", CCGetRequestParam("image_full", ccsGet, NULL), $this);
        $this->image_full->Parameters = CCGetQueryString("QueryString", array("ccsForm"));
        $this->Link2 = & new clsControl(ccsLabel, "Link2", "Link2", ccsText, "", CCGetRequestParam("Link2", ccsGet, NULL), $this);
        $this->top_id = & new clsControl(ccsHidden, "top_id", "top_id", ccsInteger, "", CCGetRequestParam("top_id", ccsGet, NULL), $this);
        $this->Link3 = & new clsControl(ccsLabel, "Link3", "Link3", ccsText, "", CCGetRequestParam("Link3", ccsGet, NULL), $this);
        $this->product_category_TotalRecords = & new clsControl(ccsLabel, "product_category_TotalRecords", "product_category_TotalRecords", ccsText, "", CCGetRequestParam("product_category_TotalRecords", ccsGet, NULL), $this);
        $this->Navigator = & new clsNavigator($this->ComponentName, "Navigator", $FileName, 10, tpSimple, $this);
        $this->Navigator->PageSizes = array("1", "5", "10", "25", "50");
        $this->ImageLink3 = & new clsControl(ccsImageLink, "ImageLink3", "ImageLink3", ccsText, "", CCGetRequestParam("ImageLink3", ccsGet, NULL), $this);
        $this->ImageLink3->Page = "common_gallery.php";
        $this->Sorter_sl = & new clsSorter($this->ComponentName, "Sorter_sl", $FileName, $this);
        $this->caption = & new clsControl(ccsLabel, "caption", "caption", ccsText, "", CCGetRequestParam("caption", ccsGet, NULL), $this);
        $this->caption->HTML = true;
        $this->Link1 = & new clsControl(ccsLink, "Link1", "Link1", ccsText, "", CCGetRequestParam("Link1", ccsGet, NULL), $this);
        $this->Link1->Parameters = CCGetQueryString("QueryString", array("gal", "ccsForm"));
        $this->Link1->Page = "gallery.php";
        $this->Sorter_title1 = & new clsSorter($this->ComponentName, "Sorter_title1", $FileName, $this);
    }
//End Class_Initialize Event

//Initialize Method @27-90E704C5
    function Initialize()
    {
        if(!$this->Visible) return;

        $this->DataSource->PageSize = & $this->PageSize;
        $this->DataSource->AbsolutePage = & $this->PageNumber;
        $this->DataSource->SetOrder($this->SorterName, $this->SorterDirection);
    }
//End Initialize Method

//Show Method @27-DF249FF3
    function Show()
    {
        global $Tpl;
        global $CCSLocales;
        if(!$this->Visible) return;

        $this->RowNumber = 0;

        $this->DataSource->Parameters["urlgal"] = CCGetFromGet("gal", NULL);

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeSelect", $this);


        $this->DataSource->Prepare();
        $this->DataSource->Open();
        $this->HasRecord = $this->DataSource->has_next_record();
        $this->IsEmpty = ! $this->HasRecord;
        $this->Attributes->Show();

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShow", $this);
        if(!$this->Visible) return;

        $GridBlock = "Grid " . $this->ComponentName;
        $ParentPath = $Tpl->block_path;
        $Tpl->block_path = $ParentPath . "/" . $GridBlock;


        if (!$this->IsEmpty) {
            $this->ControlsVisible["ImageLink1"] = $this->ImageLink1->Visible;
            $this->ControlsVisible["ImageLink2"] = $this->ImageLink2->Visible;
            $this->ControlsVisible["cat_id"] = $this->cat_id->Visible;
            $this->ControlsVisible["cat_name"] = $this->cat_name->Visible;
            $this->ControlsVisible["image_full"] = $this->image_full->Visible;
            $this->ControlsVisible["Link2"] = $this->Link2->Visible;
            $this->ControlsVisible["top_id"] = $this->top_id->Visible;
            $this->ControlsVisible["Link3"] = $this->Link3->Visible;
            while ($this->ForceIteration || (($this->RowNumber < $this->PageSize) &&  ($this->HasRecord = $this->DataSource->has_next_record()))) {
                $this->RowNumber++;
                if ($this->HasRecord) {
                    $this->DataSource->next_record();
                    $this->DataSource->SetValues();
                }
                $Tpl->block_path = $ParentPath . "/" . $GridBlock . "/Row";
                $this->ImageLink1->Parameters = CCGetQueryString("QueryString", array("n~", "d~", "ccsForm"));
                $this->ImageLink1->Parameters = CCAddParam($this->ImageLink1->Parameters, "e~", $this->DataSource->f("content_id"));
                $this->cat_id->SetValue($this->DataSource->cat_id->GetValue());
                $this->cat_name->SetValue($this->DataSource->cat_name->GetValue());
                $this->image_full->SetValue($this->DataSource->image_full->GetValue());
                $this->image_full->Page = $this->DataSource->f("image_full");
                $this->Link2->SetValue($this->DataSource->Link2->GetValue());
                $this->top_id->SetValue($this->DataSource->top_id->GetValue());
                $this->Link3->SetValue($this->DataSource->Link3->GetValue());
                $this->Attributes->SetValue("rowNumber", $this->RowNumber);
                $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShowRow", $this);
                $this->Attributes->Show();
                $this->ImageLink1->Show();
                $this->ImageLink2->Show();
                $this->cat_id->Show();
                $this->cat_name->Show();
                $this->image_full->Show();
                $this->Link2->Show();
                $this->top_id->Show();
                $this->Link3->Show();
                $Tpl->block_path = $ParentPath . "/" . $GridBlock;
                $Tpl->parse("Row", true);
            }
        }
        else { // Show NoRecords block if no records are found
            $this->Attributes->Show();
            $Tpl->parse("NoRecords", false);
        }

        $errors = $this->GetErrors();
        if(strlen($errors))
        {
            $Tpl->replaceblock("", $errors);
            $Tpl->block_path = $ParentPath;
            return;
        }
        $this->Navigator->PageNumber = $this->DataSource->AbsolutePage;
        $this->Navigator->PageSize = $this->PageSize;
        if ($this->DataSource->RecordsCount == "CCS not counted")
            $this->Navigator->TotalPages = $this->DataSource->AbsolutePage + ($this->DataSource->next_record() ? 1 : 0);
        else
            $this->Navigator->TotalPages = $this->DataSource->PageCount();
        if ($this->Navigator->TotalPages <= 1) {
            $this->Navigator->Visible = false;
        }
        $this->ImageLink3->Parameters = CCGetQueryString("QueryString", array("e~", "d~", "ccsForm"));
        $this->ImageLink3->Parameters = CCAddParam($this->ImageLink3->Parameters, "n~", 1);
        $this->product_category_TotalRecords->Show();
        $this->Navigator->Show();
        $this->ImageLink3->Show();
        $this->Sorter_sl->Show();
        $this->caption->Show();
        $this->Link1->Show();
        $this->Sorter_title1->Show();
        $Tpl->parse();
        $Tpl->block_path = $ParentPath;
        $this->DataSource->close();
    }
//End Show Method

//GetErrors Method @27-1235C5B3
    function GetErrors()
    {
        $errors = "";
        $errors = ComposeStrings($errors, $this->ImageLink1->Errors->ToString());
        $errors = ComposeStrings($errors, $this->ImageLink2->Errors->ToString());
        $errors = ComposeStrings($errors, $this->cat_id->Errors->ToString());
        $errors = ComposeStrings($errors, $this->cat_name->Errors->ToString());
        $errors = ComposeStrings($errors, $this->image_full->Errors->ToString());
        $errors = ComposeStrings($errors, $this->Link2->Errors->ToString());
        $errors = ComposeStrings($errors, $this->top_id->Errors->ToString());
        $errors = ComposeStrings($errors, $this->Link3->Errors->ToString());
        $errors = ComposeStrings($errors, $this->Errors->ToString());
        $errors = ComposeStrings($errors, $this->DataSource->Errors->ToString());
        return $errors;
    }
//End GetErrors Method

} //End clix_list Class @27-FCB6E20C

class clsclix_listDataSource extends clsDBConnection1 {  //clix_listDataSource Class @27-E0C69A6C

//DataSource Variables @27-6B78FB4D
    var $Parent = "";
    var $CCSEvents = "";
    var $CCSEventResult;
    var $ErrorBlock;
    var $CmdExecution;

    var $CountSQL;
    var $wp;


    // Datasource fields
    var $cat_id;
    var $cat_name;
    var $image_full;
    var $Link2;
    var $top_id;
    var $Link3;
//End DataSource Variables

//DataSourceClass_Initialize Event @27-0A040B3E
    function clsclix_listDataSource(& $Parent)
    {
        $this->Parent = & $Parent;
        $this->ErrorBlock = "Grid clix_list";
        $this->Initialize();
        $this->cat_id = new clsField("cat_id", ccsInteger, "");
        
        $this->cat_name = new clsField("cat_name", ccsText, "");
        
        $this->image_full = new clsField("image_full", ccsText, "");
        
        $this->Link2 = new clsField("Link2", ccsText, "");
        
        $this->top_id = new clsField("top_id", ccsInteger, "");
        
        $this->Link3 = new clsField("Link3", ccsText, "");
        

    }
//End DataSourceClass_Initialize Event

//SetOrder Method @27-BA176EB1
    function SetOrder($SorterName, $SorterDirection)
    {
        $this->Order = "content_id desc";
        $this->Order = CCGetOrder($this->Order, $SorterName, $SorterDirection, 
            array("Sorter_sl" => array("sl", ""), 
            "Sorter_title1" => array("flg_heritage", "")));
    }
//End SetOrder Method

//Prepare Method @27-41AF94F2
    function Prepare()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->wp = new clsSQLParameters($this->ErrorBlock);
        $this->wp->AddParameter("1", "urlgal", ccsInteger, "", "", $this->Parameters["urlgal"], "", false);
        $this->wp->Criterion[1] = $this->wp->Operation(opEqual, "ref_id", $this->wp->GetDBValue("1"), $this->ToSQL($this->wp->GetDBValue("1"), ccsInteger),false);
        $this->Where = 
             $this->wp->Criterion[1];
    }
//End Prepare Method

//Open Method @27-6BCC361D
    function Open()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildSelect", $this->Parent);
        $this->CountSQL = "SELECT COUNT(*)\n\n" .
        "FROM common_gallery";
        $this->SQL = "SELECT * \n\n" .
        "FROM common_gallery {SQL_Where} {SQL_OrderBy}";
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteSelect", $this->Parent);
        if ($this->CountSQL) 
            $this->RecordsCount = CCGetDBValue(CCBuildSQL($this->CountSQL, $this->Where, ""), $this);
        else
            $this->RecordsCount = "CCS not counted";
        $this->query($this->OptimizeSQL(CCBuildSQL($this->SQL, $this->Where, $this->Order)));
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteSelect", $this->Parent);
    }
//End Open Method

//SetValues Method @27-27C80BDA
    function SetValues()
    {
        $this->cat_id->SetDBValue(trim($this->f("content_id")));
        $this->cat_name->SetDBValue($this->f("title"));
        $this->image_full->SetDBValue($this->f("image_full"));
        $this->Link2->SetDBValue($this->f("sl"));
        $this->top_id->SetDBValue(trim($this->f("ref_id")));
        $this->Link3->SetDBValue($this->f("flg_heritage"));
    }
//End SetValues Method

} //End clix_listDataSource Class @27-FCB6E20C

class clsRecordclix_rec { //clix_rec Class @48-E00062A6

//Variables @48-D6FF3E86

    // Public variables
    var $ComponentType = "Record";
    var $ComponentName;
    var $Parent;
    var $HTMLFormAction;
    var $PressedButton;
    var $Errors;
    var $ErrorBlock;
    var $FormSubmitted;
    var $FormEnctype;
    var $Visible;
    var $IsEmpty;

    var $CCSEvents = "";
    var $CCSEventResult;

    var $RelativePath = "";

    var $InsertAllowed = false;
    var $UpdateAllowed = false;
    var $DeleteAllowed = false;
    var $ReadAllowed   = false;
    var $EditMode      = false;
    var $ds;
    var $DataSource;
    var $ValidatingControls;
    var $Controls;
    var $Attributes;

    // Class variables
//End Variables

//Class_Initialize Event @48-7BA8F945
    function clsRecordclix_rec($RelativePath, & $Parent)
    {

        global $FileName;
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->Visible = true;
        $this->Parent = & $Parent;
        $this->RelativePath = $RelativePath;
        $this->Errors = new clsErrors();
        $this->ErrorBlock = "Record clix_rec/Error";
        $this->DataSource = new clsclix_recDataSource($this);
        $this->ds = & $this->DataSource;
        $this->InsertAllowed = true;
        $this->UpdateAllowed = true;
        $this->ReadAllowed = true;
        if($this->Visible)
        {
            $this->ComponentName = "clix_rec";
            $this->Attributes = new clsAttributes($this->ComponentName . ":");
            $CCSForm = explode(":", CCGetFromGet("ccsForm", ""), 2);
            if(sizeof($CCSForm) == 1)
                $CCSForm[1] = "";
            list($FormName, $FormMethod) = $CCSForm;
            $this->EditMode = ($FormMethod == "Edit");
            $this->FormEnctype = "multipart/form-data";
            $this->FormSubmitted = ($FormName == $this->ComponentName);
            $Method = $this->FormSubmitted ? ccsPost : ccsGet;
            $this->Button_Insert = & new clsButton("Button_Insert", $Method, $this);
            $this->Button_Update = & new clsButton("Button_Update", $Method, $this);
            $this->Button_Delete = & new clsButton("Button_Delete", $Method, $this);
            $this->Button_Cancel = & new clsButton("Button_Cancel", $Method, $this);
            $this->caption1 = & new clsControl(ccsLabel, "caption1", "caption1", ccsText, "", CCGetRequestParam("caption1", $Method, NULL), $this);
            $this->caption1->HTML = true;
            $this->Image2 = & new clsControl(ccsImageLink, "Image2", "Image2", ccsText, "", CCGetRequestParam("Image2", $Method, NULL), $this);
            $this->Image2->Parameters = CCGetQueryString("QueryString", array("ccsForm"));
            $this->image_full = & new clsFileUpload("image_full", "Photo", "../temp_images/", "../clix_images/", "*.gif;*.jpg;*.png", "", 500000, $this);
            $this->image_full->Required = true;
            $this->caption = & new clsControl(ccsLabel, "caption", "caption", ccsText, "", CCGetRequestParam("caption", $Method, NULL), $this);
            $this->caption->HTML = true;
            $this->event_id = & new clsControl(ccsHidden, "event_id", "event_id", ccsInteger, "", CCGetRequestParam("event_id", $Method, NULL), $this);
            $this->sl = & new clsControl(ccsTextBox, "sl", "Serial No#", ccsInteger, "", CCGetRequestParam("sl", $Method, NULL), $this);
            $this->RadioButton1 = & new clsControl(ccsRadioButton, "RadioButton1", "RadioButton1", ccsText, "", CCGetRequestParam("RadioButton1", $Method, NULL), $this);
            $this->RadioButton1->DSType = dsListOfValues;
            $this->RadioButton1->Values = array(array("Y", "Heritage"), array("N", "Common"));
            $this->RadioButton1->HTML = true;
            if(!$this->FormSubmitted) {
                if(!is_array($this->RadioButton1->Value) && !strlen($this->RadioButton1->Value) && $this->RadioButton1->Value !== false)
                    $this->RadioButton1->SetText(N);
            }
            if(!is_array($this->caption1->Value) && !strlen($this->caption1->Value) && $this->caption1->Value !== false)
                $this->caption1->SetText('Change Photo');
        }
    }
//End Class_Initialize Event

//Initialize Method @48-354A1FF4
    function Initialize()
    {

        if(!$this->Visible)
            return;

        $this->DataSource->Parameters["urle~"] = CCGetFromGet("e~", NULL);
    }
//End Initialize Method

//Validate Method @48-5B4DAC0D
    function Validate()
    {
        global $CCSLocales;
        $Validation = true;
        $Where = "";
        $Validation = ($this->image_full->Validate() && $Validation);
        $Validation = ($this->event_id->Validate() && $Validation);
        $Validation = ($this->sl->Validate() && $Validation);
        $Validation = ($this->RadioButton1->Validate() && $Validation);
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "OnValidate", $this);
        $Validation =  $Validation && ($this->image_full->Errors->Count() == 0);
        $Validation =  $Validation && ($this->event_id->Errors->Count() == 0);
        $Validation =  $Validation && ($this->sl->Errors->Count() == 0);
        $Validation =  $Validation && ($this->RadioButton1->Errors->Count() == 0);
        return (($this->Errors->Count() == 0) && $Validation);
    }
//End Validate Method

//CheckErrors Method @48-F25150B2
    function CheckErrors()
    {
        $errors = false;
        $errors = ($errors || $this->caption1->Errors->Count());
        $errors = ($errors || $this->Image2->Errors->Count());
        $errors = ($errors || $this->image_full->Errors->Count());
        $errors = ($errors || $this->caption->Errors->Count());
        $errors = ($errors || $this->event_id->Errors->Count());
        $errors = ($errors || $this->sl->Errors->Count());
        $errors = ($errors || $this->RadioButton1->Errors->Count());
        $errors = ($errors || $this->Errors->Count());
        $errors = ($errors || $this->DataSource->Errors->Count());
        return $errors;
    }
//End CheckErrors Method

//MasterDetail @48-ED598703
function SetPrimaryKeys($keyArray)
{
    $this->PrimaryKeys = $keyArray;
}
function GetPrimaryKeys()
{
    return $this->PrimaryKeys;
}
function GetPrimaryKey($keyName)
{
    return $this->PrimaryKeys[$keyName];
}
//End MasterDetail

//Operation Method @48-C5D41CF1
    function Operation()
    {
        if(!$this->Visible)
            return;

        global $Redirect;
        global $FileName;

        $this->DataSource->Prepare();
        if(!$this->FormSubmitted) {
            $this->EditMode = $this->DataSource->AllParametersSet;
            return;
        }

        $this->image_full->Upload();

        if($this->FormSubmitted) {
            $this->PressedButton = $this->EditMode ? "Button_Update" : "Button_Insert";
            if($this->Button_Insert->Pressed) {
                $this->PressedButton = "Button_Insert";
            } else if($this->Button_Update->Pressed) {
                $this->PressedButton = "Button_Update";
            } else if($this->Button_Delete->Pressed) {
                $this->PressedButton = "Button_Delete";
            } else if($this->Button_Cancel->Pressed) {
                $this->PressedButton = "Button_Cancel";
            }
        }
        $Redirect = $FileName . "?" . CCGetQueryString("QueryString", array("ccsForm", "e~", "d~", "n~"));
        if($this->PressedButton == "Button_Delete") {
            if(!CCGetEvent($this->Button_Delete->CCSEvents, "OnClick", $this->Button_Delete)) {
                $Redirect = "";
            }
        } else if($this->PressedButton == "Button_Cancel") {
            if(!CCGetEvent($this->Button_Cancel->CCSEvents, "OnClick", $this->Button_Cancel)) {
                $Redirect = "";
            }
        } else if($this->Validate()) {
            if($this->PressedButton == "Button_Insert") {
                if(!CCGetEvent($this->Button_Insert->CCSEvents, "OnClick", $this->Button_Insert) || !$this->InsertRow()) {
                    $Redirect = "";
                }
            } else if($this->PressedButton == "Button_Update") {
                if(!CCGetEvent($this->Button_Update->CCSEvents, "OnClick", $this->Button_Update) || !$this->UpdateRow()) {
                    $Redirect = "";
                }
            }
        } else {
            $Redirect = "";
        }
        if ($Redirect)
            $this->DataSource->close();
    }
//End Operation Method

//InsertRow Method @48-A5EA2C61
    function InsertRow()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeInsert", $this);
        if(!$this->InsertAllowed) return false;
        $this->DataSource->image_full->SetValue($this->image_full->GetValue(true));
        $this->DataSource->event_id->SetValue($this->event_id->GetValue(true));
        $this->DataSource->sl->SetValue($this->sl->GetValue(true));
        $this->DataSource->RadioButton1->SetValue($this->RadioButton1->GetValue(true));
        $this->DataSource->Insert();
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterInsert", $this);
        if($this->DataSource->Errors->Count() == 0) {
            $this->image_full->Move();
        }
        return (!$this->CheckErrors());
    }
//End InsertRow Method

//UpdateRow Method @48-08987E7F
    function UpdateRow()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeUpdate", $this);
        if(!$this->UpdateAllowed) return false;
        $this->DataSource->image_full->SetValue($this->image_full->GetValue(true));
        $this->DataSource->event_id->SetValue($this->event_id->GetValue(true));
        $this->DataSource->sl->SetValue($this->sl->GetValue(true));
        $this->DataSource->RadioButton1->SetValue($this->RadioButton1->GetValue(true));
        $this->DataSource->Update();
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterUpdate", $this);
        if($this->DataSource->Errors->Count() == 0) {
            $this->image_full->Move();
        }
        return (!$this->CheckErrors());
    }
//End UpdateRow Method

//Show Method @48-F2803BF6
    function Show()
    {
        global $CCSUseAmp;
        global $Tpl;
        global $FileName;
        global $CCSLocales;
        $Error = "";

        if(!$this->Visible)
            return;

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeSelect", $this);

        $this->RadioButton1->Prepare();

        $RecordBlock = "Record " . $this->ComponentName;
        $ParentPath = $Tpl->block_path;
        $Tpl->block_path = $ParentPath . "/" . $RecordBlock;
        $this->EditMode = $this->EditMode && $this->ReadAllowed;
        if($this->EditMode) {
            if($this->DataSource->Errors->Count()){
                $this->Errors->AddErrors($this->DataSource->Errors);
                $this->DataSource->Errors->clear();
            }
            $this->DataSource->Open();
            if($this->DataSource->Errors->Count() == 0 && $this->DataSource->next_record()) {
                $this->DataSource->SetValues();
                $this->Image2->SetValue($this->DataSource->Image2->GetValue());
                $this->Image2->Page = $this->DataSource->f("image_full");
                if(!$this->FormSubmitted){
                    $this->image_full->SetValue($this->DataSource->image_full->GetValue());
                    $this->event_id->SetValue($this->DataSource->event_id->GetValue());
                    $this->sl->SetValue($this->DataSource->sl->GetValue());
                    $this->RadioButton1->SetValue($this->DataSource->RadioButton1->GetValue());
                }
            } else {
                $this->EditMode = false;
            }
        }

        if($this->FormSubmitted || $this->CheckErrors()) {
            $Error = "";
            $Error = ComposeStrings($Error, $this->caption1->Errors->ToString());
            $Error = ComposeStrings($Error, $this->Image2->Errors->ToString());
            $Error = ComposeStrings($Error, $this->image_full->Errors->ToString());
            $Error = ComposeStrings($Error, $this->caption->Errors->ToString());
            $Error = ComposeStrings($Error, $this->event_id->Errors->ToString());
            $Error = ComposeStrings($Error, $this->sl->Errors->ToString());
            $Error = ComposeStrings($Error, $this->RadioButton1->Errors->ToString());
            $Error = ComposeStrings($Error, $this->Errors->ToString());
            $Error = ComposeStrings($Error, $this->DataSource->Errors->ToString());
            $Tpl->SetVar("Error", $Error);
            $Tpl->Parse("Error", false);
        }
        $CCSForm = $this->EditMode ? $this->ComponentName . ":" . "Edit" : $this->ComponentName;
        $this->HTMLFormAction = $FileName . "?" . CCAddParam(CCGetQueryString("QueryString", ""), "ccsForm", $CCSForm);
        $Tpl->SetVar("Action", !$CCSUseAmp ? $this->HTMLFormAction : str_replace("&", "&amp;", $this->HTMLFormAction));
        $Tpl->SetVar("HTMLFormName", $this->ComponentName);
        $Tpl->SetVar("HTMLFormEnctype", $this->FormEnctype);
        $this->Button_Insert->Visible = !$this->EditMode && $this->InsertAllowed;
        $this->Button_Update->Visible = $this->EditMode && $this->UpdateAllowed;
        $this->Button_Delete->Visible = $this->EditMode && $this->DeleteAllowed;

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShow", $this);
        $this->Attributes->Show();
        if(!$this->Visible) {
            $Tpl->block_path = $ParentPath;
            return;
        }

        $this->Button_Insert->Show();
        $this->Button_Update->Show();
        $this->Button_Delete->Show();
        $this->Button_Cancel->Show();
        $this->caption1->Show();
        $this->Image2->Show();
        $this->image_full->Show();
        $this->caption->Show();
        $this->event_id->Show();
        $this->sl->Show();
        $this->RadioButton1->Show();
        $Tpl->parse();
        $Tpl->block_path = $ParentPath;
        $this->DataSource->close();
    }
//End Show Method

} //End clix_rec Class @48-FCB6E20C

class clsclix_recDataSource extends clsDBConnection1 {  //clix_recDataSource Class @48-1EF28E83

//DataSource Variables @48-7200E3DB
    var $Parent = "";
    var $CCSEvents = "";
    var $CCSEventResult;
    var $ErrorBlock;
    var $CmdExecution;

    var $InsertParameters;
    var $UpdateParameters;
    var $wp;
    var $AllParametersSet;

    var $InsertFields = array();
    var $UpdateFields = array();

    // Datasource fields
    var $caption1;
    var $Image2;
    var $image_full;
    var $caption;
    var $event_id;
    var $sl;
    var $RadioButton1;
//End DataSource Variables

//DataSourceClass_Initialize Event @48-AB600031
    function clsclix_recDataSource(& $Parent)
    {
        $this->Parent = & $Parent;
        $this->ErrorBlock = "Record clix_rec/Error";
        $this->Initialize();
        $this->caption1 = new clsField("caption1", ccsText, "");
        
        $this->Image2 = new clsField("Image2", ccsText, "");
        
        $this->image_full = new clsField("image_full", ccsText, "");
        
        $this->caption = new clsField("caption", ccsText, "");
        
        $this->event_id = new clsField("event_id", ccsInteger, "");
        
        $this->sl = new clsField("sl", ccsInteger, "");
        
        $this->RadioButton1 = new clsField("RadioButton1", ccsText, "");
        

        $this->InsertFields["image_full"] = array("Name" => "image_full", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->InsertFields["ref_id"] = array("Name" => "ref_id", "Value" => "", "DataType" => ccsInteger, "OmitIfEmpty" => 1);
        $this->InsertFields["sl"] = array("Name" => "sl", "Value" => "", "DataType" => ccsInteger, "OmitIfEmpty" => 1);
        $this->InsertFields["flg_heritage"] = array("Name" => "flg_heritage", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->UpdateFields["image_full"] = array("Name" => "image_full", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->UpdateFields["ref_id"] = array("Name" => "ref_id", "Value" => "", "DataType" => ccsInteger, "OmitIfEmpty" => 1);
        $this->UpdateFields["sl"] = array("Name" => "sl", "Value" => "", "DataType" => ccsInteger, "OmitIfEmpty" => 1);
        $this->UpdateFields["flg_heritage"] = array("Name" => "flg_heritage", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
    }
//End DataSourceClass_Initialize Event

//Prepare Method @48-1544C04C
    function Prepare()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->wp = new clsSQLParameters($this->ErrorBlock);
        $this->wp->AddParameter("1", "urle~", ccsInteger, "", "", $this->Parameters["urle~"], "", false);
        $this->AllParametersSet = $this->wp->AllParamsSet();
        $this->wp->Criterion[1] = $this->wp->Operation(opEqual, "content_id", $this->wp->GetDBValue("1"), $this->ToSQL($this->wp->GetDBValue("1"), ccsInteger),false);
        $this->Where = 
             $this->wp->Criterion[1];
    }
//End Prepare Method

//Open Method @48-515E43C5
    function Open()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildSelect", $this->Parent);
        $this->SQL = "SELECT * \n\n" .
        "FROM common_gallery {SQL_Where} {SQL_OrderBy}";
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteSelect", $this->Parent);
        $this->PageSize = 1;
        $this->query($this->OptimizeSQL(CCBuildSQL($this->SQL, $this->Where, $this->Order)));
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteSelect", $this->Parent);
    }
//End Open Method

//SetValues Method @48-0C5F41FB
    function SetValues()
    {
        $this->Image2->SetDBValue($this->f("image_full"));
        $this->image_full->SetDBValue($this->f("image_full"));
        $this->event_id->SetDBValue(trim($this->f("ref_id")));
        $this->sl->SetDBValue(trim($this->f("sl")));
        $this->RadioButton1->SetDBValue($this->f("flg_heritage"));
    }
//End SetValues Method

//Insert Method @48-B5B76A05
    function Insert()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->CmdExecution = true;
        $this->cp["image_full"] = new clsSQLParameter("ctrlimage_full", ccsText, "", "", $this->image_full->GetValue(true), NULL, false, $this->ErrorBlock);
        $this->cp["ref_id"] = new clsSQLParameter("ctrlevent_id", ccsInteger, "", "", $this->event_id->GetValue(true), NULL, false, $this->ErrorBlock);
        $this->cp["sl"] = new clsSQLParameter("ctrlsl", ccsInteger, "", "", $this->sl->GetValue(true), NULL, false, $this->ErrorBlock);
        $this->cp["flg_heritage"] = new clsSQLParameter("ctrlRadioButton1", ccsText, "", "", $this->RadioButton1->GetValue(true), NULL, false, $this->ErrorBlock);
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildInsert", $this->Parent);
        if (!is_null($this->cp["image_full"]->GetValue()) and !strlen($this->cp["image_full"]->GetText()) and !is_bool($this->cp["image_full"]->GetValue())) 
            $this->cp["image_full"]->SetValue($this->image_full->GetValue(true));
        if (!is_null($this->cp["ref_id"]->GetValue()) and !strlen($this->cp["ref_id"]->GetText()) and !is_bool($this->cp["ref_id"]->GetValue())) 
            $this->cp["ref_id"]->SetValue($this->event_id->GetValue(true));
        if (!is_null($this->cp["sl"]->GetValue()) and !strlen($this->cp["sl"]->GetText()) and !is_bool($this->cp["sl"]->GetValue())) 
            $this->cp["sl"]->SetValue($this->sl->GetValue(true));
        if (!is_null($this->cp["flg_heritage"]->GetValue()) and !strlen($this->cp["flg_heritage"]->GetText()) and !is_bool($this->cp["flg_heritage"]->GetValue())) 
            $this->cp["flg_heritage"]->SetValue($this->RadioButton1->GetValue(true));
        $this->InsertFields["image_full"]["Value"] = $this->cp["image_full"]->GetDBValue(true);
        $this->InsertFields["ref_id"]["Value"] = $this->cp["ref_id"]->GetDBValue(true);
        $this->InsertFields["sl"]["Value"] = $this->cp["sl"]->GetDBValue(true);
        $this->InsertFields["flg_heritage"]["Value"] = $this->cp["flg_heritage"]->GetDBValue(true);
        $this->SQL = CCBuildInsert("common_gallery", $this->InsertFields, $this);
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteInsert", $this->Parent);
        if($this->Errors->Count() == 0 && $this->CmdExecution) {
            $this->query($this->SQL);
            $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteInsert", $this->Parent);
        }
    }
//End Insert Method

//Update Method @48-AC27BD0F
    function Update()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->CmdExecution = true;
        $this->cp["image_full"] = new clsSQLParameter("ctrlimage_full", ccsText, "", "", $this->image_full->GetValue(true), NULL, false, $this->ErrorBlock);
        $this->cp["ref_id"] = new clsSQLParameter("ctrlevent_id", ccsInteger, "", "", $this->event_id->GetValue(true), NULL, false, $this->ErrorBlock);
        $this->cp["sl"] = new clsSQLParameter("ctrlsl", ccsInteger, "", "", $this->sl->GetValue(true), NULL, false, $this->ErrorBlock);
        $this->cp["flg_heritage"] = new clsSQLParameter("ctrlRadioButton1", ccsText, "", "", $this->RadioButton1->GetValue(true), NULL, false, $this->ErrorBlock);
        $wp = new clsSQLParameters($this->ErrorBlock);
        $wp->AddParameter("1", "urle~", ccsInteger, "", "", CCGetFromGet("e~", NULL), "", false);
        if(!$wp->AllParamsSet()) {
            $this->Errors->addError($CCSLocales->GetText("CCS_CustomOperationError_MissingParameters"));
        }
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildUpdate", $this->Parent);
        if (!is_null($this->cp["image_full"]->GetValue()) and !strlen($this->cp["image_full"]->GetText()) and !is_bool($this->cp["image_full"]->GetValue())) 
            $this->cp["image_full"]->SetValue($this->image_full->GetValue(true));
        if (!is_null($this->cp["ref_id"]->GetValue()) and !strlen($this->cp["ref_id"]->GetText()) and !is_bool($this->cp["ref_id"]->GetValue())) 
            $this->cp["ref_id"]->SetValue($this->event_id->GetValue(true));
        if (!is_null($this->cp["sl"]->GetValue()) and !strlen($this->cp["sl"]->GetText()) and !is_bool($this->cp["sl"]->GetValue())) 
            $this->cp["sl"]->SetValue($this->sl->GetValue(true));
        if (!is_null($this->cp["flg_heritage"]->GetValue()) and !strlen($this->cp["flg_heritage"]->GetText()) and !is_bool($this->cp["flg_heritage"]->GetValue())) 
            $this->cp["flg_heritage"]->SetValue($this->RadioButton1->GetValue(true));
        $wp->Criterion[1] = $wp->Operation(opEqual, "content_id", $wp->GetDBValue("1"), $this->ToSQL($wp->GetDBValue("1"), ccsInteger),false);
        $Where = 
             $wp->Criterion[1];
        $this->UpdateFields["image_full"]["Value"] = $this->cp["image_full"]->GetDBValue(true);
        $this->UpdateFields["ref_id"]["Value"] = $this->cp["ref_id"]->GetDBValue(true);
        $this->UpdateFields["sl"]["Value"] = $this->cp["sl"]->GetDBValue(true);
        $this->UpdateFields["flg_heritage"]["Value"] = $this->cp["flg_heritage"]->GetDBValue(true);
        $this->SQL = CCBuildUpdate("common_gallery", $this->UpdateFields, $this);
        $this->SQL .= strlen($Where) ? " WHERE " . $Where : $Where;
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteUpdate", $this->Parent);
        if($this->Errors->Count() == 0 && $this->CmdExecution) {
            $this->query($this->SQL);
            $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteUpdate", $this->Parent);
        }
    }
//End Update Method

} //End clix_recDataSource Class @48-FCB6E20C











//Initialize Page @1-8ACB7B6F
// Variables
$FileName = "";
$Redirect = "";
$Tpl = "";
$TemplateFileName = "";
$BlockToParse = "";
$ComponentName = "";
$Attributes = "";

// Events;
$CCSEvents = "";
$CCSEventResult = "";

$FileName = FileName;
$Redirect = "";
$TemplateFileName = "common_gallery.html";
$BlockToParse = "main";
$TemplateEncoding = "UTF-8";
$ContentType = "text/html";
$PathToRoot = "./";
$Charset = $Charset ? $Charset : "utf-8";
//End Initialize Page

//Authenticate User @1-74BBAD6F
CCSecurityRedirect("6666", "");
//End Authenticate User

//Include events file @1-9C7D0305
include_once("./common_gallery_events.php");
//End Include events file

//Before Initialize @1-E870CEBC
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeInitialize", $MainPage);
//End Before Initialize

//Initialize Objects @1-5B0637B3
$DBConnection1 = new clsDBConnection1();
$MainPage->Connections["Connection1"] = & $DBConnection1;
$Attributes = new clsAttributes("page:");
$MainPage->Attributes = & $Attributes;

// Controls
$incl_ClixTop = & new clsincl_ClixTop("", "incl_ClixTop", $MainPage);
$incl_ClixTop->Initialize();
$incl_footer = & new clsincl_footer("", "incl_footer", $MainPage);
$incl_footer->Initialize();
$incl_sidebar = & new clsincl_sidebar("", "incl_sidebar", $MainPage);
$incl_sidebar->Initialize();
$clix_list = & new clsGridclix_list("", $MainPage);
$clix_rec = & new clsRecordclix_rec("", $MainPage);
$MainPage->incl_ClixTop = & $incl_ClixTop;
$MainPage->incl_footer = & $incl_footer;
$MainPage->incl_sidebar = & $incl_sidebar;
$MainPage->clix_list = & $clix_list;
$MainPage->clix_rec = & $clix_rec;
$clix_list->Initialize();
$clix_rec->Initialize();

BindEvents();

$CCSEventResult = CCGetEvent($CCSEvents, "AfterInitialize", $MainPage);

if ($Charset) {
    header("Content-Type: " . $ContentType . "; charset=" . $Charset);
} else {
    header("Content-Type: " . $ContentType);
}
//End Initialize Objects

//Initialize HTML Template @1-51EC165D
$CCSEventResult = CCGetEvent($CCSEvents, "OnInitializeView", $MainPage);
$Tpl = new clsTemplate($FileEncoding, $TemplateEncoding);
$Tpl->LoadTemplate(PathToCurrentPage . $TemplateFileName, $BlockToParse, "UTF-8");
$Tpl->block_path = "/$BlockToParse";
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeShow", $MainPage);
$Attributes->SetValue("pathToRoot", "");
$Attributes->Show();
//End Initialize HTML Template

//Execute Components @1-F0606FE4
$incl_ClixTop->Operations();
$incl_footer->Operations();
$incl_sidebar->Operations();
$clix_rec->Operation();
//End Execute Components

//Go to destination page @1-788A201D
if($Redirect)
{
    $CCSEventResult = CCGetEvent($CCSEvents, "BeforeUnload", $MainPage);
    $DBConnection1->close();
    header("Location: " . $Redirect);
    $incl_ClixTop->Class_Terminate();
    unset($incl_ClixTop);
    $incl_footer->Class_Terminate();
    unset($incl_footer);
    $incl_sidebar->Class_Terminate();
    unset($incl_sidebar);
    unset($clix_list);
    unset($clix_rec);
    unset($Tpl);
    exit;
}
//End Go to destination page

//Show Page @1-A7A75B9D
$incl_ClixTop->Show();
$incl_footer->Show();
$incl_sidebar->Show();
$clix_list->Show();
$clix_rec->Show();
$Tpl->block_path = "";
$Tpl->Parse($BlockToParse, false);
if (!isset($main_block)) $main_block = $Tpl->GetVar($BlockToParse);
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeOutput", $MainPage);
if ($CCSEventResult) echo $main_block;
//End Show Page

//Unload Page @1-F854B87C
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeUnload", $MainPage);
$DBConnection1->close();
$incl_ClixTop->Class_Terminate();
unset($incl_ClixTop);
$incl_footer->Class_Terminate();
unset($incl_footer);
$incl_sidebar->Class_Terminate();
unset($incl_sidebar);
unset($clix_list);
unset($clix_rec);
unset($Tpl);
//End Unload Page


?>
