<?php
//Include Common Files @1-36D7C8CC
define("RelativePath", ".");
define("PathToCurrentPage", "/");
define("FileName", "package_link_builder_weekend_destination.php");
include_once(RelativePath . "/Common.php");
include_once(RelativePath . "/Template.php");
include_once(RelativePath . "/Sorter.php");
include_once(RelativePath . "/Navigator.php");
//End Include Common Files

//Include Page implementation @2-1B12872F
include_once(RelativePath . "/incl_ClixTop.php");
//End Include Page implementation



//Include Page implementation @24-16DCDEFB
include_once(RelativePath . "/incl_footer.php");
//End Include Page implementation

//Include Page implementation @26-B92CD63A
include_once(RelativePath . "/incl_sidebar.php");
//End Include Page implementation



class clsRecordclix_rec { //clix_rec Class @48-E00062A6

//Variables @48-37BB2AF0

    // Public variables
    var $ComponentType = "Record";
    var $ComponentName;
    var $Parent;
    var $HTMLFormAction;
    var $PressedButton;
    var $Errors;
    var $ErrorBlock;
    var $FormSubmitted;
    var $FormEnctype;
    var $Visible;
    var $IsEmpty;

    var $CCSEvents = "";
    var $CCSEventResult;

    var $RelativePath = "";

    var $InsertAllowed = false;
    var $UpdateAllowed = false;
    var $DeleteAllowed = false;
    var $ReadAllowed   = false;
    var $EditMode      = false;
    var $ds;
    var $DataSource;
    var $ValidatingControls;
    var $Controls;
    var $Attributes;
//End Variables

//Class_Initialize Event @48-390EA2DE
    function clsRecordclix_rec($RelativePath, & $Parent)
    {

        global $FileName;
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->Visible = true;
        $this->Parent = & $Parent;
        $this->RelativePath = $RelativePath;
        $this->Errors = new clsErrors();
        $this->ErrorBlock = "Record clix_rec/Error";
        $this->DataSource = new clsclix_recDataSource($this);
        $this->ds = & $this->DataSource;
        $this->InsertAllowed = true;
        $this->UpdateAllowed = true;
        $this->ReadAllowed = true;
        if($this->Visible)
        {
            $this->ComponentName = "clix_rec";
            $this->Attributes = new clsAttributes($this->ComponentName . ":");
            $CCSForm = explode(":", CCGetFromGet("ccsForm", ""), 2);
            if(sizeof($CCSForm) == 1)
                $CCSForm[1] = "";
            list($FormName, $FormMethod) = $CCSForm;
            $this->EditMode = ($FormMethod == "Edit");
            $this->FormEnctype = "application/x-www-form-urlencoded";
            $this->FormSubmitted = ($FormName == $this->ComponentName);
            $Method = $this->FormSubmitted ? ccsPost : ccsGet;
        }
    }
//End Class_Initialize Event

//Initialize Method @48-354A1FF4
    function Initialize()
    {

        if(!$this->Visible)
            return;

        $this->DataSource->Parameters["urle~"] = CCGetFromGet("e~", NULL);
    }
//End Initialize Method

//Validate Method @48-367945B8
    function Validate()
    {
        global $CCSLocales;
        $Validation = true;
        $Where = "";
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "OnValidate", $this);
        return (($this->Errors->Count() == 0) && $Validation);
    }
//End Validate Method

//CheckErrors Method @48-F5A3B433
    function CheckErrors()
    {
        $errors = false;
        $errors = ($errors || $this->Errors->Count());
        $errors = ($errors || $this->DataSource->Errors->Count());
        return $errors;
    }
//End CheckErrors Method

//MasterDetail @48-ED598703
function SetPrimaryKeys($keyArray)
{
    $this->PrimaryKeys = $keyArray;
}
function GetPrimaryKeys()
{
    return $this->PrimaryKeys;
}
function GetPrimaryKey($keyName)
{
    return $this->PrimaryKeys[$keyName];
}
//End MasterDetail

//Operation Method @48-549EE679
    function Operation()
    {
        if(!$this->Visible)
            return;

        global $Redirect;
        global $FileName;

        $this->DataSource->Prepare();
        if(!$this->FormSubmitted) {
            $this->EditMode = $this->DataSource->AllParametersSet;
            return;
        }

        $Redirect = $FileName . "?" . CCGetQueryString("QueryString", array("ccsForm", "e~", "d~", "n~", "ord~"));
        if ($Redirect)
            $this->DataSource->close();
    }
//End Operation Method

//InsertRow Method @48-3E3648AD
    function InsertRow()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeInsert", $this);
        if(!$this->InsertAllowed) return false;
        $this->DataSource->meta_title->SetValue($this->meta_title->GetValue(true));
        $this->DataSource->meta_desc->SetValue($this->meta_desc->GetValue(true));
        $this->DataSource->meta_keys->SetValue($this->meta_keys->GetValue(true));
        $this->DataSource->content->SetValue($this->content->GetValue(true));
        $this->DataSource->flg_form->SetValue($this->flg_form->GetValue(true));
        $this->DataSource->category_id->SetValue($this->category_id->GetValue(true));
        $this->DataSource->Insert();
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterInsert", $this);
        return (!$this->CheckErrors());
    }
//End InsertRow Method

//UpdateRow Method @48-2790DD14
    function UpdateRow()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeUpdate", $this);
        if(!$this->UpdateAllowed) return false;
        $this->DataSource->meta_title->SetValue($this->meta_title->GetValue(true));
        $this->DataSource->meta_desc->SetValue($this->meta_desc->GetValue(true));
        $this->DataSource->meta_keys->SetValue($this->meta_keys->GetValue(true));
        $this->DataSource->content->SetValue($this->content->GetValue(true));
        $this->DataSource->flg_form->SetValue($this->flg_form->GetValue(true));
        $this->DataSource->Update();
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterUpdate", $this);
        return (!$this->CheckErrors());
    }
//End UpdateRow Method

//Show Method @48-C7851BA2
    function Show()
    {
        global $CCSUseAmp;
        global $Tpl;
        global $FileName;
        global $CCSLocales;
        $Error = "";

        if(!$this->Visible)
            return;

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeSelect", $this);


        $RecordBlock = "Record " . $this->ComponentName;
        $ParentPath = $Tpl->block_path;
        $Tpl->block_path = $ParentPath . "/" . $RecordBlock;
        $this->EditMode = $this->EditMode && $this->ReadAllowed;
        if($this->EditMode) {
            if($this->DataSource->Errors->Count()){
                $this->Errors->AddErrors($this->DataSource->Errors);
                $this->DataSource->Errors->clear();
            }
            $this->DataSource->Open();
            if($this->DataSource->Errors->Count() == 0 && $this->DataSource->next_record()) {
                $this->DataSource->SetValues();
            } else {
                $this->EditMode = false;
            }
        }

        if($this->FormSubmitted || $this->CheckErrors()) {
            $Error = "";
            $Error = ComposeStrings($Error, $this->Errors->ToString());
            $Error = ComposeStrings($Error, $this->DataSource->Errors->ToString());
            $Tpl->SetVar("Error", $Error);
            $Tpl->Parse("Error", false);
        }
        $CCSForm = $this->EditMode ? $this->ComponentName . ":" . "Edit" : $this->ComponentName;
        $this->HTMLFormAction = $FileName . "?" . CCAddParam(CCGetQueryString("QueryString", ""), "ccsForm", $CCSForm);
        $Tpl->SetVar("Action", !$CCSUseAmp ? $this->HTMLFormAction : str_replace("&", "&amp;", $this->HTMLFormAction));
        $Tpl->SetVar("HTMLFormName", $this->ComponentName);
        $Tpl->SetVar("HTMLFormEnctype", $this->FormEnctype);

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShow", $this);
        $this->Attributes->Show();
        if(!$this->Visible) {
            $Tpl->block_path = $ParentPath;
            return;
        }

        $Tpl->parse();
        $Tpl->block_path = $ParentPath;
        $this->DataSource->close();
    }
//End Show Method

} //End clix_rec Class @48-FCB6E20C

class clsclix_recDataSource extends clsDBConnection1 {  //clix_recDataSource Class @48-1EF28E83

//DataSource Variables @48-0FD1C3A9
    var $Parent = "";
    var $CCSEvents = "";
    var $CCSEventResult;
    var $ErrorBlock;
    var $CmdExecution;

    var $InsertParameters;
    var $UpdateParameters;
    var $wp;
    var $AllParametersSet;

    var $InsertFields = array();
    var $UpdateFields = array();

//End DataSource Variables

//DataSourceClass_Initialize Event @48-8FA694E5
    function clsclix_recDataSource(& $Parent)
    {
        $this->Parent = & $Parent;
        $this->ErrorBlock = "Record clix_rec/Error";
        $this->Initialize();

        $this->InsertFields["meta_title"] = array("Name" => "meta_title", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->InsertFields["meta_desc"] = array("Name" => "meta_desc", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->InsertFields["meta_keys"] = array("Name" => "meta_keys", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->InsertFields["content"] = array("Name" => "content", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->InsertFields["flg_form"] = array("Name" => "flg_form", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->InsertFields["content_code"] = array("Name" => "content_code", "Value" => "", "DataType" => ccsInteger, "OmitIfEmpty" => 1);
        $this->UpdateFields["meta_title"] = array("Name" => "meta_title", "Value" => "", "DataType" => ccsText);
        $this->UpdateFields["meta_desc"] = array("Name" => "meta_desc", "Value" => "", "DataType" => ccsText);
        $this->UpdateFields["meta_keys"] = array("Name" => "meta_keys", "Value" => "", "DataType" => ccsText);
        $this->UpdateFields["content"] = array("Name" => "content", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->UpdateFields["flg_form"] = array("Name" => "flg_form", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
    }
//End DataSourceClass_Initialize Event

//Prepare Method @48-34BCD496
    function Prepare()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->wp = new clsSQLParameters($this->ErrorBlock);
        $this->wp->AddParameter("1", "urle~", ccsInteger, "", "", $this->Parameters["urle~"], "", false);
        $this->AllParametersSet = $this->wp->AllParamsSet();
        $this->wp->Criterion[1] = $this->wp->Operation(opEqual, "content.content_code", $this->wp->GetDBValue("1"), $this->ToSQL($this->wp->GetDBValue("1"), ccsInteger),false);
        $this->Where = 
             $this->wp->Criterion[1];
    }
//End Prepare Method

//Open Method @48-344F0DFF
    function Open()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildSelect", $this->Parent);
        $this->SQL = "SELECT * \n\n" .
        "FROM content INNER JOIN w_directory_categories ON\n\n" .
        "content.lang_code = w_directory_categories.lang_code AND w_directory_categories.category_id = content.content_code {SQL_Where} {SQL_OrderBy}";
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteSelect", $this->Parent);
        $this->PageSize = 1;
        $this->query($this->OptimizeSQL(CCBuildSQL($this->SQL, $this->Where, $this->Order)));
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteSelect", $this->Parent);
    }
//End Open Method

//SetValues Method @48-BAF0975B
    function SetValues()
    {
    }
//End SetValues Method

//Insert Method @48-6BCD25D4
    function Insert()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->CmdExecution = true;
        $this->cp["meta_title"] = new clsSQLParameter("ctrlmeta_title", ccsText, "", "", $this->meta_title->GetValue(true), NULL, false, $this->ErrorBlock);
        $this->cp["meta_desc"] = new clsSQLParameter("ctrlmeta_desc", ccsText, "", "", $this->meta_desc->GetValue(true), NULL, false, $this->ErrorBlock);
        $this->cp["meta_keys"] = new clsSQLParameter("ctrlmeta_keys", ccsText, "", "", $this->meta_keys->GetValue(true), NULL, false, $this->ErrorBlock);
        $this->cp["content"] = new clsSQLParameter("ctrlcontent", ccsText, "", "", $this->content->GetValue(true), NULL, false, $this->ErrorBlock);
        $this->cp["flg_form"] = new clsSQLParameter("ctrlflg_form", ccsText, "", "", $this->flg_form->GetValue(true), NULL, false, $this->ErrorBlock);
        $this->cp["content_code"] = new clsSQLParameter("ctrlcategory_id", ccsInteger, "", "", $this->category_id->GetValue(true), NULL, false, $this->ErrorBlock);
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildInsert", $this->Parent);
        if (!is_null($this->cp["meta_title"]->GetValue()) and !strlen($this->cp["meta_title"]->GetText()) and !is_bool($this->cp["meta_title"]->GetValue())) 
            $this->cp["meta_title"]->SetValue($this->meta_title->GetValue(true));
        if (!is_null($this->cp["meta_desc"]->GetValue()) and !strlen($this->cp["meta_desc"]->GetText()) and !is_bool($this->cp["meta_desc"]->GetValue())) 
            $this->cp["meta_desc"]->SetValue($this->meta_desc->GetValue(true));
        if (!is_null($this->cp["meta_keys"]->GetValue()) and !strlen($this->cp["meta_keys"]->GetText()) and !is_bool($this->cp["meta_keys"]->GetValue())) 
            $this->cp["meta_keys"]->SetValue($this->meta_keys->GetValue(true));
        if (!is_null($this->cp["content"]->GetValue()) and !strlen($this->cp["content"]->GetText()) and !is_bool($this->cp["content"]->GetValue())) 
            $this->cp["content"]->SetValue($this->content->GetValue(true));
        if (!is_null($this->cp["flg_form"]->GetValue()) and !strlen($this->cp["flg_form"]->GetText()) and !is_bool($this->cp["flg_form"]->GetValue())) 
            $this->cp["flg_form"]->SetValue($this->flg_form->GetValue(true));
        if (!is_null($this->cp["content_code"]->GetValue()) and !strlen($this->cp["content_code"]->GetText()) and !is_bool($this->cp["content_code"]->GetValue())) 
            $this->cp["content_code"]->SetValue($this->category_id->GetValue(true));
        $this->InsertFields["meta_title"]["Value"] = $this->cp["meta_title"]->GetDBValue(true);
        $this->InsertFields["meta_desc"]["Value"] = $this->cp["meta_desc"]->GetDBValue(true);
        $this->InsertFields["meta_keys"]["Value"] = $this->cp["meta_keys"]->GetDBValue(true);
        $this->InsertFields["content"]["Value"] = $this->cp["content"]->GetDBValue(true);
        $this->InsertFields["flg_form"]["Value"] = $this->cp["flg_form"]->GetDBValue(true);
        $this->InsertFields["content_code"]["Value"] = $this->cp["content_code"]->GetDBValue(true);
        $this->SQL = CCBuildInsert("content", $this->InsertFields, $this);
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteInsert", $this->Parent);
        if($this->Errors->Count() == 0 && $this->CmdExecution) {
            $this->query($this->SQL);
            $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteInsert", $this->Parent);
        }
    }
//End Insert Method

//Update Method @48-E4CA9E4F
    function Update()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->CmdExecution = true;
        $this->cp["meta_title"] = new clsSQLParameter("ctrlmeta_title", ccsText, "", "", $this->meta_title->GetValue(true), "", false, $this->ErrorBlock);
        $this->cp["meta_desc"] = new clsSQLParameter("ctrlmeta_desc", ccsText, "", "", $this->meta_desc->GetValue(true), "", false, $this->ErrorBlock);
        $this->cp["meta_keys"] = new clsSQLParameter("ctrlmeta_keys", ccsText, "", "", $this->meta_keys->GetValue(true), "", false, $this->ErrorBlock);
        $this->cp["content"] = new clsSQLParameter("ctrlcontent", ccsText, "", "", $this->content->GetValue(true), NULL, false, $this->ErrorBlock);
        $this->cp["flg_form"] = new clsSQLParameter("ctrlflg_form", ccsText, "", "", $this->flg_form->GetValue(true), NULL, false, $this->ErrorBlock);
        $wp = new clsSQLParameters($this->ErrorBlock);
        $wp->AddParameter("1", "urle~", ccsInteger, "", "", CCGetFromGet("e~", NULL), "", false);
        if(!$wp->AllParamsSet()) {
            $this->Errors->addError($CCSLocales->GetText("CCS_CustomOperationError_MissingParameters"));
        }
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildUpdate", $this->Parent);
        if (!is_null($this->cp["meta_title"]->GetValue()) and !strlen($this->cp["meta_title"]->GetText()) and !is_bool($this->cp["meta_title"]->GetValue())) 
            $this->cp["meta_title"]->SetValue($this->meta_title->GetValue(true));
        if (!is_null($this->cp["meta_desc"]->GetValue()) and !strlen($this->cp["meta_desc"]->GetText()) and !is_bool($this->cp["meta_desc"]->GetValue())) 
            $this->cp["meta_desc"]->SetValue($this->meta_desc->GetValue(true));
        if (!is_null($this->cp["meta_keys"]->GetValue()) and !strlen($this->cp["meta_keys"]->GetText()) and !is_bool($this->cp["meta_keys"]->GetValue())) 
            $this->cp["meta_keys"]->SetValue($this->meta_keys->GetValue(true));
        if (!is_null($this->cp["content"]->GetValue()) and !strlen($this->cp["content"]->GetText()) and !is_bool($this->cp["content"]->GetValue())) 
            $this->cp["content"]->SetValue($this->content->GetValue(true));
        if (!is_null($this->cp["flg_form"]->GetValue()) and !strlen($this->cp["flg_form"]->GetText()) and !is_bool($this->cp["flg_form"]->GetValue())) 
            $this->cp["flg_form"]->SetValue($this->flg_form->GetValue(true));
        $wp->Criterion[1] = $wp->Operation(opEqual, "content.content_code", $wp->GetDBValue("1"), $this->ToSQL($wp->GetDBValue("1"), ccsInteger),false);
        $Where = 
             $wp->Criterion[1];
        $this->UpdateFields["meta_title"]["Value"] = $this->cp["meta_title"]->GetDBValue(true);
        $this->UpdateFields["meta_desc"]["Value"] = $this->cp["meta_desc"]->GetDBValue(true);
        $this->UpdateFields["meta_keys"]["Value"] = $this->cp["meta_keys"]->GetDBValue(true);
        $this->UpdateFields["content"]["Value"] = $this->cp["content"]->GetDBValue(true);
        $this->UpdateFields["flg_form"]["Value"] = $this->cp["flg_form"]->GetDBValue(true);
        $this->SQL = CCBuildUpdate("content", $this->UpdateFields, $this);
        $this->SQL .= strlen($Where) ? " WHERE " . $Where : $Where;
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteUpdate", $this->Parent);
        if($this->Errors->Count() == 0 && $this->CmdExecution) {
            $this->query($this->SQL);
            $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteUpdate", $this->Parent);
        }
    }
//End Update Method

} //End clix_recDataSource Class @48-FCB6E20C

class clsDirectoryclix_list { //clix_list class @78-CC3F5E12

//Variables @78-E1DD9A99

    // Public variables
    var $Parent;
    var $ComponentType = "Directory";
    var $ComponentName;
    var $Visible;
    var $Errors;
    var $ErrorBlock;
    var $ds;
    var $DataSource;
    var $IsEmpty;
    var $SorterName = "";
    var $SorterDirection = "";
    var $NumberOfColumns = 1;
    var $NumberOfSubcategories = "";

    var $CCSEvents = "";
    var $CCSEventResult;

    var $RelativePath = "";
    var $Attributes;
//End Variables

//Class_Initialize Event @78-F0318BAB
    function clsDirectoryclix_list($RelativePath, & $Parent)
    {
        global $FileName;
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->Parent = & $Parent;
        $this->ComponentName = "clix_list";
        $this->Visible = True;
        $this->RelativePath = $RelativePath;
        $this->Errors = new clsErrors();
        $this->ErrorBlock = "Directory clix_list";
        $this->Attributes = new clsAttributes($this->ComponentName . ":");
        $this->DataSource = new clsclix_listDataSource($this);
        $this->ds = & $this->DataSource;
        $this->Visible = (CCSecurityAccessCheck("6666") == "success");

        $this->add_page = & new clsControl(ccsImageLink, "add_page", "add_page", ccsText, "", CCGetRequestParam("add_page", ccsGet, NULL), $this);
        $this->add_page->Page = "package_link_builder_weekend_destination.php";
        $this->add_page->Visible = false;
        $this->edit = & new clsControl(ccsImageLink, "edit", "edit", ccsText, "", CCGetRequestParam("edit", ccsGet, NULL), $this);
        $this->edit->Page = "package_link_builder_weekend_destination.php";
        $this->edit_prod = & new clsControl(ccsImageLink, "edit_prod", "edit_prod", ccsText, "", CCGetRequestParam("edit_prod", ccsGet, NULL), $this);
        $this->edit_prod->Page = "package_link_builder_weekend_destination.php";
        $this->cat_category_id = & new clsControl(ccsHidden, "cat_category_id", "cat_category_id", ccsInteger, "", CCGetRequestParam("cat_category_id", ccsGet, NULL), $this);
        $this->Link6 = & new clsControl(ccsImageLink, "Link6", "Link6", ccsText, "", CCGetRequestParam("Link6", ccsGet, NULL), $this);
        $this->Link6->Page = "package_link_builder_weekend_destination.php";
        $this->Link6->Visible = false;
        $this->Link3 = & new clsControl(ccsImageLink, "Link3", "Link3", ccsText, "", CCGetRequestParam("Link3", ccsGet, NULL), $this);
        $this->Link3->Page = "package_link_builder_weekend_destination.php";
        $this->Link5 = & new clsControl(ccsImageLink, "Link5", "Link5", ccsText, "", CCGetRequestParam("Link5", ccsGet, NULL), $this);
        $this->Link5->Page = "package_link_builder_weekend_destination.php";
        $this->Link5->Visible = false;
        $this->SubcategoriesTailLink = & new clsControl(ccsLink, "SubcategoriesTailLink", "SubcategoriesTailLink", ccsText, "", CCGetRequestParam("SubcategoriesTailLink", ccsGet, NULL), $this);
        $this->SubcategoriesTailLink->Page = "sitemap.php";
        $this->Label1 = & new clsControl(ccsLabel, "Label1", "Label1", ccsText, "", CCGetRequestParam("Label1", ccsGet, NULL), $this);
        $this->Label2 = & new clsControl(ccsLabel, "Label2", "Label2", ccsText, "", CCGetRequestParam("Label2", ccsGet, NULL), $this);
        $this->SubcategoryLink = & new clsControl(ccsImageLink, "SubcategoryLink", "SubcategoryLink", ccsText, "", CCGetRequestParam("SubcategoryLink", ccsGet, NULL), $this);
        $this->SubcategoryLink->HTML = true;
        $this->SubcategoryLink->Page = "package_link_builder_weekend_destination.php";
        $this->SubcategoryLink->Visible = false;
        $this->add_page_inac = & new clsControl(ccsImageLink, "add_page_inac", "add_page_inac", ccsText, "", CCGetRequestParam("add_page_inac", ccsGet, NULL), $this);
        $this->add_page_inac->Parameters = CCGetQueryString("QueryString", array("ccsForm"));
        $this->add_page_inac->Page = "#";
        $this->sort2 = & new clsControl(ccsImageLink, "sort2", "sort2", ccsText, "", CCGetRequestParam("sort2", ccsGet, NULL), $this);
        $this->sort2->Page = "package_link_builder_weekend_destination.php";
        $this->sort2->Visible = false;
        $this->sort1 = & new clsControl(ccsImageLink, "sort1", "sort1", ccsText, "", CCGetRequestParam("sort1", ccsGet, NULL), $this);
        $this->sort1->Page = "package_link_builder_weekend_destination.php";
        $this->sort1->Visible = false;
        $this->Panelblack = & new clsPanel("Panelblack", $this);
        $this->Panelgreen = & new clsPanel("Panelgreen", $this);
        $this->cat_category_id2 = & new clsControl(ccsHidden, "cat_category_id2", "cat_category_id2", ccsInteger, "", CCGetRequestParam("cat_category_id2", ccsGet, NULL), $this);
        $this->seo2 = & new clsControl(ccsImageLink, "seo2", "seo2", ccsText, "", CCGetRequestParam("seo2", ccsGet, NULL), $this);
        $this->seo2->Page = "seo_pages.php";
        $this->seo2->Visible = false;
        $this->seo1 = & new clsControl(ccsImageLink, "seo1", "seo1", ccsText, "", CCGetRequestParam("seo1", ccsGet, NULL), $this);
        $this->seo1->Page = "seo_pages.php";
        $this->seo1->Visible = false;
    }
//End Class_Initialize Event

//Initialize Method @78-75D22D4D
    function Initialize()
    {
        if(!$this->Visible) return;
        $this->DataSource->SetOrder($this->SorterName, $this->SorterDirection);
    }
//End Initialize Method

//Show Method @78-1290DC8F
    function Show()
    {
        global $Tpl;
        global $CCSLocales;
        if(!$this->Visible) return;


        $this->DataSource->Parameters["expr115"] = 5;
        $this->DataSource->Parameters["expr117"] = Y;

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeSelect", $this);

        $this->DataSource->Prepare();
        $this->DataSource->Open();

        $CategoriesNumber = 0;
        if($this->DataSource->next_record())
        {
            $this->IsEmpty = false;
            $category_id_value = $this->DataSource->f("cat_category_id");
            do {
                if($category_id_value != $this->DataSource->f("cat_category_id"))
                    $CategoriesNumber++;
                $category_id_value = $this->DataSource->f("cat_category_id");
            } while ($this->DataSource->next_record());
            $CategoriesNumber++;
        } else {
            $this->IsEmpty = true;
        }

        $this->DataSource->Open();

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShow", $this);
        if(!$this->Visible) return;

        $this->Attributes->Show();
        $DirectoryBlock = "Directory " . $this->ComponentName;
        $ParentPath = $Tpl->block_path;
        $Tpl->block_path = $ParentPath . "/" . $DirectoryBlock;

        $ColumnNumber = 0;
        $CategoryNumber = 0;
        $NumberOfSubcategory = 0;

        $is_next_record = $this->DataSource->next_record();
        if($is_next_record)
        {
            do {
                $category_id_value = $this->DataSource->f("cat_category_id");
                $subcategory_id_value = $this->DataSource->f("sub_category_id");
                $this->DataSource->SetValues();
                $this->add_page->Parameters = CCGetQueryString("QueryString", array("e~", "d~", "n~", "ord~", "ep~", "ccsForm"));
                $this->add_page->Parameters = CCAddParam($this->add_page->Parameters, "n~", $this->DataSource->f("cat_category_id"));
                $this->add_page->Parameters = CCAddParam($this->add_page->Parameters, "ep~", $this->DataSource->f("sub_category_id_parent"));
                $this->edit->Parameters = CCGetQueryString("QueryString", array("e~", "d~", "n~", "ord~", "ep~", "ccsForm"));
                $this->edit->Parameters = CCAddParam($this->edit->Parameters, "e~", $this->DataSource->f("cat_category_id"));
                $this->edit->Parameters = CCAddParam($this->edit->Parameters, "ep~", $this->DataSource->f("sub_category_id_parent"));
                $this->edit_prod->Parameters = CCGetQueryString("QueryString", array("e~", "d~", "n~", "ord~", "ccsForm"));
                $this->edit_prod->Parameters = CCAddParam($this->edit_prod->Parameters, "e~", $this->DataSource->f("cat_category_id"));
                $this->cat_category_id->SetValue($this->DataSource->cat_category_id->GetValue());
                $this->Link6->Parameters = CCGetQueryString("QueryString", array("e~", "d~", "n~", "ord~", "ccsForm"));
                $this->Link6->Parameters = CCAddParam($this->Link6->Parameters, "n~", $this->DataSource->f("sub_category_id"));
                $this->Link3->Parameters = CCGetQueryString("QueryString", array("e~", "d~", "n~", "ord~", "ep~", "ccsForm"));
                $this->Link3->Parameters = CCAddParam($this->Link3->Parameters, "e~", $this->DataSource->f("sub_category_id"));
                $this->Link3->Parameters = CCAddParam($this->Link3->Parameters, "ep~", $this->DataSource->f("sub_category_id_parent"));
                $this->Link5->Parameters = CCGetQueryString("QueryString", array("e~", "d~", "n~", "ccsForm"));
                $this->Link5->Parameters = CCAddParam($this->Link5->Parameters, "d~", $this->DataSource->f("sub_category_id"));
                $this->SubcategoriesTailLink->SetValue($this->DataSource->SubcategoriesTailLink->GetValue());
                $this->SubcategoriesTailLink->Parameters = CCGetQueryString("QueryString", array("ccsForm"));
                $this->SubcategoriesTailLink->Parameters = CCAddParam($this->SubcategoriesTailLink->Parameters, "category_id", $this->DataSource->f("cat_category_id"));
                $this->Label1->SetValue($this->DataSource->Label1->GetValue());
                $this->Label2->SetValue($this->DataSource->Label2->GetValue());
                $this->SubcategoryLink->SetValue($this->DataSource->SubcategoryLink->GetValue());
                $this->SubcategoryLink->Parameters = CCGetQueryString("QueryString", array("e~", "d~", "n~", "ord~", "ccsForm"));
                $this->SubcategoryLink->Parameters = CCAddParam($this->SubcategoryLink->Parameters, "cat", $this->DataSource->f("sub_category_id"));
                $this->sort2->Parameters = CCGetQueryString("QueryString", array("e~", "d~", "n~", "ord~", "ccsForm"));
                $this->sort2->Parameters = CCAddParam($this->sort2->Parameters, "ord~", $this->DataSource->f("sub_category_id"));
                $this->sort1->Parameters = CCGetQueryString("QueryString", array("e~", "d~", "n~", "ord~", "ccsForm"));
                $this->sort1->Parameters = CCAddParam($this->sort1->Parameters, "ord~", $this->DataSource->f("cat_category_id"));
                $this->cat_category_id2->SetValue($this->DataSource->cat_category_id2->GetValue());
                $this->seo2->Parameters = CCGetQueryString("QueryString", array("ccsForm"));
                $this->seo2->Parameters = CCAddParam($this->seo2->Parameters, "ax", $this->DataSource->f("sub_category_id"));
                $this->seo1->Parameters = CCGetQueryString("QueryString", array("ccsForm"));
                $this->seo1->Parameters = CCAddParam($this->seo1->Parameters, "ax", $this->DataSource->f("cat_category_id"));
                if(strlen($subcategory_id_value)) $NumberOfSubcategory++;
                if($NumberOfSubcategory && (!strlen($this->NumberOfSubcategories) || $this->NumberOfSubcategories >= $NumberOfSubcategory)) {
                    $this->Attributes->Show();
                    $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShowSubcategory", $this);
                    $Tpl->block_path = $ParentPath . "/" . $DirectoryBlock . "/Category/Subcategory";
                    $this->Link6->Show();
                    $this->Link3->Show();
                    $this->Link5->Show();
                    $this->Label2->Show();
                    $this->SubcategoryLink->Show();
                    $this->sort2->Show();
                    $this->cat_category_id2->Show();
                    $this->seo2->Show();
                    $Tpl->block_path = $ParentPath . "/" . $DirectoryBlock;
                    $Tpl->parse("Category/Subcategory", true);
                } else if(strlen($this->NumberOfSubcategories) && ($this->NumberOfSubcategories + 1) == $NumberOfSubcategory) {
                    $Tpl->block_path = $ParentPath . "/" . $DirectoryBlock . "/Category/SubcategoriesTail";
                    $this->SubcategoriesTailLink->Show();
                    $this->Attributes->Show();
                    $Tpl->block_path = $ParentPath . "/" . $DirectoryBlock;
                    $Tpl->parseto("Category/SubcategoriesTail", true, "Category/Subcategory");
                }
                $is_next_record = $this->DataSource->next_record();
                $parse_category = (($is_next_record && $category_id_value != $this->DataSource->f("cat_category_id")) || !$is_next_record);

                // Parse Separator
                if($parse_category) {
                    $CategoryNumber++;
                    $NumberOfSubcategory = 0;
                    $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShowCategory", $this);
                    $this->Attributes->Show();
                    $Tpl->block_path = $ParentPath . "/" . $DirectoryBlock . "/Category";
                    $this->add_page->Show();
                    $this->edit->Show();
                    $this->edit_prod->Show();
                    $this->cat_category_id->Show();
                    $this->Label1->Show();
                    $this->add_page_inac->Show();
                    $this->sort1->Show();
                    $this->Panelblack->Show();
                    $this->Panelgreen->Show();
                    $this->seo1->Show();
                    $Tpl->block_path = $ParentPath . "/" . $DirectoryBlock;
                    $Tpl->parse("Category", true);
                    $Tpl->setblockvar("Category/Subcategory", "");
                    if($CategoryNumber >= ($CategoriesNumber / ($this->NumberOfColumns - $ColumnNumber)) && $is_next_record) {
                        $CategoriesNumber -= $CategoryNumber;
                        $ColumnNumber++;
                        $CategoryNumber = 0;
                        $Tpl->block_path = $ParentPath . "/" . $DirectoryBlock . "/ColumnSeparator";
                        $this->Attributes->Show();
                        $Tpl->block_path = $ParentPath . "/" . $DirectoryBlock;
                        $Tpl->parseto("ColumnSeparator", true, "Category");
                    } else if($is_next_record) {
                        $Tpl->block_path = $ParentPath . "/" . $DirectoryBlock . "/CategorySeparator";
                        $this->Attributes->Show();
                        $Tpl->block_path = $ParentPath . "/" . $DirectoryBlock;
                        $Tpl->parseto("CategorySeparator", true, "Category");
                    }
                } else {
                    if(!strlen($this->NumberOfSubcategories) || $this->NumberOfSubcategories >= $NumberOfSubcategory) {
                        $this->Attributes->Show();
                        $Tpl->parseto("Category/SubcategorySeparator", true, "Category/Subcategory");
                    }
                }
            } while ($is_next_record);
        }
        else // Show NoCategories block if no categories are found
        {
            $this->Attributes->Show();
            $NoCategoriesParentPath = $Tpl->block_path;
            $Tpl->block_path = $NoCategoriesParentPath . "/NoCategories";
            $Tpl->block_path = $NoCategoriesParentPath;
            $Tpl->parse("NoCategories", false);
        }

        $errors = $this->GetErrors();
        if(strlen($errors))
        {
            $Tpl->replaceblock("", $errors);
            $Tpl->block_path = $ParentPath;
            return;
        }
        $Tpl->parse();
        $Tpl->block_path = $ParentPath;
    }
//End Show Method

//GetErrors Method @78-F9CFFCB4
    function GetErrors()
    {
        $errors = "";
        $errors = ComposeStrings($errors, $this->add_page->Errors->ToString());
        $errors = ComposeStrings($errors, $this->edit->Errors->ToString());
        $errors = ComposeStrings($errors, $this->edit_prod->Errors->ToString());
        $errors = ComposeStrings($errors, $this->cat_category_id->Errors->ToString());
        $errors = ComposeStrings($errors, $this->Link6->Errors->ToString());
        $errors = ComposeStrings($errors, $this->Link3->Errors->ToString());
        $errors = ComposeStrings($errors, $this->Link5->Errors->ToString());
        $errors = ComposeStrings($errors, $this->SubcategoriesTailLink->Errors->ToString());
        $errors = ComposeStrings($errors, $this->Label1->Errors->ToString());
        $errors = ComposeStrings($errors, $this->Label2->Errors->ToString());
        $errors = ComposeStrings($errors, $this->SubcategoryLink->Errors->ToString());
        $errors = ComposeStrings($errors, $this->add_page_inac->Errors->ToString());
        $errors = ComposeStrings($errors, $this->sort2->Errors->ToString());
        $errors = ComposeStrings($errors, $this->sort1->Errors->ToString());
        $errors = ComposeStrings($errors, $this->cat_category_id2->Errors->ToString());
        $errors = ComposeStrings($errors, $this->seo2->Errors->ToString());
        $errors = ComposeStrings($errors, $this->seo1->Errors->ToString());
        $errors = ComposeStrings($errors, $this->Errors->ToString());
        $errors = ComposeStrings($errors, $this->DataSource->Errors->ToString());
        return $errors;
    }
//End GetErrors Method

} //End clix_list Class @78-FCB6E20C

class clsclix_listDataSource extends clsDBConnection1 {  //clix_listDataSource Class @78-E0C69A6C

//DataSource Variables @78-A57191A9
    var $Parent = "";
    var $CCSEvents = "";
    var $CCSEventResult;
    var $ErrorBlock;
    var $CmdExecution;

    var $CountSQL;
    var $wp;


    // Datasource fields
    var $cat_category_id;
    var $SubcategoriesTailLink;
    var $Label1;
    var $Label2;
    var $SubcategoryLink;
    var $cat_category_id2;
//End DataSource Variables

//DataSourceClass_Initialize Event @78-A4E88AFB
    function clsclix_listDataSource(& $Parent)
    {
        $this->Parent = & $Parent;
        $this->ErrorBlock = "Directory clix_list";
        $this->Initialize();
        $this->cat_category_id = new clsField("cat_category_id", ccsInteger, "");
        
        $this->SubcategoriesTailLink = new clsField("SubcategoriesTailLink", ccsText, "");
        
        $this->Label1 = new clsField("Label1", ccsText, "");
        
        $this->Label2 = new clsField("Label2", ccsText, "");
        
        $this->SubcategoryLink = new clsField("SubcategoryLink", ccsText, "");
        
        $this->cat_category_id2 = new clsField("cat_category_id2", ccsInteger, "");
        

    }
//End DataSourceClass_Initialize Event

//SetOrder Method @78-698FE8E7
    function SetOrder($SorterName, $SorterDirection)
    {
        $this->Order = "cat.sl_no, sub.sl_no";
        $this->Order = CCGetOrder($this->Order, $SorterName, $SorterDirection, 
            "");
    }
//End SetOrder Method

//Prepare Method @78-17110EE3
    function Prepare()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->wp = new clsSQLParameters($this->ErrorBlock);
        $this->wp->AddParameter("1", "expr115", ccsInteger, "", "", $this->Parameters["expr115"], "", true);
        $this->wp->AddParameter("2", "expr117", ccsText, "", "", $this->Parameters["expr117"], -1, false);
        $this->wp->Criterion[1] = $this->wp->Operation(opEqual, "cat.category_id_parent", $this->wp->GetDBValue("1"), $this->ToSQL($this->wp->GetDBValue("1"), ccsInteger),true);
        $this->wp->Criterion[2] = $this->wp->Operation(opEqual, "cat.flg_tree", $this->wp->GetDBValue("2"), $this->ToSQL($this->wp->GetDBValue("2"), ccsText),false);
        $this->Where = $this->wp->opAND(
             false, 
             $this->wp->Criterion[1], 
             $this->wp->Criterion[2]);
    }
//End Prepare Method

//Open Method @78-B1B8D078
    function Open()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildSelect", $this->Parent);
        $this->CountSQL = "SELECT COUNT(*)\n\n" .
        "FROM w_directory_categories cat LEFT JOIN w_directory_categories sub ON\n\n" .
        "cat.category_id = sub.category_id_parent AND cat.lang_code = sub.lang_code";
        $this->SQL = "SELECT cat.category_id AS cat_category_id, cat.category_name AS cat_category_name, sub.category_id AS sub_category_id, sub.category_name AS sub_category_name,\n\n" .
        "cat.category_id_parent AS cat_category_id_parent, sub.category_id_parent AS sub_category_id_parent \n\n" .
        "FROM w_directory_categories cat LEFT JOIN w_directory_categories sub ON\n\n" .
        "cat.category_id = sub.category_id_parent AND cat.lang_code = sub.lang_code {SQL_Where} {SQL_OrderBy}";
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteSelect", $this->Parent);
        if ($this->CountSQL) 
            $this->RecordsCount = CCGetDBValue(CCBuildSQL($this->CountSQL, $this->Where, ""), $this);
        else
            $this->RecordsCount = "CCS not counted";
        $this->query(CCBuildSQL($this->SQL, $this->Where, $this->Order));
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteSelect", $this->Parent);
        $this->MoveToPage($this->AbsolutePage);
    }
//End Open Method

//SetValues Method @78-70F3AEB0
    function SetValues()
    {
        $this->cat_category_id->SetDBValue(trim($this->f("cat_category_id")));
        $this->SubcategoriesTailLink->SetDBValue($this->f("cat_category_name"));
        $this->Label1->SetDBValue($this->f("cat_category_name"));
        $this->Label2->SetDBValue($this->f("sub_category_name"));
        $this->SubcategoryLink->SetDBValue($this->f("sub_category_name"));
        $this->cat_category_id2->SetDBValue(trim($this->f("sub_category_id")));
    }
//End SetValues Method

} //End clix_listDataSource Class @78-FCB6E20C



class clsEditableGridsub_order { //sub_order Class @172-944B1C84

//Variables @172-206F1B1B

    // Public variables
    var $ComponentType = "EditableGrid";
    var $ComponentName;
    var $HTMLFormAction;
    var $PressedButton;
    var $Errors;
    var $ErrorBlock;
    var $FormSubmitted;
    var $FormParameters;
    var $FormState;
    var $FormEnctype;
    var $CachedColumns;
    var $TotalRows;
    var $UpdatedRows;
    var $EmptyRows;
    var $Visible;
    var $RowsErrors;
    var $ds;
    var $DataSource;
    var $PageSize;
    var $IsEmpty;
    var $SorterName = "";
    var $SorterDirection = "";
    var $PageNumber;
    var $ControlsVisible = array();

    var $CCSEvents = "";
    var $CCSEventResult;

    var $RelativePath = "";

    var $InsertAllowed = false;
    var $UpdateAllowed = false;
    var $DeleteAllowed = false;
    var $ReadAllowed   = false;
    var $EditMode;
    var $ValidatingControls;
    var $Controls;
    var $ControlsErrors;
    var $RowNumber;
    var $Attributes;
    var $PrimaryKeys;

    // Class variables
    var $Sorter_displayorder;
    var $Sorter_english_name;
//End Variables

//Class_Initialize Event @172-3D0D8998
    function clsEditableGridsub_order($RelativePath, & $Parent)
    {

        global $FileName;
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->Visible = true;
        $this->Parent = & $Parent;
        $this->RelativePath = $RelativePath;
        $this->Errors = new clsErrors();
        $this->ErrorBlock = "EditableGrid sub_order/Error";
        $this->ControlsErrors = array();
        $this->ComponentName = "sub_order";
        $this->Attributes = new clsAttributes($this->ComponentName . ":");
        $this->CachedColumns["category_id"][0] = "category_id";
        $this->CachedColumns["lang_code"][0] = "lang_code";
        $this->DataSource = new clssub_orderDataSource($this);
        $this->ds = & $this->DataSource;
        $this->PageSize = CCGetParam($this->ComponentName . "PageSize", "");
        if(!is_numeric($this->PageSize) || !strlen($this->PageSize))
            $this->PageSize = 100;
        else
            $this->PageSize = intval($this->PageSize);
        if ($this->PageSize > 100)
            $this->PageSize = 100;
        if($this->PageSize == 0)
            $this->Errors->addError("<p>Form: EditableGrid " . $this->ComponentName . "<br>Error: (CCS06) Invalid page size.</p>");
        $this->PageNumber = intval(CCGetParam($this->ComponentName . "Page", 1));
        if ($this->PageNumber <= 0) $this->PageNumber = 1;

        $this->EmptyRows = 0;
        $this->ReadAllowed = true;
        $this->Visible = (CCSecurityAccessCheck("7777;6666") == "success");
        if(!$this->Visible) return;

        $this->ReadAllowed = $this->ReadAllowed && CCUserInGroups(CCGetGroupID(), "7777;6666");
        $this->UpdateAllowed = CCUserInGroups(CCGetGroupID(), "7777");
        $CCSForm = CCGetFromGet("ccsForm", "");
        $this->FormEnctype = "application/x-www-form-urlencoded";
        $this->FormSubmitted = ($CCSForm == $this->ComponentName);
        if($this->FormSubmitted) {
            $this->FormState = CCGetFromPost("FormState", "");
            $this->SetFormState($this->FormState);
        } else {
            $this->FormState = "";
        }
        $Method = $this->FormSubmitted ? ccsPost : ccsGet;

        $this->SorterName = CCGetParam("sub_orderOrder", "");
        $this->SorterDirection = CCGetParam("sub_orderDir", "");

        $this->Sorter_displayorder = & new clsSorter($this->ComponentName, "Sorter_displayorder", $FileName, $this);
        $this->Sorter_english_name = & new clsSorter($this->ComponentName, "Sorter_english_name", $FileName, $this);
        $this->sl_no = & new clsControl(ccsTextBox, "sl_no", "Display Order", ccsInteger, "", NULL, $this);
        $this->sl_no->Required = true;
        $this->english_name = & new clsControl(ccsTextBox, "english_name", "English Name", ccsText, "", NULL, $this);
        $this->Button_Submit1 = & new clsButton("Button_Submit1", $Method, $this);
        $this->Button_Submit = & new clsButton("Button_Submit", $Method, $this);
    }
//End Class_Initialize Event

//Initialize Method @172-9415465A
    function Initialize()
    {
        if(!$this->Visible) return;

        $this->DataSource->PageSize = & $this->PageSize;
        $this->DataSource->AbsolutePage = & $this->PageNumber;
        $this->DataSource->SetOrder($this->SorterName, $this->SorterDirection);

        $this->DataSource->Parameters["urlord~"] = CCGetFromGet("ord~", NULL);
    }
//End Initialize Method

//SetPrimaryKeys Method @172-EBC3F86C
    function SetPrimaryKeys($PrimaryKeys) {
        $this->PrimaryKeys = $PrimaryKeys;
        return $this->PrimaryKeys;
    }
//End SetPrimaryKeys Method

//GetPrimaryKeys Method @172-74F9A772
    function GetPrimaryKeys() {
        return $this->PrimaryKeys;
    }
//End GetPrimaryKeys Method

//GetFormParameters Method @172-2E7BD3FF
    function GetFormParameters()
    {
        for($RowNumber = 1; $RowNumber <= $this->TotalRows; $RowNumber++)
        {
            $this->FormParameters["sl_no"][$RowNumber] = CCGetFromPost("sl_no_" . $RowNumber, NULL);
            $this->FormParameters["english_name"][$RowNumber] = CCGetFromPost("english_name_" . $RowNumber, NULL);
        }
    }
//End GetFormParameters Method

//Validate Method @172-97BBC600
    function Validate()
    {
        $Validation = true;
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "OnValidate", $this);

        for($this->RowNumber = 1; $this->RowNumber <= $this->TotalRows; $this->RowNumber++)
        {
            $this->DataSource->CachedColumns["category_id"] = $this->CachedColumns["category_id"][$this->RowNumber];
            $this->DataSource->CachedColumns["lang_code"] = $this->CachedColumns["lang_code"][$this->RowNumber];
            $this->DataSource->CurrentRow = $this->RowNumber;
            $this->sl_no->SetText($this->FormParameters["sl_no"][$this->RowNumber], $this->RowNumber);
            $this->english_name->SetText($this->FormParameters["english_name"][$this->RowNumber], $this->RowNumber);
            if ($this->UpdatedRows >= $this->RowNumber) {
                $Validation = ($this->ValidateRow($this->RowNumber) && $Validation);
            }
            else if($this->CheckInsert())
            {
                $Validation = ($this->ValidateRow() && $Validation);
            }
        }
        return (($this->Errors->Count() == 0) && $Validation);
    }
//End Validate Method

//ValidateRow Method @172-3E7EF3AF
    function ValidateRow()
    {
        global $CCSLocales;
        $this->sl_no->Validate();
        $this->english_name->Validate();
        $this->RowErrors = new clsErrors();
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "OnValidateRow", $this);
        $errors = "";
        $errors = ComposeStrings($errors, $this->sl_no->Errors->ToString());
        $errors = ComposeStrings($errors, $this->english_name->Errors->ToString());
        $this->sl_no->Errors->Clear();
        $this->english_name->Errors->Clear();
        $errors = ComposeStrings($errors, $this->RowErrors->ToString());
        $this->RowsErrors[$this->RowNumber] = $errors;
        return $errors != "" ? 0 : 1;
    }
//End ValidateRow Method

//CheckInsert Method @172-43C2C194
    function CheckInsert()
    {
        $filed = false;
        $filed = ($filed || (is_array($this->FormParameters["sl_no"][$this->RowNumber]) && count($this->FormParameters["sl_no"][$this->RowNumber])) || strlen($this->FormParameters["sl_no"][$this->RowNumber]));
        $filed = ($filed || (is_array($this->FormParameters["english_name"][$this->RowNumber]) && count($this->FormParameters["english_name"][$this->RowNumber])) || strlen($this->FormParameters["english_name"][$this->RowNumber]));
        return $filed;
    }
//End CheckInsert Method

//CheckErrors Method @172-F5A3B433
    function CheckErrors()
    {
        $errors = false;
        $errors = ($errors || $this->Errors->Count());
        $errors = ($errors || $this->DataSource->Errors->Count());
        return $errors;
    }
//End CheckErrors Method

//Operation Method @172-EF25C04A
    function Operation()
    {
        if(!$this->Visible)
            return;

        global $Redirect;
        global $FileName;

        $this->DataSource->Prepare();
        if(!$this->FormSubmitted)
            return;

        $this->GetFormParameters();
        $this->PressedButton = "Button_Submit";
        if($this->Button_Submit1->Pressed) {
            $this->PressedButton = "Button_Submit1";
        } else if($this->Button_Submit->Pressed) {
            $this->PressedButton = "Button_Submit";
        }

        $Redirect = "package_link_builder_weekend_destination.php" . "?" . CCGetQueryString("QueryString", array("ccsForm", "e~", "d~", "n~", "ord~"));
        if($this->PressedButton == "Button_Submit1") {
            if(!CCGetEvent($this->Button_Submit1->CCSEvents, "OnClick", $this->Button_Submit1)) {
                $Redirect = "";
            }
        } else if($this->PressedButton == "Button_Submit") {
            if(!CCGetEvent($this->Button_Submit->CCSEvents, "OnClick", $this->Button_Submit) || !$this->UpdateGrid()) {
                $Redirect = "";
            }
        } else {
            $Redirect = "";
        }
        if ($Redirect)
            $this->DataSource->close();
    }
//End Operation Method

//UpdateGrid Method @172-2DB1439A
    function UpdateGrid()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeSubmit", $this);
        if(!$this->Validate()) return;
        $Validation = true;
        for($this->RowNumber = 1; $this->RowNumber <= $this->TotalRows; $this->RowNumber++)
        {
            $this->DataSource->CachedColumns["category_id"] = $this->CachedColumns["category_id"][$this->RowNumber];
            $this->DataSource->CachedColumns["lang_code"] = $this->CachedColumns["lang_code"][$this->RowNumber];
            $this->DataSource->CurrentRow = $this->RowNumber;
            $this->sl_no->SetText($this->FormParameters["sl_no"][$this->RowNumber], $this->RowNumber);
            $this->english_name->SetText($this->FormParameters["english_name"][$this->RowNumber], $this->RowNumber);
            if ($this->UpdatedRows >= $this->RowNumber) {
                if($this->UpdateAllowed) { $Validation = ($this->UpdateRow() && $Validation); }
            }
            else if($this->CheckInsert() && $this->InsertAllowed)
            {
                $Validation = ($Validation && $this->InsertRow());
            }
        }
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterSubmit", $this);
        if ($this->Errors->Count() == 0 && $Validation){
            $this->DataSource->close();
            return true;
        }
        return false;
    }
//End UpdateGrid Method

//UpdateRow Method @172-BACF2E3B
    function UpdateRow()
    {
        if(!$this->UpdateAllowed) return false;
        $this->DataSource->sl_no->SetValue($this->sl_no->GetValue(true));
        $this->DataSource->english_name->SetValue($this->english_name->GetValue(true));
        $this->DataSource->Update();
        $errors = "";
        if($this->DataSource->Errors->Count() > 0) {
            $errors = $this->DataSource->Errors->ToString();
            $this->RowsErrors[$this->RowNumber] = $errors;
            $this->DataSource->Errors->Clear();
        }
        return (($this->Errors->Count() == 0) && !strlen($errors));
    }
//End UpdateRow Method

//FormScript Method @172-D08C7E9D
    function FormScript($TotalRows)
    {
        $script = "";
        $script .= "\n<script language=\"JavaScript\" type=\"text/javascript\">\n<!--\n";
        $script .= "var sub_orderElements;\n";
        $script .= "var sub_orderEmptyRows = 0;\n";
        $script .= "var " . $this->ComponentName . "sl_noID = 0;\n";
        $script .= "var " . $this->ComponentName . "english_nameID = 1;\n";
        $script .= "\nfunction initsub_orderElements() {\n";
        $script .= "\tvar ED = document.forms[\"sub_order\"];\n";
        $script .= "\tsub_orderElements = new Array (\n";
        for($i = 1; $i <= $TotalRows; $i++) {
            $script .= "\t\tnew Array(" . "ED.sl_no_" . $i . ", " . "ED.english_name_" . $i . ")";
            if($i != $TotalRows) $script .= ",\n";
        }
        $script .= ");\n";
        $script .= "}\n";
        $script .= "\n//-->\n</script>";
        return $script;
    }
//End FormScript Method

//SetFormState Method @172-BDDF33B2
    function SetFormState($FormState)
    {
        if(strlen($FormState)) {
            $FormState = str_replace("\\\\", "\\" . ord("\\"), $FormState);
            $FormState = str_replace("\\;", "\\" . ord(";"), $FormState);
            $pieces = explode(";", $FormState);
            $this->UpdatedRows = $pieces[0];
            $this->EmptyRows   = $pieces[1];
            $this->TotalRows = $this->UpdatedRows + $this->EmptyRows;
            $RowNumber = 0;
            for($i = 2; $i < sizeof($pieces); $i = $i + 2)  {
                $piece = $pieces[$i + 0];
                $piece = str_replace("\\" . ord("\\"), "\\", $piece);
                $piece = str_replace("\\" . ord(";"), ";", $piece);
                $this->CachedColumns["category_id"][$RowNumber] = $piece;
                $piece = $pieces[$i + 1];
                $piece = str_replace("\\" . ord("\\"), "\\", $piece);
                $piece = str_replace("\\" . ord(";"), ";", $piece);
                $this->CachedColumns["lang_code"][$RowNumber] = $piece;
                $RowNumber++;
            }

            if(!$RowNumber) { $RowNumber = 1; }
            for($i = 1; $i <= $this->EmptyRows; $i++) {
                $this->CachedColumns["category_id"][$RowNumber] = "";
                $this->CachedColumns["lang_code"][$RowNumber] = "";
                $RowNumber++;
            }
        }
    }
//End SetFormState Method

//GetFormState Method @172-370C9A19
    function GetFormState($NonEmptyRows)
    {
        if(!$this->FormSubmitted) {
            $this->FormState  = $NonEmptyRows . ";";
            $this->FormState .= $this->InsertAllowed ? $this->EmptyRows : "0";
            if($NonEmptyRows) {
                for($i = 0; $i <= $NonEmptyRows; $i++) {
                    $this->FormState .= ";" . str_replace(";", "\\;", str_replace("\\", "\\\\", $this->CachedColumns["category_id"][$i]));
                    $this->FormState .= ";" . str_replace(";", "\\;", str_replace("\\", "\\\\", $this->CachedColumns["lang_code"][$i]));
                }
            }
        }
        return $this->FormState;
    }
//End GetFormState Method

//Show Method @172-A382A2EC
    function Show()
    {
        global $Tpl;
        global $FileName;
        global $CCSLocales;
        global $CCSUseAmp;
        $Error = "";

        if(!$this->Visible) { return; }

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeSelect", $this);


        $this->DataSource->open();
        $is_next_record = ($this->ReadAllowed && $this->DataSource->next_record());
        $this->IsEmpty = ! $is_next_record;

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShow", $this);
        if(!$this->Visible) { return; }

        $this->Attributes->Show();
        $this->Button_Submit->Visible = $this->Button_Submit->Visible && ($this->InsertAllowed || $this->UpdateAllowed || $this->DeleteAllowed);
        $ParentPath = $Tpl->block_path;
        $EditableGridPath = $ParentPath . "/EditableGrid " . $this->ComponentName;
        $EditableGridRowPath = $ParentPath . "/EditableGrid " . $this->ComponentName . "/Row";
        $Tpl->block_path = $EditableGridRowPath;
        $this->RowNumber = 0;
        $NonEmptyRows = 0;
        $EmptyRowsLeft = $this->EmptyRows;
        $this->ControlsVisible["sl_no"] = $this->sl_no->Visible;
        $this->ControlsVisible["english_name"] = $this->english_name->Visible;
        if ($is_next_record || ($EmptyRowsLeft && $this->InsertAllowed)) {
            do {
                $this->RowNumber++;
                if($is_next_record) {
                    $NonEmptyRows++;
                    $this->DataSource->SetValues();
                }
                if (!($this->FormSubmitted) && $is_next_record) {
                    $this->CachedColumns["category_id"][$this->RowNumber] = $this->DataSource->CachedColumns["category_id"];
                    $this->CachedColumns["lang_code"][$this->RowNumber] = $this->DataSource->CachedColumns["lang_code"];
                    $this->sl_no->SetValue($this->DataSource->sl_no->GetValue());
                    $this->english_name->SetValue($this->DataSource->english_name->GetValue());
                } elseif ($this->FormSubmitted && $is_next_record) {
                    $this->sl_no->SetText($this->FormParameters["sl_no"][$this->RowNumber], $this->RowNumber);
                    $this->english_name->SetText($this->FormParameters["english_name"][$this->RowNumber], $this->RowNumber);
                } elseif (!$this->FormSubmitted) {
                    $this->CachedColumns["category_id"][$this->RowNumber] = "";
                    $this->CachedColumns["lang_code"][$this->RowNumber] = "";
                    $this->sl_no->SetText("");
                    $this->english_name->SetText("");
                } else {
                    $this->sl_no->SetText($this->FormParameters["sl_no"][$this->RowNumber], $this->RowNumber);
                    $this->english_name->SetText($this->FormParameters["english_name"][$this->RowNumber], $this->RowNumber);
                }
                $this->Attributes->SetValue("rowNumber", $this->RowNumber);
                $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShowRow", $this);
                $this->Attributes->Show();
                $this->sl_no->Show($this->RowNumber);
                $this->english_name->Show($this->RowNumber);
                if (isset($this->RowsErrors[$this->RowNumber]) && ($this->RowsErrors[$this->RowNumber] != "")) {
                    $Tpl->setblockvar("RowError", "");
                    $Tpl->setvar("Error", $this->RowsErrors[$this->RowNumber]);
                    $this->Attributes->Show();
                    $Tpl->parse("RowError", false);
                } else {
                    $Tpl->setblockvar("RowError", "");
                }
                $Tpl->setvar("FormScript", $this->FormScript($this->RowNumber));
                $Tpl->parse();
                if ($is_next_record) {
                    if ($this->FormSubmitted) {
                        $is_next_record = $this->RowNumber < $this->UpdatedRows;
                        if (($this->DataSource->CachedColumns["category_id"] == $this->CachedColumns["category_id"][$this->RowNumber]) && ($this->DataSource->CachedColumns["lang_code"] == $this->CachedColumns["lang_code"][$this->RowNumber])) {
                            if ($this->ReadAllowed) $this->DataSource->next_record();
                        }
                    }else{
                        $is_next_record = ($this->RowNumber < $this->PageSize) &&  $this->ReadAllowed && $this->DataSource->next_record();
                    }
                } else { 
                    $EmptyRowsLeft--;
                }
            } while($is_next_record || ($EmptyRowsLeft && $this->InsertAllowed));
        } else {
            $Tpl->block_path = $EditableGridPath;
            $this->Attributes->Show();
            $Tpl->parse("NoRecords", false);
        }

        $Tpl->block_path = $EditableGridPath;
        $this->Sorter_displayorder->Show();
        $this->Sorter_english_name->Show();
        $this->Button_Submit1->Show();
        $this->Button_Submit->Show();

        if($this->CheckErrors()) {
            $Error = ComposeStrings($Error, $this->Errors->ToString());
            $Error = ComposeStrings($Error, $this->DataSource->Errors->ToString());
            $Tpl->SetVar("Error", $Error);
            $Tpl->Parse("Error", false);
        }
        $CCSForm = $this->ComponentName;
        $this->HTMLFormAction = $FileName . "?" . CCAddParam(CCGetQueryString("QueryString", ""), "ccsForm", $CCSForm);
        $Tpl->SetVar("Action", !$CCSUseAmp ? $this->HTMLFormAction : str_replace("&", "&amp;", $this->HTMLFormAction));
        $Tpl->SetVar("HTMLFormName", $this->ComponentName);
        $Tpl->SetVar("HTMLFormEnctype", $this->FormEnctype);
        if (!$CCSUseAmp) {
            $Tpl->SetVar("HTMLFormProperties", "method=\"POST\" action=\"" . $this->HTMLFormAction . "\" name=\"" . $this->ComponentName . "\"");
        } else {
            $Tpl->SetVar("HTMLFormProperties", "method=\"post\" action=\"" . str_replace("&", "&amp;", $this->HTMLFormAction) . "\" id=\"" . $this->ComponentName . "\"");
        }
        $Tpl->SetVar("FormState", CCToHTML($this->GetFormState($NonEmptyRows)));
        $Tpl->parse();
        $Tpl->block_path = $ParentPath;
        $this->DataSource->close();
    }
//End Show Method

} //End sub_order Class @172-FCB6E20C

class clssub_orderDataSource extends clsDBConnection1 {  //sub_orderDataSource Class @172-EC731B2B

//DataSource Variables @172-FAB16ED1
    var $Parent = "";
    var $CCSEvents = "";
    var $CCSEventResult;
    var $ErrorBlock;
    var $CmdExecution;

    var $UpdateParameters;
    var $CountSQL;
    var $wp;
    var $AllParametersSet;

    var $CachedColumns;
    var $CurrentRow;
    var $UpdateFields = array();

    // Datasource fields
    var $sl_no;
    var $english_name;
//End DataSource Variables

//DataSourceClass_Initialize Event @172-D5BD35DB
    function clssub_orderDataSource(& $Parent)
    {
        $this->Parent = & $Parent;
        $this->ErrorBlock = "EditableGrid sub_order/Error";
        $this->Initialize();
        $this->sl_no = new clsField("sl_no", ccsInteger, "");
        
        $this->english_name = new clsField("english_name", ccsText, "");
        

        $this->UpdateFields["sl_no"] = array("Name" => "sl_no", "Value" => "", "DataType" => ccsInteger, "OmitIfEmpty" => 1);
        $this->UpdateFields["category_name"] = array("Name" => "category_name", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
    }
//End DataSourceClass_Initialize Event

//SetOrder Method @172-B3DBDD91
    function SetOrder($SorterName, $SorterDirection)
    {
        $this->Order = "sl_no";
        $this->Order = CCGetOrder($this->Order, $SorterName, $SorterDirection, 
            array("Sorter_displayorder" => array("sl_no", ""), 
            "Sorter_english_name" => array("category_name", "")));
    }
//End SetOrder Method

//Prepare Method @172-A2684F21
    function Prepare()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->wp = new clsSQLParameters($this->ErrorBlock);
        $this->wp->AddParameter("1", "urlord~", ccsInteger, "", "", $this->Parameters["urlord~"], -1, false);
        $this->AllParametersSet = $this->wp->AllParamsSet();
        $this->wp->Criterion[1] = $this->wp->Operation(opEqual, "category_id_parent", $this->wp->GetDBValue("1"), $this->ToSQL($this->wp->GetDBValue("1"), ccsInteger),false);
        $this->Where = 
             $this->wp->Criterion[1];
    }
//End Prepare Method

//Open Method @172-8CF4DCED
    function Open()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildSelect", $this->Parent);
        $this->CountSQL = "SELECT COUNT(*)\n\n" .
        "FROM w_directory_categories";
        $this->SQL = "SELECT category_name, sl_no, category_id, lang_code \n\n" .
        "FROM w_directory_categories {SQL_Where} {SQL_OrderBy}";
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteSelect", $this->Parent);
        if ($this->CountSQL) 
            $this->RecordsCount = CCGetDBValue(CCBuildSQL($this->CountSQL, $this->Where, ""), $this);
        else
            $this->RecordsCount = "CCS not counted";
        $this->query($this->OptimizeSQL(CCBuildSQL($this->SQL, $this->Where, $this->Order)));
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteSelect", $this->Parent);
    }
//End Open Method

//SetValues Method @172-B8C16F19
    function SetValues()
    {
        $this->CachedColumns["category_id"] = $this->f("category_id");
        $this->CachedColumns["lang_code"] = $this->f("lang_code");
        $this->sl_no->SetDBValue(trim($this->f("sl_no")));
        $this->english_name->SetDBValue($this->f("category_name"));
    }
//End SetValues Method

//Update Method @172-8114E2DB
    function Update()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->CmdExecution = true;
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildUpdate", $this->Parent);
        $SelectWhere = $this->Where;
        $this->Where = "category_id=" . $this->ToSQL($this->CachedColumns["category_id"], ccsInteger) . " AND lang_code=" . $this->ToSQL($this->CachedColumns["lang_code"], ccsInteger);
        $this->UpdateFields["sl_no"]["Value"] = $this->sl_no->GetDBValue(true);
        $this->UpdateFields["category_name"]["Value"] = $this->english_name->GetDBValue(true);
        $this->SQL = CCBuildUpdate("w_directory_categories", $this->UpdateFields, $this);
        $this->SQL .= strlen($this->Where) ? " WHERE " . $this->Where : $this->Where;
        if (!strlen($this->Where) && $this->Errors->Count() == 0) 
            $this->Errors->addError($CCSLocales->GetText("CCS_CustomOperationError_MissingParameters"));
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteUpdate", $this->Parent);
        if($this->Errors->Count() == 0 && $this->CmdExecution) {
            $this->query($this->SQL);
            $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteUpdate", $this->Parent);
        }
        $this->Where = $SelectWhere;
    }
//End Update Method

} //End sub_orderDataSource Class @172-FCB6E20C











//Initialize Page @1-3A4CA0E5
// Variables
$FileName = "";
$Redirect = "";
$Tpl = "";
$TemplateFileName = "";
$BlockToParse = "";
$ComponentName = "";
$Attributes = "";

// Events;
$CCSEvents = "";
$CCSEventResult = "";

$FileName = FileName;
$Redirect = "";
$TemplateFileName = "package_link_builder_weekend_destination.html";
$BlockToParse = "main";
$TemplateEncoding = "UTF-8";
$ContentType = "text/html";
$PathToRoot = "./";
$Charset = $Charset ? $Charset : "utf-8";
//End Initialize Page

//Authenticate User @1-74BBAD6F
CCSecurityRedirect("6666", "");
//End Authenticate User

//Include events file @1-123655AF
include_once("./package_link_builder_weekend_destination_events.php");
//End Include events file

//Before Initialize @1-E870CEBC
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeInitialize", $MainPage);
//End Before Initialize

//Initialize Objects @1-FCDF6DCD
$DBConnection1 = new clsDBConnection1();
$MainPage->Connections["Connection1"] = & $DBConnection1;
$Attributes = new clsAttributes("page:");
$MainPage->Attributes = & $Attributes;

// Controls
$incl_ClixTop = & new clsincl_ClixTop("", "incl_ClixTop", $MainPage);
$incl_ClixTop->Initialize();
$incl_footer = & new clsincl_footer("", "incl_footer", $MainPage);
$incl_footer->Initialize();
$incl_sidebar = & new clsincl_sidebar("", "incl_sidebar", $MainPage);
$incl_sidebar->Initialize();
$clix_rec = & new clsRecordclix_rec("", $MainPage);
$clix_list = & new clsDirectoryclix_list("", $MainPage);
$sub_order = & new clsEditableGridsub_order("", $MainPage);
$MainPage->incl_ClixTop = & $incl_ClixTop;
$MainPage->incl_footer = & $incl_footer;
$MainPage->incl_sidebar = & $incl_sidebar;
$MainPage->clix_rec = & $clix_rec;
$MainPage->clix_list = & $clix_list;
$MainPage->sub_order = & $sub_order;
$clix_rec->Initialize();
$clix_list->Initialize();
$sub_order->Initialize();

BindEvents();

$CCSEventResult = CCGetEvent($CCSEvents, "AfterInitialize", $MainPage);

if ($Charset) {
    header("Content-Type: " . $ContentType . "; charset=" . $Charset);
} else {
    header("Content-Type: " . $ContentType);
}
//End Initialize Objects

//Initialize HTML Template @1-51EC165D
$CCSEventResult = CCGetEvent($CCSEvents, "OnInitializeView", $MainPage);
$Tpl = new clsTemplate($FileEncoding, $TemplateEncoding);
$Tpl->LoadTemplate(PathToCurrentPage . $TemplateFileName, $BlockToParse, "UTF-8");
$Tpl->block_path = "/$BlockToParse";
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeShow", $MainPage);
$Attributes->SetValue("pathToRoot", "");
$Attributes->Show();
//End Initialize HTML Template

//Execute Components @1-ECA5ED4E
$incl_ClixTop->Operations();
$incl_footer->Operations();
$incl_sidebar->Operations();
$clix_rec->Operation();
$sub_order->Operation();
//End Execute Components

//Go to destination page @1-FEAFAC8E
if($Redirect)
{
    $CCSEventResult = CCGetEvent($CCSEvents, "BeforeUnload", $MainPage);
    $DBConnection1->close();
    header("Location: " . $Redirect);
    $incl_ClixTop->Class_Terminate();
    unset($incl_ClixTop);
    $incl_footer->Class_Terminate();
    unset($incl_footer);
    $incl_sidebar->Class_Terminate();
    unset($incl_sidebar);
    unset($clix_rec);
    unset($clix_list);
    unset($sub_order);
    unset($Tpl);
    exit;
}
//End Go to destination page

//Show Page @1-03808B0A
$incl_ClixTop->Show();
$incl_footer->Show();
$incl_sidebar->Show();
$clix_rec->Show();
$clix_list->Show();
$sub_order->Show();
$Tpl->block_path = "";
$Tpl->Parse($BlockToParse, false);
if (!isset($main_block)) $main_block = $Tpl->GetVar($BlockToParse);
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeOutput", $MainPage);
if ($CCSEventResult) echo $main_block;
//End Show Page

//Unload Page @1-4E0E58AC
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeUnload", $MainPage);
$DBConnection1->close();
$incl_ClixTop->Class_Terminate();
unset($incl_ClixTop);
$incl_footer->Class_Terminate();
unset($incl_footer);
$incl_sidebar->Class_Terminate();
unset($incl_sidebar);
unset($clix_rec);
unset($clix_list);
unset($sub_order);
unset($Tpl);
//End Unload Page


?>
