Ladda.bind('.ladda-button');
//Ladda.bind( 'button[type=submit]' );

function clix_enable_div() {
    $('#content').unblock();

}

function clix_disable_div() {
    $('#content').block({
        message: $('#throbber'),
        overlayCSS: {
            backgroundColor: '#fff',
            opacity: 0.7,
            cursor: 'wait'
        },
        css: {
            padding: 0,
            margin: 0,
            width: '30%',
            top: '40%',
            left: '35%',
            textAlign: 'center',
            color: '#000',
            border: '0px solid #aaa',
            backgroundColor: 'rgba(100%,100%,100%,0)',
            cursor: 'wait'
        },
    });
}

$('#clix_myModal_remote').on('hidden.bs.modal', function () {
// alert('hi,,');
    //$(this).removeData('bs.modal');
    // $(this).remove();
    $('#clix_myModal_remote').find('.modal-content').html('<img src="clixlogic/spiffygif_26x26.gif">');
});

//region Get Existing data
function getExistingData(clixCallBack) {


    $.ajax({
        url: 'clix_ajax/mst-service-location-ajax.php',
        method: 'POST',
        dataType: 'text',
        data: {
            key: 'getExistingData'
        }, success: function (response) {
            if (response != "reachedMax") {
                $('tbody').append(response);
                clixCallBack(); // this is custom callback
            } else
            //$(".table").DataTable();
                clixCallBack(); // this is custom callback
        }
    });


}

//endregion

//region Get data for modal from database using ajax
function getData(myItemId, clixCallBack) {
    //alert(myRowId);

    if (myItemId > 0) {

        var mod_service_location  = $("#mod_service_location");
        var mod_branch  = $("#mod_branch");
        var mod_odi_allocation1  = $("#mod_odi_allocation1");
        var mod_odi_allocation2  = $("#mod_odi_allocation2");
		var mod_service_location_code  = $("#mod_service_location_code");
       /* var mod_v_length  = $("#mod_v_length");
        var mod_v_type  = $("#mod_v_type");
        var mod_v_chassis_no  = $("#mod_v_chassis_no");
        var mod_v_registration_date  = $("#mod_v_registration_date");
        var mod_v_insurance_exp_date  = $("#mod_v_insurance_exp_date");
        var mod_v_fitness_exp_date  = $("#mod_v_fitness_exp_date");*/
        $.ajax({
            url: 'clix_ajax/mst-service-location-ajax.php',
            method: 'POST',
            dataType: 'json',
            data: {
                key: 'getModalData',
                itemId: myItemId
            }, success: function (response) {
                mod_service_location.val(response.servicelocation_name);
				mod_service_location.prop('disabled', true);
                mod_service_location_code.val(response.servicelocation_code);
                mod_branch.empty().append('<option value="' + response.branch_code + '">' + response.branch_name + '</option>').val(response.branch_code).trigger('change.select2');
				$("input[name='mod_odi_allocation'][value='" + response.flag_odi + "']").prop('checked',true);
                /*mod_v_no.val(response.mod_v_no);
                mod_v_no.prop('disabled', true);
                mod_v_capacity.val(response.mod_v_capacity);
                mod_v_length.val(response.mod_v_length);
                //mod_v_type.val(response.mod_v_type);
                mod_v_type.empty().append('<option value="' + response.mod_v_type + '">' + response.vehicle_type_name + '</option>').val(response.mod_v_type).trigger('change.select2');
                mod_v_chassis_no.val(response.mod_v_chassis_no);
                mod_v_registration_date.val(response.mod_v_registration_date);
                mod_v_insurance_exp_date.val(response.mod_v_insurance_exp_date);
                mod_v_fitness_exp_date.val(response.mod_v_fitness_exp_date);*/

                //----  change modal title
                $("#myModalLabel").html("Edit Service Location: "+response.servicelocation_name);
                clixCallBack(); // this is custom callback
            }
        });
    } else {
        $("#myModalLabel").html("Add New Service Location");
        clixCallBack(); // this is custom callback
    }


}
//endregion


//region Jquery Submit (Modal window)
$('#clix_myModal_remote').on('loaded.bs.modal', function (e) {

    $.validator.addMethod("clix_onlyCharNumRegex", function (value, element) {
        return this.optional(element) || /^[a-z0-9\s]+$/i.test(value);
    }, "Username must contain only letters, numbers, or dashes.");


    var errorClass = 'invalid';
    var errorElement = 'em';

//---------------------- jquery validation for v_id start

    var $orderForm = $("#mst_service_location").validate({

        framework: 'bootstrap',
        excluded: ':disabled',
        icon: {
            valid: 'glyphicon glyphicon-ok',
            invalid: 'glyphicon glyphicon-remove',
            validating: 'glyphicon glyphicon-refresh'
        },
        ignore: [],
        errorClass: errorClass,
        errorElement: errorElement,
        highlight: function (element) {
            $(element).parent().removeClass('state-success').addClass("state-error");
            $(element).removeClass('valid');
        },
        unhighlight: function (element) {
            $(element).parent().removeClass("state-error").addClass('state-success');
            $(element).addClass('valid');
        },
        // Rules for form validation
        rules: {
            mod_service_location: {
                required: true,
                //clix_onlyCharNumRegex: true,

                remote: function () {
                    var r = {
                        url: 'clix_ajax/mst-service-location-ajax.php',
                        type: "post",
                        dataType: "json",
                        //contentType: "application/json; charset=utf-8",
                        cache: false,
                        data: {mod_service_location: $('#mod_service_location').val(), key: 'checkDuplicateServiceLocation'},
                        dataFilter: function (response) {
                            this.email_run = true; //fix for race condition with next button
                            return isAvailable(response); //return true or false
                        }
                    };
                    //alert(r);
                    return r;

                    function isAvailable(data) {
                        // alert (data);
                        //   var response = JSON.parse(getJsonObject(data));
                        //   return (response.isAvailable === "true") ? true : false;
                        return data;
                    };


                },


            },

            mod_branch: {
                required: true,
            },
          /*  mod_v_type: {
                required: true,
            },

            mod_v_capacity__: {
                required: true,
                digits: true
            },

            mod_v_length__: {
                required: true,
                digits: true
            },*/


        },


        // Messages for form validation
        messages: {
            mod_service_location: {
                required: '<span style="color:red;">Please enter Service Location......</span>',
               // clix_onlyCharNumRegex: '<span style="color:red;">Vehicle no. must contain only letters and numbers......</span>',
                remote: "Login Id already taken..",
            },
            mod_branch: {
                required: '<span style="color:red;">Please select a Branch......</span>',

            },
           /* mod_v_type: {
                required: '<span style="color:red;">Please select a vehicle type......</span>',

            },
            mod_v_capacity__: {
                required: '<span style="color:red;">Please enter vehicle capacity ......</span>',
                digits: '<span style="color:red;">Please enter digits only......</span>'
            },

            mod_v_length__: {
                required: '<span style="color:red;">Please enter vehicle length ......</span>',
                digits: '<span style="color:red;">Please enter digits only......</span>'
            },*/

        },

        // Do not change code below
        errorPlacement: function (error, element) {
            error.insertAfter(element.parent());
            //	error.insertAfter(element);
        },


        submitHandler: function (form) {

            var options = {
                //url: 'clix_modal/aj_modal_mst_vehicle_add_edit_edit.php',
                url: 'clix_ajax/mst-service-location-ajax.php',
                beforeSubmit: showRequest,  // pre-submit callback
                data: {
                    key: 'editData'
                },
                error: function () {
                    alert("hi! error...  contact system admin");
                    $('.form-footer').removeClass('progress');
                },
                success: showResponse,  // post-submit callback
            };

            $('#mst_service_location').ajaxSubmit(options);

        }

    });

    function showRequest(formData, jqForm, options) {
        $('#mst_service_location').waitMe({
            effect: 'rotateplane',
            text: '',
            bg: 'rgba(255,255,255,0.7)',
            color: '#000',
            maxSize: '',
            textPos: 'vertical',
            fontSize: '',
            source: ''
        });
        return true;
    }

    function showResponse(responseText, statusText, xhr, $form) {
        $('#mst_service_location').waitMe("hide");

        my_array_of_return_values = responseText.split('~~~');
        if (my_array_of_return_values["0"] == 'A') {

            //------- change selected value after record added start
            $("#v_id").append("<option value='" + my_array_of_return_values['1'] + "' selected='selected'>" + my_array_of_return_values['2'] + "</option>");
            $("#select2-v_id-container").html('<span class="select2-selection__clear"></span>' + my_array_of_return_values['2']);
            //------- change selected value after record added end


// ---- append new row to the top
            $('#datatable_fixed_column tbody').prepend(my_array_of_return_values["3"]);
            $.smallBox({
                title: "Success!",
                content: "<i class='fa fa-clock-o'></i> <i>New service location added...</i>",
                color: "#659265",
                iconSmall: "fa fa-check fa-2x fadeInRight animated",
                timeout: 1600
            });
        } else {

            if (my_array_of_return_values["0"] == 'U') {

                var my_value = my_array_of_return_values["1"];
                // ---- insert updated row and remove old row
                //$(my_array_of_return_values["3"]).insertBefore($("input[name='v_id'][value='" + my_value + "']").parents("tr"));
                //$("input[name='v_id'][value='" + my_value + "'][clixdelnext='next']").closest("tr").next("tr").remove();
                //  $(selector).removeAttr(attribute)
                //$("input[name='v_id'][value='" + my_value + "'][clixdelnext='next']").removeAttr(clixdelnext);
                $("input[name='v_id'][value='" + my_value + "']").parents("tr").replaceWith(my_array_of_return_values["3"]);

                $.smallBox({
                    title: "Success!",
                    content: "<i class='fa fa-clock-o'></i> <i>Service location updated...</i>",
                    color: "#659265",
                    iconSmall: "fa fa-check fa-2x fadeInRight animated",
                    timeout: 4000
                });
            } else {
                $.smallBox({
                    title: "Fail!",
                    content: "<i class='fa fa-clock-o'></i> <i>Service location Add/Update Failed...</i>",
                    color: "#C46A69",
                    iconSmall: "fa fa-times fa-2x fadeInRight animated",
                    timeout: 4000
                });
            }
        }


        /*     else{
             $.smallBox({
                 title : "Fail!",
                 content : "<i class='fa fa-clock-o'></i> <i>Vehicle Add process failed...</i>",
                 color : "#C46A69",
                 iconSmall : "fa fa-times fa-2x fadeInRight animated",
                 timeout : 1600
             });
             }
        */

        var delay = 2000; //1 seconds
        setTimeout(function () {

            $('#clix_myModal_remote').modal('toggle');

        }, delay);

    }

//---------------------- jquery validation for v_id end
});
//endregion

//region Delete record
function clix_remove(clicked_id) {
alert ("Delete is disabled !");
clix_disable_div();
    setTimeout(function () {
        var my_id = $("#" + clicked_id).siblings("input[name='v_id']").val();
//alert (clicked_id+' Hi,  row item id: '+my_id);
        $.post('clix_ajax/mst-service-location-ajax.php', {m: my_id, key: 'deleteServiceLocation'},
            function (returnedData) {
                $("#" + clicked_id).siblings("input[name='v_id']").closest("tr").remove();
 //               alert("Deleted");
              alert ("Delete is not allowed !");
                clix_enable_div();
                Ladda.stopAll();
            }).fail(function () {
            // console.log("error");
            alert("Error");
            clix_enable_div();
        });
    }, 500);
}
//endregion

//region Generate pdf
function clix_pdf(clicked_id) {
//	 alert (clicked_id);
    setTimeout(function () {

// https://stackoverflow.com/questions/20830309/download-file-using-an-ajax-request

//var my_t = $(this).parent().siblings('.clix-item').val();
//var my_t =  $(this).parent().find("input[type='hidden']").val();
        var my_t = $("#" + clicked_id).siblings("input[name='h_thc']").val();
        var my_branch = $("#" + clicked_id).siblings("input[name='h_prefix_branch_code']").val();
//alert (clicked_id+' Hi,  pdf ticket id: '+my_t);
//$.post('z_service_report_pdf_generate.php', { t: my_t}, //-----------------------
        $.post('pdf_generate_thc.php', {thc_no: my_t, branch: my_branch}, //-----------------------
            function (returnedData) {
                // console.log(returnedData);
                Ladda.stopAll();
//     window.location = 'z_service_report_pdf_download.php';  //----------------- http://ilservice.in/z_invoice_group_print_PrePrintedPaper.php?gi=1718000025&ViewMode=Print
                window.location = 'pdf_download_thc.php';    //--------------------
            }).fail(function () {
            // console.log("error");

            alert("Error");
            Ladda.stopAll();
        });


    }, 500);
}
//endregion

$(document).ready(function () {

//----  To load external files for navigation, header and footer
    $("#header").load("ps_incl_header.php");
    $("#clix_menu").load("ps_incl_left_panel.php");
    $("#clix_footer").load("ps_incl_footer.php");

//---- To load existing data in list

    Pace.track(function () {  //--- pace loader
        getExistingData(function () {
            //--  alert ('get date success');
            //-- todo despatch
            //-- todo print
            //-- todo manifest

            clixPageOnload();
        });
    });

    function clixPageOnload() {
        pageSetUp();

        /* BASIC ;*/
        var responsiveHelper_dt_basic = undefined;
        var responsiveHelper_datatable_fixed_column = undefined;
        var responsiveHelper_datatable_col_reorder = undefined;
        var responsiveHelper_datatable_tabletools = undefined;

        var breakpointDefinition = {
            tablet: 1024,
            phone: 480
        };
        /*      */
        $('#dt_basic').dataTable({
            "sDom": "<'dt-toolbar'<'col-xs-12 col-sm-6'f><'col-sm-6 col-xs-12 hidden-xs'l>r>" +
            "t" +
            "<'dt-toolbar-footer'<'col-sm-6 col-xs-12 hidden-xs'i><'col-xs-12 col-sm-6'p>>",
            "autoWidth": true,
            "oLanguage": {
                "sSearch": '<span class="input-group-addon"><i class="glyphicon glyphicon-search"></i></span>'
            },
            "preDrawCallback": function () {
                // Initialize the responsive datatables helper once.
                if (!responsiveHelper_dt_basic) {
                    responsiveHelper_dt_basic = new ResponsiveDatatablesHelper($('#dt_basic'), breakpointDefinition);
                }
            },
            "rowCallback": function (nRow) {
                responsiveHelper_dt_basic.createExpandIcon(nRow);
            },
            "drawCallback": function (oSettings) {
                responsiveHelper_dt_basic.respond();
            }
        });

        /* END BASIC */

        /* COLUMN FILTER  */
        //region Datatable
        var otable = $('#datatable_fixed_column').DataTable({
            //"aaSorting": [[0,'dsc']],
            "aaSorting": [], // disable initial sorting
            "lengthMenu": [[10, 25, 50, -1], [10, 25, 50, "All"]],
            //"bFilter": false,
            //"bInfo": false,
            "bLengthChange": true,
            //"bAutoWidth": false,
            //"bPaginate": false,
            //"bStateSave": true // saves sort state using localStorage
            "sDom": "<'dt-toolbar'<'col-xs-12 col-sm-6 hidden-xs'f><'col-sm-6 col-xs-12 hidden-xs'<'toolbar'>>r>" +
            "t" +
            "<'dt-toolbar-footer'<'col-sm-6 col-xs-12 hidden-xs'i><'col-xs-12 col-sm-6'p>>",
            "autoWidth": true,
            "oLanguage": {
                "sSearch": '<span class="input-group-addon"><i class="glyphicon glyphicon-search"></i></span>'
            },


            "preDrawCallback": function () {
                // Initialize the responsive datatables helper once.
                if (!responsiveHelper_datatable_fixed_column) {
                    responsiveHelper_datatable_fixed_column = new ResponsiveDatatablesHelper($('#datatable_fixed_column'), breakpointDefinition);
                }
            },
            "rowCallback": function (nRow) {
                responsiveHelper_datatable_fixed_column.createExpandIcon(nRow);
            },
            "drawCallback": function (oSettings) {
                responsiveHelper_datatable_fixed_column.respond();
            }

        });
        //endregion

        //region Button (Add new record)
        // custom toolbar
        $("div.toolbar").html('<div class="text-right"> <a data-toggle="modal" href="clix_modal/mst-service-location-add-edit.php" data-target="#clix_myModal_remote" class="btn btn-labeled btn-warning"> <span class="btn-label"><i class="glyphicon glyphicon-bookmark"></i></span>Add New Service Location </a> <img src="img/logo.png" alt="Clixlogic" style="width: 111px; margin-top: 3px; margin-right: 10px;"></div>');
        //endregion

        // Apply the filter
        $("#datatable_fixed_column thead th input[type=text]").on('keyup change', function () {

            otable
                .column($(this).parent().index() + ':visible')
                .search(this.value)
                .draw();

        });
        /* END COLUMN FILTER */

        /* COLUMN SHOW - HIDE */
        $('#datatable_col_reorder').dataTable({
            "sDom": "<'dt-toolbar'<'col-xs-12 col-sm-6'f><'col-sm-6 col-xs-6 hidden-xs'C>r>" +
            "t" +
            "<'dt-toolbar-footer'<'col-sm-6 col-xs-12 hidden-xs'i><'col-sm-6 col-xs-12'p>>",
            "autoWidth": true,
            "oLanguage": {
                "sSearch": '<span class="input-group-addon"><i class="glyphicon glyphicon-search"></i></span>'
            },
            "preDrawCallback": function () {
                // Initialize the responsive datatables helper once.
                if (!responsiveHelper_datatable_col_reorder) {
                    responsiveHelper_datatable_col_reorder = new ResponsiveDatatablesHelper($('#datatable_col_reorder'), breakpointDefinition);
                }
            },
            "rowCallback": function (nRow) {
                responsiveHelper_datatable_col_reorder.createExpandIcon(nRow);
            },
            "drawCallback": function (oSettings) {
                responsiveHelper_datatable_col_reorder.respond();
            }
        });

        /* END COLUMN SHOW - HIDE */

        /* TABLETOOLS */
        $('#datatable_tabletools').dataTable({

            // Tabletools options:
            //   https://datatables.net/extensions/tabletools/button_options
            "sDom": "<'dt-toolbar'<'col-xs-12 col-sm-6'f><'col-sm-6 col-xs-6 hidden-xs'T>r>" +
            "t" +
            "<'dt-toolbar-footer'<'col-sm-6 col-xs-12 hidden-xs'i><'col-sm-6 col-xs-12'p>>",
            "oLanguage": {
                "sSearch": '<span class="input-group-addon"><i class="glyphicon glyphicon-search"></i></span>'
            },
            "oTableTools": {
                "aButtons": [
                    "copy",
                    "csv",
                    "xls",
                    {
                        "sExtends": "pdf",
                        "sTitle": "Clixlogic_PDF",
                        "sPdfMessage": "Clixlogic PDF Export",
                        "sPdfSize": "letter"
                    },
                    {
                        "sExtends": "print",
                        "sMessage": "Generated by Clixlogic <i>(press Esc to close)</i>"
                    }
                ],
                "sSwfPath": "js/plugin/datatables/swf/copy_csv_xls_pdf.swf"
            },
            "autoWidth": true,
            "preDrawCallback": function () {
                // Initialize the responsive datatables helper once.
                if (!responsiveHelper_datatable_tabletools) {
                    responsiveHelper_datatable_tabletools = new ResponsiveDatatablesHelper($('#datatable_tabletools'), breakpointDefinition);
                }
            },
            "rowCallback": function (nRow) {
                responsiveHelper_datatable_tabletools.createExpandIcon(nRow);
            },
            "drawCallback": function (oSettings) {
                responsiveHelper_datatable_tabletools.respond();
            }

        });

        /* END TABLETOOLS */

    }

})