<?php
//Include Common Files @1-EF20D90F
define("RelativePath", "..");
define("PathToCurrentPage", "/clix_modal/");
define("FileName", "modal_mst_route_contract_add_edit.php");
include_once(RelativePath . "/Common.php");
include_once(RelativePath . "/Template.php");
include_once(RelativePath . "/Sorter.php");
include_once(RelativePath . "/Navigator.php");
//End Include Common Files

class clsRecordmst_vehicle { //mst_vehicle Class @2-2CD35D04

//Variables @2-9E315808

    // Public variables
    public $ComponentType = "Record";
    public $ComponentName;
    public $Parent;
    public $HTMLFormAction;
    public $PressedButton;
    public $Errors;
    public $ErrorBlock;
    public $FormSubmitted;
    public $FormEnctype;
    public $Visible;
    public $IsEmpty;

    public $CCSEvents = "";
    public $CCSEventResult;

    public $RelativePath = "";

    public $InsertAllowed = false;
    public $UpdateAllowed = false;
    public $DeleteAllowed = false;
    public $ReadAllowed   = false;
    public $EditMode      = false;
    public $ds;
    public $DataSource;
    public $ValidatingControls;
    public $Controls;
    public $Attributes;

    // Class variables
//End Variables

//Class_Initialize Event @2-D6101EF2
    function clsRecordmst_vehicle($RelativePath, & $Parent)
    {

        global $FileName;
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->Visible = true;
        $this->Parent = & $Parent;
        $this->RelativePath = $RelativePath;
        $this->Errors = new clsErrors();
        $this->ErrorBlock = "Record mst_vehicle/Error";
        $this->DataSource = new clsmst_vehicleDataSource($this);
        $this->ds = & $this->DataSource;
        $this->InsertAllowed = true;
        $this->UpdateAllowed = true;
        $this->ReadAllowed = true;
        if($this->Visible)
        {
            $this->ComponentName = "mst_vehicle";
            $this->Attributes = new clsAttributes($this->ComponentName . ":");
            $CCSForm = explode(":", CCGetFromGet("ccsForm", ""), 2);
            if(sizeof($CCSForm) == 1)
                $CCSForm[1] = "";
            list($FormName, $FormMethod) = $CCSForm;
            $this->EditMode = ($FormMethod == "Edit");
            $this->FormEnctype = "application/x-www-form-urlencoded";
            $this->FormSubmitted = ($FormName == $this->ComponentName);
            $Method = $this->FormSubmitted ? ccsPost : ccsGet;
            $this->item_id = new clsControl(ccsHidden, "item_id", "V Id", ccsInteger, "", CCGetRequestParam("item_id", $Method, NULL), $this);
            $this->route_amount = new clsControl(ccsTextBox, "route_amount", "Chassis No", ccsFloat, array(False, 2, Null, "", False, "", "", 1, True, ""), CCGetRequestParam("route_amount", $Method, NULL), $this);
            $this->contract_date = new clsControl(ccsTextBox, "contract_date", "Registration Date", ccsDate, array("dd", "/", "mm", "/", "yyyy"), CCGetRequestParam("contract_date", $Method, NULL), $this);
            $this->expiry_date = new clsControl(ccsTextBox, "expiry_date", "Insurance Exp Date", ccsDate, array("dd", "/", "mm", "/", "yyyy"), CCGetRequestParam("expiry_date", $Method, NULL), $this);
            $this->vendor_type = new clsControl(ccsTextBox, "vendor_type", "Capacity", ccsText, "", CCGetRequestParam("vendor_type", $Method, NULL), $this);
            $this->mod_vendor_id = new clsControl(ccsListBox, "mod_vendor_id", "From", ccsInteger, "", CCGetRequestParam("mod_vendor_id", $Method, NULL), $this);
            $this->mod_vendor_id->HTML = true;
            $this->route_type = new clsControl(ccsTextBox, "route_type", "Capacity", ccsText, "", CCGetRequestParam("route_type", $Method, NULL), $this);
            $this->mod_route_id = new clsControl(ccsListBox, "mod_route_id", "From", ccsInteger, "", CCGetRequestParam("mod_route_id", $Method, NULL), $this);
            $this->mod_route_id->HTML = true;
            $this->v_type = new clsControl(ccsTextBox, "v_type", "Capacity", ccsText, "", CCGetRequestParam("v_type", $Method, NULL), $this);
            $this->mod_vehicle_id = new clsControl(ccsListBox, "mod_vehicle_id", "From", ccsInteger, "", CCGetRequestParam("mod_vehicle_id", $Method, NULL), $this);
            $this->mod_vehicle_id->HTML = true;
        }
    }
//End Class_Initialize Event

//Initialize Method @2-EE8164CC
    function Initialize()
    {

        if(!$this->Visible)
            return;

        $this->DataSource->Parameters["sescompany_code"] = CCGetSession("company_code", NULL);
        $this->DataSource->Parameters["urlv"] = CCGetFromGet("v", NULL);
    }
//End Initialize Method

//Validate Method @2-5F81822B
    function Validate()
    {
        global $CCSLocales;
        $Validation = true;
        $Where = "";
        $Validation = ($this->item_id->Validate() && $Validation);
        $Validation = ($this->route_amount->Validate() && $Validation);
        $Validation = ($this->contract_date->Validate() && $Validation);
        $Validation = ($this->expiry_date->Validate() && $Validation);
        $Validation = ($this->vendor_type->Validate() && $Validation);
        $Validation = ($this->mod_vendor_id->Validate() && $Validation);
        $Validation = ($this->route_type->Validate() && $Validation);
        $Validation = ($this->mod_route_id->Validate() && $Validation);
        $Validation = ($this->v_type->Validate() && $Validation);
        $Validation = ($this->mod_vehicle_id->Validate() && $Validation);
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "OnValidate", $this);
        $Validation =  $Validation && ($this->item_id->Errors->Count() == 0);
        $Validation =  $Validation && ($this->route_amount->Errors->Count() == 0);
        $Validation =  $Validation && ($this->contract_date->Errors->Count() == 0);
        $Validation =  $Validation && ($this->expiry_date->Errors->Count() == 0);
        $Validation =  $Validation && ($this->vendor_type->Errors->Count() == 0);
        $Validation =  $Validation && ($this->mod_vendor_id->Errors->Count() == 0);
        $Validation =  $Validation && ($this->route_type->Errors->Count() == 0);
        $Validation =  $Validation && ($this->mod_route_id->Errors->Count() == 0);
        $Validation =  $Validation && ($this->v_type->Errors->Count() == 0);
        $Validation =  $Validation && ($this->mod_vehicle_id->Errors->Count() == 0);
        return (($this->Errors->Count() == 0) && $Validation);
    }
//End Validate Method

//CheckErrors Method @2-007ED19C
    function CheckErrors()
    {
        $errors = false;
        $errors = ($errors || $this->item_id->Errors->Count());
        $errors = ($errors || $this->route_amount->Errors->Count());
        $errors = ($errors || $this->contract_date->Errors->Count());
        $errors = ($errors || $this->expiry_date->Errors->Count());
        $errors = ($errors || $this->vendor_type->Errors->Count());
        $errors = ($errors || $this->mod_vendor_id->Errors->Count());
        $errors = ($errors || $this->route_type->Errors->Count());
        $errors = ($errors || $this->mod_route_id->Errors->Count());
        $errors = ($errors || $this->v_type->Errors->Count());
        $errors = ($errors || $this->mod_vehicle_id->Errors->Count());
        $errors = ($errors || $this->Errors->Count());
        $errors = ($errors || $this->DataSource->Errors->Count());
        return $errors;
    }
//End CheckErrors Method

//MasterDetail @2-ED598703
function SetPrimaryKeys($keyArray)
{
    $this->PrimaryKeys = $keyArray;
}
function GetPrimaryKeys()
{
    return $this->PrimaryKeys;
}
function GetPrimaryKey($keyName)
{
    return $this->PrimaryKeys[$keyName];
}
//End MasterDetail

//Operation Method @2-17DC9883
    function Operation()
    {
        if(!$this->Visible)
            return;

        global $Redirect;
        global $FileName;

        $this->DataSource->Prepare();
        if(!$this->FormSubmitted) {
            $this->EditMode = $this->DataSource->AllParametersSet;
            return;
        }

        $Redirect = $FileName . "?" . CCGetQueryString("QueryString", array("ccsForm"));
        if ($Redirect)
            $this->DataSource->close();
    }
//End Operation Method

//InsertRow Method @2-1B59AEC6
    function InsertRow()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeInsert", $this);
        if(!$this->InsertAllowed) return false;
        $this->DataSource->item_id->SetValue($this->item_id->GetValue(true));
        $this->DataSource->route_amount->SetValue($this->route_amount->GetValue(true));
        $this->DataSource->contract_date->SetValue($this->contract_date->GetValue(true));
        $this->DataSource->expiry_date->SetValue($this->expiry_date->GetValue(true));
        $this->DataSource->vendor_type->SetValue($this->vendor_type->GetValue(true));
        $this->DataSource->mod_vendor_id->SetValue($this->mod_vendor_id->GetValue(true));
        $this->DataSource->route_type->SetValue($this->route_type->GetValue(true));
        $this->DataSource->mod_route_id->SetValue($this->mod_route_id->GetValue(true));
        $this->DataSource->v_type->SetValue($this->v_type->GetValue(true));
        $this->DataSource->mod_vehicle_id->SetValue($this->mod_vehicle_id->GetValue(true));
        $this->DataSource->Insert();
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterInsert", $this);
        return (!$this->CheckErrors());
    }
//End InsertRow Method

//UpdateRow Method @2-906D1198
    function UpdateRow()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeUpdate", $this);
        if(!$this->UpdateAllowed) return false;
        $this->DataSource->item_id->SetValue($this->item_id->GetValue(true));
        $this->DataSource->route_amount->SetValue($this->route_amount->GetValue(true));
        $this->DataSource->contract_date->SetValue($this->contract_date->GetValue(true));
        $this->DataSource->expiry_date->SetValue($this->expiry_date->GetValue(true));
        $this->DataSource->vendor_type->SetValue($this->vendor_type->GetValue(true));
        $this->DataSource->mod_vendor_id->SetValue($this->mod_vendor_id->GetValue(true));
        $this->DataSource->route_type->SetValue($this->route_type->GetValue(true));
        $this->DataSource->mod_route_id->SetValue($this->mod_route_id->GetValue(true));
        $this->DataSource->v_type->SetValue($this->v_type->GetValue(true));
        $this->DataSource->mod_vehicle_id->SetValue($this->mod_vehicle_id->GetValue(true));
        $this->DataSource->Update();
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterUpdate", $this);
        return (!$this->CheckErrors());
    }
//End UpdateRow Method

//Show Method @2-1E8C1D6D
    function Show()
    {
        global $CCSUseAmp;
        global $Tpl;
        global $FileName;
        global $CCSLocales;
        $Error = "";

        if(!$this->Visible)
            return;

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeSelect", $this);

        $this->mod_vendor_id->Prepare();
        $this->mod_route_id->Prepare();
        $this->mod_vehicle_id->Prepare();

        $RecordBlock = "Record " . $this->ComponentName;
        $ParentPath = $Tpl->block_path;
        $Tpl->block_path = $ParentPath . "/" . $RecordBlock;
        $this->EditMode = $this->EditMode && $this->ReadAllowed;
        if($this->EditMode) {
            if($this->DataSource->Errors->Count()){
                $this->Errors->AddErrors($this->DataSource->Errors);
                $this->DataSource->Errors->clear();
            }
            $this->DataSource->Open();
            if($this->DataSource->Errors->Count() == 0 && $this->DataSource->next_record()) {
                $this->DataSource->SetValues();
                if(!$this->FormSubmitted){
                    $this->item_id->SetValue($this->DataSource->item_id->GetValue());
                    $this->route_amount->SetValue($this->DataSource->route_amount->GetValue());
                    $this->contract_date->SetValue($this->DataSource->contract_date->GetValue());
                    $this->expiry_date->SetValue($this->DataSource->expiry_date->GetValue());
                    $this->mod_vendor_id->SetValue($this->DataSource->mod_vendor_id->GetValue());
                    $this->mod_route_id->SetValue($this->DataSource->mod_route_id->GetValue());
                    $this->mod_vehicle_id->SetValue($this->DataSource->mod_vehicle_id->GetValue());
                }
            } else {
                $this->EditMode = false;
            }
        }
        if (!$this->FormSubmitted) {
        }

        if($this->FormSubmitted || $this->CheckErrors()) {
            $Error = "";
            $Error = ComposeStrings($Error, $this->item_id->Errors->ToString());
            $Error = ComposeStrings($Error, $this->route_amount->Errors->ToString());
            $Error = ComposeStrings($Error, $this->contract_date->Errors->ToString());
            $Error = ComposeStrings($Error, $this->expiry_date->Errors->ToString());
            $Error = ComposeStrings($Error, $this->vendor_type->Errors->ToString());
            $Error = ComposeStrings($Error, $this->mod_vendor_id->Errors->ToString());
            $Error = ComposeStrings($Error, $this->route_type->Errors->ToString());
            $Error = ComposeStrings($Error, $this->mod_route_id->Errors->ToString());
            $Error = ComposeStrings($Error, $this->v_type->Errors->ToString());
            $Error = ComposeStrings($Error, $this->mod_vehicle_id->Errors->ToString());
            $Error = ComposeStrings($Error, $this->Errors->ToString());
            $Error = ComposeStrings($Error, $this->DataSource->Errors->ToString());
            $Tpl->SetVar("Error", $Error);
            $Tpl->Parse("Error", false);
        }
        $CCSForm = $this->EditMode ? $this->ComponentName . ":" . "Edit" : $this->ComponentName;
        $this->HTMLFormAction = $FileName . "?" . CCAddParam(CCGetQueryString("QueryString", ""), "ccsForm", $CCSForm);
        $Tpl->SetVar("Action", !$CCSUseAmp ? $this->HTMLFormAction : str_replace("&", "&amp;", $this->HTMLFormAction));
        $Tpl->SetVar("HTMLFormName", $this->ComponentName);
        $Tpl->SetVar("HTMLFormEnctype", $this->FormEnctype);

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShow", $this);
        $this->Attributes->Show();
        if(!$this->Visible) {
            $Tpl->block_path = $ParentPath;
            return;
        }

        $this->item_id->Show();
        $this->route_amount->Show();
        $this->contract_date->Show();
        $this->expiry_date->Show();
        $this->vendor_type->Show();
        $this->mod_vendor_id->Show();
        $this->route_type->Show();
        $this->mod_route_id->Show();
        $this->v_type->Show();
        $this->mod_vehicle_id->Show();
        $Tpl->parse();
        $Tpl->block_path = $ParentPath;
        $this->DataSource->close();
    }
//End Show Method

} //End mst_vehicle Class @2-FCB6E20C

class clsmst_vehicleDataSource extends clsDBConnection1 {  //mst_vehicleDataSource Class @2-17585DC6

//DataSource Variables @2-0905135E
    public $Parent = "";
    public $CCSEvents = "";
    public $CCSEventResult;
    public $ErrorBlock;
    public $CmdExecution;

    public $InsertParameters;
    public $UpdateParameters;
    public $wp;
    public $AllParametersSet;

    public $InsertFields = array();
    public $UpdateFields = array();

    // Datasource fields
    public $item_id;
    public $route_amount;
    public $contract_date;
    public $expiry_date;
    public $vendor_type;
    public $mod_vendor_id;
    public $route_type;
    public $mod_route_id;
    public $v_type;
    public $mod_vehicle_id;
//End DataSource Variables

//DataSourceClass_Initialize Event @2-6557D25E
    function clsmst_vehicleDataSource(& $Parent)
    {
        $this->Parent = & $Parent;
        $this->ErrorBlock = "Record mst_vehicle/Error";
        $this->Initialize();
        $this->item_id = new clsField("item_id", ccsInteger, "");
        
        $this->route_amount = new clsField("route_amount", ccsFloat, "");
        
        $this->contract_date = new clsField("contract_date", ccsDate, array("yyyy", "-", "mm", "-", "dd", " ", "HH", ":", "nn", ":", "ss"));
        
        $this->expiry_date = new clsField("expiry_date", ccsDate, array("yyyy", "-", "mm", "-", "dd", " ", "HH", ":", "nn", ":", "ss"));
        
        $this->vendor_type = new clsField("vendor_type", ccsText, "");
        
        $this->mod_vendor_id = new clsField("mod_vendor_id", ccsInteger, "");
        
        $this->route_type = new clsField("route_type", ccsText, "");
        
        $this->mod_route_id = new clsField("mod_route_id", ccsInteger, "");
        
        $this->v_type = new clsField("v_type", ccsText, "");
        
        $this->mod_vehicle_id = new clsField("mod_vehicle_id", ccsInteger, "");
        

        $this->InsertFields["route_contract_id"] = array("Name" => "route_contract_id", "Value" => "", "DataType" => ccsInteger, "OmitIfEmpty" => 1);
        $this->InsertFields["route_amount"] = array("Name" => "route_amount", "Value" => "", "DataType" => ccsFloat, "OmitIfEmpty" => 1);
        $this->InsertFields["contract_date"] = array("Name" => "contract_date", "Value" => "", "DataType" => ccsDate, "OmitIfEmpty" => 1);
        $this->InsertFields["expiry_date"] = array("Name" => "expiry_date", "Value" => "", "DataType" => ccsDate, "OmitIfEmpty" => 1);
        $this->InsertFields["vendor_id"] = array("Name" => "vendor_id", "Value" => "", "DataType" => ccsInteger, "OmitIfEmpty" => 1);
        $this->InsertFields["route_id"] = array("Name" => "route_id", "Value" => "", "DataType" => ccsInteger, "OmitIfEmpty" => 1);
        $this->InsertFields["vehicle_id"] = array("Name" => "vehicle_id", "Value" => "", "DataType" => ccsInteger, "OmitIfEmpty" => 1);
        $this->UpdateFields["route_contract_id"] = array("Name" => "route_contract_id", "Value" => "", "DataType" => ccsInteger, "OmitIfEmpty" => 1);
        $this->UpdateFields["route_amount"] = array("Name" => "route_amount", "Value" => "", "DataType" => ccsFloat, "OmitIfEmpty" => 1);
        $this->UpdateFields["contract_date"] = array("Name" => "contract_date", "Value" => "", "DataType" => ccsDate, "OmitIfEmpty" => 1);
        $this->UpdateFields["expiry_date"] = array("Name" => "expiry_date", "Value" => "", "DataType" => ccsDate, "OmitIfEmpty" => 1);
        $this->UpdateFields["vendor_id"] = array("Name" => "vendor_id", "Value" => "", "DataType" => ccsInteger, "OmitIfEmpty" => 1);
        $this->UpdateFields["route_id"] = array("Name" => "route_id", "Value" => "", "DataType" => ccsInteger, "OmitIfEmpty" => 1);
        $this->UpdateFields["vehicle_id"] = array("Name" => "vehicle_id", "Value" => "", "DataType" => ccsInteger, "OmitIfEmpty" => 1);
    }
//End DataSourceClass_Initialize Event

//Prepare Method @2-2B61C1F1
    function Prepare()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->wp = new clsSQLParameters($this->ErrorBlock);
        $this->wp->AddParameter("1", "sescompany_code", ccsInteger, "", "", $this->Parameters["sescompany_code"], -1, false);
        $this->wp->AddParameter("2", "urlv", ccsInteger, "", "", $this->Parameters["urlv"], "", false);
        $this->AllParametersSet = $this->wp->AllParamsSet();
        $this->wp->Criterion[1] = $this->wp->Operation(opEqual, "prefix_company_code", $this->wp->GetDBValue("1"), $this->ToSQL($this->wp->GetDBValue("1"), ccsInteger),false);
        $this->wp->Criterion[2] = $this->wp->Operation(opEqual, "route_contract_id", $this->wp->GetDBValue("2"), $this->ToSQL($this->wp->GetDBValue("2"), ccsInteger),false);
        $this->Where = $this->wp->opAND(
             false, 
             $this->wp->Criterion[1], 
             $this->wp->Criterion[2]);
    }
//End Prepare Method

//Open Method @2-068BCD2B
    function Open()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildSelect", $this->Parent);
        $this->SQL = "SELECT expiry_date, contract_date, route_amount, vehicle_id, vendor_id, route_id, route_contract_id, prefix_company_code \n\n" .
        "FROM mst_route_contract {SQL_Where} {SQL_OrderBy}";
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteSelect", $this->Parent);
        $this->PageSize = 1;
        $this->query($this->OptimizeSQL(CCBuildSQL($this->SQL, $this->Where, $this->Order)));
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteSelect", $this->Parent);
    }
//End Open Method

//SetValues Method @2-B981295E
    function SetValues()
    {
        $this->item_id->SetDBValue(trim($this->f("route_contract_id")));
        $this->route_amount->SetDBValue(trim($this->f("route_amount")));
        $this->contract_date->SetDBValue(trim($this->f("contract_date")));
        $this->expiry_date->SetDBValue(trim($this->f("expiry_date")));
        $this->mod_vendor_id->SetDBValue(trim($this->f("vendor_id")));
        $this->mod_route_id->SetDBValue(trim($this->f("route_id")));
        $this->mod_vehicle_id->SetDBValue(trim($this->f("vehicle_id")));
    }
//End SetValues Method

//Insert Method @2-162EAB63
    function Insert()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->CmdExecution = true;
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildInsert", $this->Parent);
        $this->InsertFields["route_contract_id"]["Value"] = $this->item_id->GetDBValue(true);
        $this->InsertFields["route_amount"]["Value"] = $this->route_amount->GetDBValue(true);
        $this->InsertFields["contract_date"]["Value"] = $this->contract_date->GetDBValue(true);
        $this->InsertFields["expiry_date"]["Value"] = $this->expiry_date->GetDBValue(true);
        $this->InsertFields["vendor_id"]["Value"] = $this->mod_vendor_id->GetDBValue(true);
        $this->InsertFields["route_id"]["Value"] = $this->mod_route_id->GetDBValue(true);
        $this->InsertFields["vehicle_id"]["Value"] = $this->mod_vehicle_id->GetDBValue(true);
        $this->SQL = CCBuildInsert("mst_route_contract", $this->InsertFields, $this);
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteInsert", $this->Parent);
        if($this->Errors->Count() == 0 && $this->CmdExecution) {
            $this->query($this->SQL);
            $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteInsert", $this->Parent);
        }
    }
//End Insert Method

//Update Method @2-A6793A69
    function Update()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->CmdExecution = true;
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildUpdate", $this->Parent);
        $this->UpdateFields["route_contract_id"]["Value"] = $this->item_id->GetDBValue(true);
        $this->UpdateFields["route_amount"]["Value"] = $this->route_amount->GetDBValue(true);
        $this->UpdateFields["contract_date"]["Value"] = $this->contract_date->GetDBValue(true);
        $this->UpdateFields["expiry_date"]["Value"] = $this->expiry_date->GetDBValue(true);
        $this->UpdateFields["vendor_id"]["Value"] = $this->mod_vendor_id->GetDBValue(true);
        $this->UpdateFields["route_id"]["Value"] = $this->mod_route_id->GetDBValue(true);
        $this->UpdateFields["vehicle_id"]["Value"] = $this->mod_vehicle_id->GetDBValue(true);
        $this->SQL = CCBuildUpdate("mst_route_contract", $this->UpdateFields, $this);
        $this->SQL .= strlen($this->Where) ? " WHERE " . $this->Where : $this->Where;
        if (!strlen($this->Where) && $this->Errors->Count() == 0) 
            $this->Errors->addError($CCSLocales->GetText("CCS_CustomOperationError_MissingParameters"));
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteUpdate", $this->Parent);
        if($this->Errors->Count() == 0 && $this->CmdExecution) {
            $this->query($this->SQL);
            $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteUpdate", $this->Parent);
        }
    }
//End Update Method

} //End mst_vehicleDataSource Class @2-FCB6E20C

//Initialize Page @1-489B45A7
// Variables
$FileName = "";
$Redirect = "";
$Tpl = "";
$TemplateFileName = "";
$BlockToParse = "";
$ComponentName = "";
$Attributes = "";

// Events;
$CCSEvents = "";
$CCSEventResult = "";

$FileName = FileName;
$Redirect = "";
$TemplateFileName = "modal_mst_route_contract_add_edit.html";
$BlockToParse = "main";
$TemplateEncoding = "CP1252";
$ContentType = "text/html";
$PathToRoot = "../";
//End Initialize Page

//Include events file @1-2C4A2B85
include_once("./modal_mst_route_contract_add_edit_events.php");
//End Include events file

//Before Initialize @1-E870CEBC
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeInitialize", $MainPage);
//End Before Initialize

//Initialize Objects @1-CCBBC548
$DBConnection1 = new clsDBConnection1();
$MainPage->Connections["Connection1"] = & $DBConnection1;
$Attributes = new clsAttributes("page:");
$MainPage->Attributes = & $Attributes;

// Controls
$mst_vehicle = new clsRecordmst_vehicle("", $MainPage);
$MainPage->mst_vehicle = & $mst_vehicle;
$mst_vehicle->Initialize();

BindEvents();

$CCSEventResult = CCGetEvent($CCSEvents, "AfterInitialize", $MainPage);

if ($Charset) {
    header("Content-Type: " . $ContentType . "; charset=" . $Charset);
} else {
    header("Content-Type: " . $ContentType);
}
//End Initialize Objects

//Initialize HTML Template @1-52F9C312
$CCSEventResult = CCGetEvent($CCSEvents, "OnInitializeView", $MainPage);
$Tpl = new clsTemplate($FileEncoding, $TemplateEncoding);
$Tpl->LoadTemplate(PathToCurrentPage . $TemplateFileName, $BlockToParse, "CP1252");
$Tpl->block_path = "/$BlockToParse";
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeShow", $MainPage);
$Attributes->SetValue("pathToRoot", "../");
$Attributes->Show();
//End Initialize HTML Template

//Execute Components @1-A7AA8844
$mst_vehicle->Operation();
//End Execute Components

//Go to destination page @1-76341435
if($Redirect)
{
    $CCSEventResult = CCGetEvent($CCSEvents, "BeforeUnload", $MainPage);
    $DBConnection1->close();
    header("Location: " . $Redirect);
    unset($mst_vehicle);
    unset($Tpl);
    exit;
}
//End Go to destination page

//Show Page @1-B5F49E0C
$mst_vehicle->Show();
$Tpl->block_path = "";
$Tpl->Parse($BlockToParse, false);
if (!isset($main_block)) $main_block = $Tpl->GetVar($BlockToParse);
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeOutput", $MainPage);
if ($CCSEventResult) echo $main_block;
//End Show Page

//Unload Page @1-11DBD7A3
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeUnload", $MainPage);
$DBConnection1->close();
unset($mst_vehicle);
unset($Tpl);
//End Unload Page


?>
