<?php
//Include Common Files @1-A06B70E2
define("RelativePath", "..");
define("PathToCurrentPage", "/clix_modal/");
define("FileName", "modal_mst_vehicle_add_edit.php");
include_once(RelativePath . "/Common.php");
include_once(RelativePath . "/Template.php");
include_once(RelativePath . "/Sorter.php");
include_once(RelativePath . "/Navigator.php");
//End Include Common Files

class clsRecordmst_vehicle { //mst_vehicle Class @2-2CD35D04

//Variables @2-9E315808

    // Public variables
    public $ComponentType = "Record";
    public $ComponentName;
    public $Parent;
    public $HTMLFormAction;
    public $PressedButton;
    public $Errors;
    public $ErrorBlock;
    public $FormSubmitted;
    public $FormEnctype;
    public $Visible;
    public $IsEmpty;

    public $CCSEvents = "";
    public $CCSEventResult;

    public $RelativePath = "";

    public $InsertAllowed = false;
    public $UpdateAllowed = false;
    public $DeleteAllowed = false;
    public $ReadAllowed   = false;
    public $EditMode      = false;
    public $ds;
    public $DataSource;
    public $ValidatingControls;
    public $Controls;
    public $Attributes;

    // Class variables
//End Variables

//Class_Initialize Event @2-B0D335F8
    function clsRecordmst_vehicle($RelativePath, & $Parent)
    {

        global $FileName;
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->Visible = true;
        $this->Parent = & $Parent;
        $this->RelativePath = $RelativePath;
        $this->Errors = new clsErrors();
        $this->ErrorBlock = "Record mst_vehicle/Error";
        $this->DataSource = new clsmst_vehicleDataSource($this);
        $this->ds = & $this->DataSource;
        $this->InsertAllowed = true;
        $this->UpdateAllowed = true;
        $this->ReadAllowed = true;
        if($this->Visible)
        {
            $this->ComponentName = "mst_vehicle";
            $this->Attributes = new clsAttributes($this->ComponentName . ":");
            $CCSForm = explode(":", CCGetFromGet("ccsForm", ""), 2);
            if(sizeof($CCSForm) == 1)
                $CCSForm[1] = "";
            list($FormName, $FormMethod) = $CCSForm;
            $this->EditMode = ($FormMethod == "Edit");
            $this->FormEnctype = "application/x-www-form-urlencoded";
            $this->FormSubmitted = ($FormName == $this->ComponentName);
            $Method = $this->FormSubmitted ? ccsPost : ccsGet;
            $this->v_id = new clsControl(ccsHidden, "v_id", "V Id", ccsInteger, "", CCGetRequestParam("v_id", $Method, NULL), $this);
            $this->mod_v_from = new clsControl(ccsListBox, "mod_v_from", "From", ccsInteger, "", CCGetRequestParam("mod_v_from", $Method, NULL), $this);
            $this->mod_v_from->HTML = true;
            $this->mod_v_no = new clsControl(ccsTextBox, "mod_v_no", "Vehicle No", ccsText, "", CCGetRequestParam("mod_v_no", $Method, NULL), $this);
            $this->mod_v_capacity = new clsControl(ccsTextBox, "mod_v_capacity", "Capacity", ccsInteger, "", CCGetRequestParam("mod_v_capacity", $Method, NULL), $this);
            $this->mod_v_length = new clsControl(ccsTextBox, "mod_v_length", "Length", ccsInteger, "", CCGetRequestParam("mod_v_length", $Method, NULL), $this);
            $this->mod_v_type_id = new clsControl(ccsListBox, "mod_v_type_id", "From", ccsInteger, "", CCGetRequestParam("mod_v_type_id", $Method, NULL), $this);
            $this->mod_v_type_id->HTML = true;
            $this->mod_v_chassis_no = new clsControl(ccsTextBox, "mod_v_chassis_no", "Chassis No", ccsText, "", CCGetRequestParam("mod_v_chassis_no", $Method, NULL), $this);
            $this->mod_v_registration_date = new clsControl(ccsTextBox, "mod_v_registration_date", "Registration Date", ccsDate, array("dd", "/", "mm", "/", "yyyy"), CCGetRequestParam("mod_v_registration_date", $Method, NULL), $this);
            $this->mod_v_insurance_exp_date = new clsControl(ccsTextBox, "mod_v_insurance_exp_date", "Insurance Exp Date", ccsDate, array("dd", "/", "mm", "/", "yyyy"), CCGetRequestParam("mod_v_insurance_exp_date", $Method, NULL), $this);
            $this->mod_v_fitness_exp_date = new clsControl(ccsTextBox, "mod_v_fitness_exp_date", "Fitness Exp Date", ccsDate, array("dd", "/", "mm", "/", "yyyy"), CCGetRequestParam("mod_v_fitness_exp_date", $Method, NULL), $this);
        }
    }
//End Class_Initialize Event

//Initialize Method @2-EE8164CC
    function Initialize()
    {

        if(!$this->Visible)
            return;

        $this->DataSource->Parameters["sescompany_code"] = CCGetSession("company_code", NULL);
        $this->DataSource->Parameters["urlv"] = CCGetFromGet("v", NULL);
    }
//End Initialize Method

//Validate Method @2-1A3A8551
    function Validate()
    {
        global $CCSLocales;
        $Validation = true;
        $Where = "";
        $Validation = ($this->v_id->Validate() && $Validation);
        $Validation = ($this->mod_v_from->Validate() && $Validation);
        $Validation = ($this->mod_v_no->Validate() && $Validation);
        $Validation = ($this->mod_v_capacity->Validate() && $Validation);
        $Validation = ($this->mod_v_length->Validate() && $Validation);
        $Validation = ($this->mod_v_type_id->Validate() && $Validation);
        $Validation = ($this->mod_v_chassis_no->Validate() && $Validation);
        $Validation = ($this->mod_v_registration_date->Validate() && $Validation);
        $Validation = ($this->mod_v_insurance_exp_date->Validate() && $Validation);
        $Validation = ($this->mod_v_fitness_exp_date->Validate() && $Validation);
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "OnValidate", $this);
        $Validation =  $Validation && ($this->v_id->Errors->Count() == 0);
        $Validation =  $Validation && ($this->mod_v_from->Errors->Count() == 0);
        $Validation =  $Validation && ($this->mod_v_no->Errors->Count() == 0);
        $Validation =  $Validation && ($this->mod_v_capacity->Errors->Count() == 0);
        $Validation =  $Validation && ($this->mod_v_length->Errors->Count() == 0);
        $Validation =  $Validation && ($this->mod_v_type_id->Errors->Count() == 0);
        $Validation =  $Validation && ($this->mod_v_chassis_no->Errors->Count() == 0);
        $Validation =  $Validation && ($this->mod_v_registration_date->Errors->Count() == 0);
        $Validation =  $Validation && ($this->mod_v_insurance_exp_date->Errors->Count() == 0);
        $Validation =  $Validation && ($this->mod_v_fitness_exp_date->Errors->Count() == 0);
        return (($this->Errors->Count() == 0) && $Validation);
    }
//End Validate Method

//CheckErrors Method @2-09581B1E
    function CheckErrors()
    {
        $errors = false;
        $errors = ($errors || $this->v_id->Errors->Count());
        $errors = ($errors || $this->mod_v_from->Errors->Count());
        $errors = ($errors || $this->mod_v_no->Errors->Count());
        $errors = ($errors || $this->mod_v_capacity->Errors->Count());
        $errors = ($errors || $this->mod_v_length->Errors->Count());
        $errors = ($errors || $this->mod_v_type_id->Errors->Count());
        $errors = ($errors || $this->mod_v_chassis_no->Errors->Count());
        $errors = ($errors || $this->mod_v_registration_date->Errors->Count());
        $errors = ($errors || $this->mod_v_insurance_exp_date->Errors->Count());
        $errors = ($errors || $this->mod_v_fitness_exp_date->Errors->Count());
        $errors = ($errors || $this->Errors->Count());
        $errors = ($errors || $this->DataSource->Errors->Count());
        return $errors;
    }
//End CheckErrors Method

//MasterDetail @2-ED598703
function SetPrimaryKeys($keyArray)
{
    $this->PrimaryKeys = $keyArray;
}
function GetPrimaryKeys()
{
    return $this->PrimaryKeys;
}
function GetPrimaryKey($keyName)
{
    return $this->PrimaryKeys[$keyName];
}
//End MasterDetail

//Operation Method @2-17DC9883
    function Operation()
    {
        if(!$this->Visible)
            return;

        global $Redirect;
        global $FileName;

        $this->DataSource->Prepare();
        if(!$this->FormSubmitted) {
            $this->EditMode = $this->DataSource->AllParametersSet;
            return;
        }

        $Redirect = $FileName . "?" . CCGetQueryString("QueryString", array("ccsForm"));
        if ($Redirect)
            $this->DataSource->close();
    }
//End Operation Method

//InsertRow Method @2-CE1728E8
    function InsertRow()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeInsert", $this);
        if(!$this->InsertAllowed) return false;
        $this->DataSource->v_id->SetValue($this->v_id->GetValue(true));
        $this->DataSource->mod_v_from->SetValue($this->mod_v_from->GetValue(true));
        $this->DataSource->mod_v_no->SetValue($this->mod_v_no->GetValue(true));
        $this->DataSource->mod_v_capacity->SetValue($this->mod_v_capacity->GetValue(true));
        $this->DataSource->mod_v_length->SetValue($this->mod_v_length->GetValue(true));
        $this->DataSource->mod_v_type_id->SetValue($this->mod_v_type_id->GetValue(true));
        $this->DataSource->mod_v_chassis_no->SetValue($this->mod_v_chassis_no->GetValue(true));
        $this->DataSource->mod_v_registration_date->SetValue($this->mod_v_registration_date->GetValue(true));
        $this->DataSource->mod_v_insurance_exp_date->SetValue($this->mod_v_insurance_exp_date->GetValue(true));
        $this->DataSource->mod_v_fitness_exp_date->SetValue($this->mod_v_fitness_exp_date->GetValue(true));
        $this->DataSource->Insert();
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterInsert", $this);
        return (!$this->CheckErrors());
    }
//End InsertRow Method

//UpdateRow Method @2-A009F460
    function UpdateRow()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeUpdate", $this);
        if(!$this->UpdateAllowed) return false;
        $this->DataSource->v_id->SetValue($this->v_id->GetValue(true));
        $this->DataSource->mod_v_from->SetValue($this->mod_v_from->GetValue(true));
        $this->DataSource->mod_v_no->SetValue($this->mod_v_no->GetValue(true));
        $this->DataSource->mod_v_capacity->SetValue($this->mod_v_capacity->GetValue(true));
        $this->DataSource->mod_v_length->SetValue($this->mod_v_length->GetValue(true));
        $this->DataSource->mod_v_type_id->SetValue($this->mod_v_type_id->GetValue(true));
        $this->DataSource->mod_v_chassis_no->SetValue($this->mod_v_chassis_no->GetValue(true));
        $this->DataSource->mod_v_registration_date->SetValue($this->mod_v_registration_date->GetValue(true));
        $this->DataSource->mod_v_insurance_exp_date->SetValue($this->mod_v_insurance_exp_date->GetValue(true));
        $this->DataSource->mod_v_fitness_exp_date->SetValue($this->mod_v_fitness_exp_date->GetValue(true));
        $this->DataSource->Update();
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterUpdate", $this);
        return (!$this->CheckErrors());
    }
//End UpdateRow Method

//Show Method @2-A22EEA2A
    function Show()
    {
        global $CCSUseAmp;
        global $Tpl;
        global $FileName;
        global $CCSLocales;
        $Error = "";

        if(!$this->Visible)
            return;

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeSelect", $this);

        $this->mod_v_from->Prepare();
        $this->mod_v_type_id->Prepare();

        $RecordBlock = "Record " . $this->ComponentName;
        $ParentPath = $Tpl->block_path;
        $Tpl->block_path = $ParentPath . "/" . $RecordBlock;
        $this->EditMode = $this->EditMode && $this->ReadAllowed;
        if($this->EditMode) {
            if($this->DataSource->Errors->Count()){
                $this->Errors->AddErrors($this->DataSource->Errors);
                $this->DataSource->Errors->clear();
            }
            $this->DataSource->Open();
            if($this->DataSource->Errors->Count() == 0 && $this->DataSource->next_record()) {
                $this->DataSource->SetValues();
                if(!$this->FormSubmitted){
                    $this->v_id->SetValue($this->DataSource->v_id->GetValue());
                    $this->mod_v_from->SetValue($this->DataSource->mod_v_from->GetValue());
                    $this->mod_v_no->SetValue($this->DataSource->mod_v_no->GetValue());
                    $this->mod_v_capacity->SetValue($this->DataSource->mod_v_capacity->GetValue());
                    $this->mod_v_length->SetValue($this->DataSource->mod_v_length->GetValue());
                    $this->mod_v_type_id->SetValue($this->DataSource->mod_v_type_id->GetValue());
                    $this->mod_v_chassis_no->SetValue($this->DataSource->mod_v_chassis_no->GetValue());
                    $this->mod_v_registration_date->SetValue($this->DataSource->mod_v_registration_date->GetValue());
                    $this->mod_v_insurance_exp_date->SetValue($this->DataSource->mod_v_insurance_exp_date->GetValue());
                    $this->mod_v_fitness_exp_date->SetValue($this->DataSource->mod_v_fitness_exp_date->GetValue());
                }
            } else {
                $this->EditMode = false;
            }
        }

        if($this->FormSubmitted || $this->CheckErrors()) {
            $Error = "";
            $Error = ComposeStrings($Error, $this->v_id->Errors->ToString());
            $Error = ComposeStrings($Error, $this->mod_v_from->Errors->ToString());
            $Error = ComposeStrings($Error, $this->mod_v_no->Errors->ToString());
            $Error = ComposeStrings($Error, $this->mod_v_capacity->Errors->ToString());
            $Error = ComposeStrings($Error, $this->mod_v_length->Errors->ToString());
            $Error = ComposeStrings($Error, $this->mod_v_type_id->Errors->ToString());
            $Error = ComposeStrings($Error, $this->mod_v_chassis_no->Errors->ToString());
            $Error = ComposeStrings($Error, $this->mod_v_registration_date->Errors->ToString());
            $Error = ComposeStrings($Error, $this->mod_v_insurance_exp_date->Errors->ToString());
            $Error = ComposeStrings($Error, $this->mod_v_fitness_exp_date->Errors->ToString());
            $Error = ComposeStrings($Error, $this->Errors->ToString());
            $Error = ComposeStrings($Error, $this->DataSource->Errors->ToString());
            $Tpl->SetVar("Error", $Error);
            $Tpl->Parse("Error", false);
        }
        $CCSForm = $this->EditMode ? $this->ComponentName . ":" . "Edit" : $this->ComponentName;
        $this->HTMLFormAction = $FileName . "?" . CCAddParam(CCGetQueryString("QueryString", ""), "ccsForm", $CCSForm);
        $Tpl->SetVar("Action", !$CCSUseAmp ? $this->HTMLFormAction : str_replace("&", "&amp;", $this->HTMLFormAction));
        $Tpl->SetVar("HTMLFormName", $this->ComponentName);
        $Tpl->SetVar("HTMLFormEnctype", $this->FormEnctype);

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShow", $this);
        $this->Attributes->Show();
        if(!$this->Visible) {
            $Tpl->block_path = $ParentPath;
            return;
        }

        $this->v_id->Show();
        $this->mod_v_from->Show();
        $this->mod_v_no->Show();
        $this->mod_v_capacity->Show();
        $this->mod_v_length->Show();
        $this->mod_v_type_id->Show();
        $this->mod_v_chassis_no->Show();
        $this->mod_v_registration_date->Show();
        $this->mod_v_insurance_exp_date->Show();
        $this->mod_v_fitness_exp_date->Show();
        $Tpl->parse();
        $Tpl->block_path = $ParentPath;
        $this->DataSource->close();
    }
//End Show Method

} //End mst_vehicle Class @2-FCB6E20C

class clsmst_vehicleDataSource extends clsDBConnection1 {  //mst_vehicleDataSource Class @2-17585DC6

//DataSource Variables @2-A4B68DAF
    public $Parent = "";
    public $CCSEvents = "";
    public $CCSEventResult;
    public $ErrorBlock;
    public $CmdExecution;

    public $InsertParameters;
    public $UpdateParameters;
    public $wp;
    public $AllParametersSet;

    public $InsertFields = array();
    public $UpdateFields = array();

    // Datasource fields
    public $v_id;
    public $mod_v_from;
    public $mod_v_no;
    public $mod_v_capacity;
    public $mod_v_length;
    public $mod_v_type_id;
    public $mod_v_chassis_no;
    public $mod_v_registration_date;
    public $mod_v_insurance_exp_date;
    public $mod_v_fitness_exp_date;
//End DataSource Variables

//DataSourceClass_Initialize Event @2-034E7D72
    function clsmst_vehicleDataSource(& $Parent)
    {
        $this->Parent = & $Parent;
        $this->ErrorBlock = "Record mst_vehicle/Error";
        $this->Initialize();
        $this->v_id = new clsField("v_id", ccsInteger, "");
        
        $this->mod_v_from = new clsField("mod_v_from", ccsInteger, "");
        
        $this->mod_v_no = new clsField("mod_v_no", ccsText, "");
        
        $this->mod_v_capacity = new clsField("mod_v_capacity", ccsInteger, "");
        
        $this->mod_v_length = new clsField("mod_v_length", ccsInteger, "");
        
        $this->mod_v_type_id = new clsField("mod_v_type_id", ccsInteger, "");
        
        $this->mod_v_chassis_no = new clsField("mod_v_chassis_no", ccsText, "");
        
        $this->mod_v_registration_date = new clsField("mod_v_registration_date", ccsDate, array("yyyy", "-", "mm", "-", "dd", " ", "HH", ":", "nn", ":", "ss"));
        
        $this->mod_v_insurance_exp_date = new clsField("mod_v_insurance_exp_date", ccsDate, array("yyyy", "-", "mm", "-", "dd", " ", "HH", ":", "nn", ":", "ss"));
        
        $this->mod_v_fitness_exp_date = new clsField("mod_v_fitness_exp_date", ccsDate, array("yyyy", "-", "mm", "-", "dd", " ", "HH", ":", "nn", ":", "ss"));
        

        $this->InsertFields["v_id"] = array("Name" => "v_id", "Value" => "", "DataType" => ccsInteger, "OmitIfEmpty" => 1);
        $this->InsertFields["v_from"] = array("Name" => "v_from", "Value" => "", "DataType" => ccsInteger, "OmitIfEmpty" => 1);
        $this->InsertFields["v_no"] = array("Name" => "v_no", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->InsertFields["v_capacity"] = array("Name" => "v_capacity", "Value" => "", "DataType" => ccsInteger, "OmitIfEmpty" => 1);
        $this->InsertFields["v_length"] = array("Name" => "v_length", "Value" => "", "DataType" => ccsInteger, "OmitIfEmpty" => 1);
        $this->InsertFields["v_type_id"] = array("Name" => "v_type_id", "Value" => "", "DataType" => ccsInteger, "OmitIfEmpty" => 1);
        $this->InsertFields["v_chassis_no"] = array("Name" => "v_chassis_no", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->InsertFields["v_registration_date"] = array("Name" => "v_registration_date", "Value" => "", "DataType" => ccsDate, "OmitIfEmpty" => 1);
        $this->InsertFields["v_insurance_exp_date"] = array("Name" => "v_insurance_exp_date", "Value" => "", "DataType" => ccsDate, "OmitIfEmpty" => 1);
        $this->InsertFields["v_fitness_exp_date"] = array("Name" => "v_fitness_exp_date", "Value" => "", "DataType" => ccsDate, "OmitIfEmpty" => 1);
        $this->UpdateFields["v_id"] = array("Name" => "v_id", "Value" => "", "DataType" => ccsInteger, "OmitIfEmpty" => 1);
        $this->UpdateFields["v_from"] = array("Name" => "v_from", "Value" => "", "DataType" => ccsInteger, "OmitIfEmpty" => 1);
        $this->UpdateFields["v_no"] = array("Name" => "v_no", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->UpdateFields["v_capacity"] = array("Name" => "v_capacity", "Value" => "", "DataType" => ccsInteger, "OmitIfEmpty" => 1);
        $this->UpdateFields["v_length"] = array("Name" => "v_length", "Value" => "", "DataType" => ccsInteger, "OmitIfEmpty" => 1);
        $this->UpdateFields["v_type_id"] = array("Name" => "v_type_id", "Value" => "", "DataType" => ccsInteger, "OmitIfEmpty" => 1);
        $this->UpdateFields["v_chassis_no"] = array("Name" => "v_chassis_no", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->UpdateFields["v_registration_date"] = array("Name" => "v_registration_date", "Value" => "", "DataType" => ccsDate, "OmitIfEmpty" => 1);
        $this->UpdateFields["v_insurance_exp_date"] = array("Name" => "v_insurance_exp_date", "Value" => "", "DataType" => ccsDate, "OmitIfEmpty" => 1);
        $this->UpdateFields["v_fitness_exp_date"] = array("Name" => "v_fitness_exp_date", "Value" => "", "DataType" => ccsDate, "OmitIfEmpty" => 1);
    }
//End DataSourceClass_Initialize Event

//Prepare Method @2-86F22165
    function Prepare()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->wp = new clsSQLParameters($this->ErrorBlock);
        $this->wp->AddParameter("1", "sescompany_code", ccsInteger, "", "", $this->Parameters["sescompany_code"], -1, false);
        $this->wp->AddParameter("2", "urlv", ccsInteger, "", "", $this->Parameters["urlv"], "", false);
        $this->AllParametersSet = $this->wp->AllParamsSet();
        $this->wp->Criterion[1] = $this->wp->Operation(opEqual, "prefix_company_code", $this->wp->GetDBValue("1"), $this->ToSQL($this->wp->GetDBValue("1"), ccsInteger),false);
        $this->wp->Criterion[2] = $this->wp->Operation(opEqual, "v_id", $this->wp->GetDBValue("2"), $this->ToSQL($this->wp->GetDBValue("2"), ccsInteger),false);
        $this->Where = $this->wp->opAND(
             false, 
             $this->wp->Criterion[1], 
             $this->wp->Criterion[2]);
    }
//End Prepare Method

//Open Method @2-994B28DD
    function Open()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildSelect", $this->Parent);
        $this->SQL = "SELECT * \n\n" .
        "FROM mst_vehicle {SQL_Where} {SQL_OrderBy}";
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteSelect", $this->Parent);
        $this->PageSize = 1;
        $this->query($this->OptimizeSQL(CCBuildSQL($this->SQL, $this->Where, $this->Order)));
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteSelect", $this->Parent);
    }
//End Open Method

//SetValues Method @2-F007EFA8
    function SetValues()
    {
        $this->v_id->SetDBValue(trim($this->f("v_id")));
        $this->mod_v_from->SetDBValue(trim($this->f("v_from")));
        $this->mod_v_no->SetDBValue($this->f("v_no"));
        $this->mod_v_capacity->SetDBValue(trim($this->f("v_capacity")));
        $this->mod_v_length->SetDBValue(trim($this->f("v_length")));
        $this->mod_v_type_id->SetDBValue(trim($this->f("v_type_id")));
        $this->mod_v_chassis_no->SetDBValue($this->f("v_chassis_no"));
        $this->mod_v_registration_date->SetDBValue(trim($this->f("v_registration_date")));
        $this->mod_v_insurance_exp_date->SetDBValue(trim($this->f("v_insurance_exp_date")));
        $this->mod_v_fitness_exp_date->SetDBValue(trim($this->f("v_fitness_exp_date")));
    }
//End SetValues Method

//Insert Method @2-3B3D1856
    function Insert()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->CmdExecution = true;
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildInsert", $this->Parent);
        $this->InsertFields["v_id"]["Value"] = $this->v_id->GetDBValue(true);
        $this->InsertFields["v_from"]["Value"] = $this->mod_v_from->GetDBValue(true);
        $this->InsertFields["v_no"]["Value"] = $this->mod_v_no->GetDBValue(true);
        $this->InsertFields["v_capacity"]["Value"] = $this->mod_v_capacity->GetDBValue(true);
        $this->InsertFields["v_length"]["Value"] = $this->mod_v_length->GetDBValue(true);
        $this->InsertFields["v_type_id"]["Value"] = $this->mod_v_type_id->GetDBValue(true);
        $this->InsertFields["v_chassis_no"]["Value"] = $this->mod_v_chassis_no->GetDBValue(true);
        $this->InsertFields["v_registration_date"]["Value"] = $this->mod_v_registration_date->GetDBValue(true);
        $this->InsertFields["v_insurance_exp_date"]["Value"] = $this->mod_v_insurance_exp_date->GetDBValue(true);
        $this->InsertFields["v_fitness_exp_date"]["Value"] = $this->mod_v_fitness_exp_date->GetDBValue(true);
        $this->SQL = CCBuildInsert("mst_vehicle", $this->InsertFields, $this);
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteInsert", $this->Parent);
        if($this->Errors->Count() == 0 && $this->CmdExecution) {
            $this->query($this->SQL);
            $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteInsert", $this->Parent);
        }
    }
//End Insert Method

//Update Method @2-990F7D61
    function Update()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->CmdExecution = true;
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildUpdate", $this->Parent);
        $this->UpdateFields["v_id"]["Value"] = $this->v_id->GetDBValue(true);
        $this->UpdateFields["v_from"]["Value"] = $this->mod_v_from->GetDBValue(true);
        $this->UpdateFields["v_no"]["Value"] = $this->mod_v_no->GetDBValue(true);
        $this->UpdateFields["v_capacity"]["Value"] = $this->mod_v_capacity->GetDBValue(true);
        $this->UpdateFields["v_length"]["Value"] = $this->mod_v_length->GetDBValue(true);
        $this->UpdateFields["v_type_id"]["Value"] = $this->mod_v_type_id->GetDBValue(true);
        $this->UpdateFields["v_chassis_no"]["Value"] = $this->mod_v_chassis_no->GetDBValue(true);
        $this->UpdateFields["v_registration_date"]["Value"] = $this->mod_v_registration_date->GetDBValue(true);
        $this->UpdateFields["v_insurance_exp_date"]["Value"] = $this->mod_v_insurance_exp_date->GetDBValue(true);
        $this->UpdateFields["v_fitness_exp_date"]["Value"] = $this->mod_v_fitness_exp_date->GetDBValue(true);
        $this->SQL = CCBuildUpdate("mst_vehicle", $this->UpdateFields, $this);
        $this->SQL .= strlen($this->Where) ? " WHERE " . $this->Where : $this->Where;
        if (!strlen($this->Where) && $this->Errors->Count() == 0) 
            $this->Errors->addError($CCSLocales->GetText("CCS_CustomOperationError_MissingParameters"));
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteUpdate", $this->Parent);
        if($this->Errors->Count() == 0 && $this->CmdExecution) {
            $this->query($this->SQL);
            $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteUpdate", $this->Parent);
        }
    }
//End Update Method

} //End mst_vehicleDataSource Class @2-FCB6E20C

//Initialize Page @1-3F177E08
// Variables
$FileName = "";
$Redirect = "";
$Tpl = "";
$TemplateFileName = "";
$BlockToParse = "";
$ComponentName = "";
$Attributes = "";

// Events;
$CCSEvents = "";
$CCSEventResult = "";

$FileName = FileName;
$Redirect = "";
$TemplateFileName = "modal_mst_vehicle_add_edit.html";
$BlockToParse = "main";
$TemplateEncoding = "CP1252";
$ContentType = "text/html";
$PathToRoot = "../";
//End Initialize Page

//Include events file @1-88577F37
include_once("./modal_mst_vehicle_add_edit_events.php");
//End Include events file

//Before Initialize @1-E870CEBC
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeInitialize", $MainPage);
//End Before Initialize

//Initialize Objects @1-CCBBC548
$DBConnection1 = new clsDBConnection1();
$MainPage->Connections["Connection1"] = & $DBConnection1;
$Attributes = new clsAttributes("page:");
$MainPage->Attributes = & $Attributes;

// Controls
$mst_vehicle = new clsRecordmst_vehicle("", $MainPage);
$MainPage->mst_vehicle = & $mst_vehicle;
$mst_vehicle->Initialize();

BindEvents();

$CCSEventResult = CCGetEvent($CCSEvents, "AfterInitialize", $MainPage);

if ($Charset) {
    header("Content-Type: " . $ContentType . "; charset=" . $Charset);
} else {
    header("Content-Type: " . $ContentType);
}
//End Initialize Objects

//Initialize HTML Template @1-52F9C312
$CCSEventResult = CCGetEvent($CCSEvents, "OnInitializeView", $MainPage);
$Tpl = new clsTemplate($FileEncoding, $TemplateEncoding);
$Tpl->LoadTemplate(PathToCurrentPage . $TemplateFileName, $BlockToParse, "CP1252");
$Tpl->block_path = "/$BlockToParse";
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeShow", $MainPage);
$Attributes->SetValue("pathToRoot", "../");
$Attributes->Show();
//End Initialize HTML Template

//Execute Components @1-A7AA8844
$mst_vehicle->Operation();
//End Execute Components

//Go to destination page @1-76341435
if($Redirect)
{
    $CCSEventResult = CCGetEvent($CCSEvents, "BeforeUnload", $MainPage);
    $DBConnection1->close();
    header("Location: " . $Redirect);
    unset($mst_vehicle);
    unset($Tpl);
    exit;
}
//End Go to destination page

//Show Page @1-B5F49E0C
$mst_vehicle->Show();
$Tpl->block_path = "";
$Tpl->Parse($BlockToParse, false);
if (!isset($main_block)) $main_block = $Tpl->GetVar($BlockToParse);
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeOutput", $MainPage);
if ($CCSEventResult) echo $main_block;
//End Show Page

//Unload Page @1-11DBD7A3
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeUnload", $MainPage);
$DBConnection1->close();
unset($mst_vehicle);
unset($Tpl);
//End Unload Page


?>
