<?php
//Include Common Files @1-17BE4C6F
define("RelativePath", ".");
define("PathToCurrentPage", "/");
define("FileName", "events_tran.php");
include_once(RelativePath . "/Common.php");
include_once(RelativePath . "/Template.php");
include_once(RelativePath . "/Sorter.php");
include_once(RelativePath . "/Navigator.php");
//End Include Common Files

//Include Page implementation @2-1B12872F
include_once(RelativePath . "/incl_ClixTop.php");
//End Include Page implementation



//Include Page implementation @24-16DCDEFB
include_once(RelativePath . "/incl_footer.php");
//End Include Page implementation

//Include Page implementation @26-B92CD63A
include_once(RelativePath . "/incl_sidebar.php");
//End Include Page implementation

class clsGridclix_list { //clix_list class @27-9A031AD4

//Variables @27-A3895FD7

    // Public variables
    var $ComponentType = "Grid";
    var $ComponentName;
    var $Visible;
    var $Errors;
    var $ErrorBlock;
    var $ds;
    var $DataSource;
    var $PageSize;
    var $IsEmpty;
    var $ForceIteration = false;
    var $HasRecord = false;
    var $SorterName = "";
    var $SorterDirection = "";
    var $PageNumber;
    var $RowNumber;
    var $ControlsVisible = array();

    var $CCSEvents = "";
    var $CCSEventResult;

    var $RelativePath = "";
    var $Attributes;

    // Grid Controls
    var $StaticControls;
    var $RowControls;
    var $Sorter_date_start;
//End Variables

//Class_Initialize Event @27-787F5DE4
    function clsGridclix_list($RelativePath, & $Parent)
    {
        global $FileName;
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->ComponentName = "clix_list";
        $this->Visible = True;
        $this->Parent = & $Parent;
        $this->RelativePath = $RelativePath;
        $this->Errors = new clsErrors();
        $this->ErrorBlock = "Grid clix_list";
        $this->Attributes = new clsAttributes($this->ComponentName . ":");
        $this->DataSource = new clsclix_listDataSource($this);
        $this->ds = & $this->DataSource;
        $this->PageSize = CCGetParam($this->ComponentName . "PageSize", "");
        if(!is_numeric($this->PageSize) || !strlen($this->PageSize))
            $this->PageSize = 20;
        else
            $this->PageSize = intval($this->PageSize);
        if ($this->PageSize > 100)
            $this->PageSize = 100;
        if($this->PageSize == 0)
            $this->Errors->addError("<p>Form: Grid " . $this->ComponentName . "<br>Error: (CCS06) Invalid page size.</p>");
        $this->PageNumber = intval(CCGetParam($this->ComponentName . "Page", 1));
        if ($this->PageNumber <= 0) $this->PageNumber = 1;
        $this->SorterName = CCGetParam("clix_listOrder", "");
        $this->SorterDirection = CCGetParam("clix_listDir", "");

        $this->date_start = & new clsControl(ccsLabel, "date_start", "date_start", ccsDate, array("dd", "-", "mm", "-", "yyyy", " ", "h", ":", "nn", " ", "AM/PM"), CCGetRequestParam("date_start", ccsGet, NULL), $this);
        $this->ImageLink1 = & new clsControl(ccsImageLink, "ImageLink1", "ImageLink1", ccsText, "", CCGetRequestParam("ImageLink1", ccsGet, NULL), $this);
        $this->ImageLink1->Page = "events_tran.php";
        $this->ImageLink2 = & new clsControl(ccsImageLink, "ImageLink2", "ImageLink2", ccsText, "", CCGetRequestParam("ImageLink2", ccsGet, NULL), $this);
        $this->ImageLink2->Parameters = CCGetQueryString("QueryString", array("n~", "d~", "e~", "ccsForm"));
        $this->ImageLink2->Page = "#";
        $this->thisname = & new clsControl(ccsHidden, "thisname", "thisname", ccsDate, array("dd", "-", "mm", "-", "yyyy", " ", "h", ":", "nn", " ", "AM/PM"), CCGetRequestParam("thisname", ccsGet, NULL), $this);
        $this->thisid = & new clsControl(ccsHidden, "thisid", "thisid", ccsText, "", CCGetRequestParam("thisid", ccsGet, NULL), $this);
        $this->date_end = & new clsControl(ccsLabel, "date_end", "date_end", ccsDate, array("dd", "-", "mm", "-", "yyyy", " ", "h", ":", "nn", " ", "AM/PM"), CCGetRequestParam("date_end", ccsGet, NULL), $this);
        $this->item_id = & new clsControl(ccsHidden, "item_id", "item_id", ccsText, "", CCGetRequestParam("item_id", ccsGet, NULL), $this);
        $this->ticket_open = & new clsControl(ccsLabel, "ticket_open", "ticket_open", ccsText, "", CCGetRequestParam("ticket_open", ccsGet, NULL), $this);
        $this->h_s = & new clsControl(ccsLabel, "h_s", "h_s", ccsText, "", CCGetRequestParam("h_s", ccsGet, NULL), $this);
        $this->Sorter_date_start = & new clsSorter($this->ComponentName, "Sorter_date_start", $FileName, $this);
        $this->Navigator = & new clsNavigator($this->ComponentName, "Navigator", $FileName, 10, tpSimple, $this);
        $this->Navigator->PageSizes = array("1", "5", "10", "25", "50");
        $this->ImageLink3 = & new clsControl(ccsImageLink, "ImageLink3", "ImageLink3", ccsText, "", CCGetRequestParam("ImageLink3", ccsGet, NULL), $this);
        $this->ImageLink3->Page = "events_tran.php";
        $this->caption = & new clsControl(ccsLabel, "caption", "caption", ccsText, "", CCGetRequestParam("caption", ccsGet, NULL), $this);
        $this->caption->HTML = true;
        $this->Link1 = & new clsControl(ccsLink, "Link1", "Link1", ccsText, "", CCGetRequestParam("Link1", ccsGet, NULL), $this);
        $this->Link1->Parameters = CCGetQueryString("QueryString", array("n~", "d~", "e~", "s", "ccsForm"));
        $this->Link1->Page = "events_tran.php";
    }
//End Class_Initialize Event

//Initialize Method @27-90E704C5
    function Initialize()
    {
        if(!$this->Visible) return;

        $this->DataSource->PageSize = & $this->PageSize;
        $this->DataSource->AbsolutePage = & $this->PageNumber;
        $this->DataSource->SetOrder($this->SorterName, $this->SorterDirection);
    }
//End Initialize Method

//Show Method @27-57107923
    function Show()
    {
        global $Tpl;
        global $CCSLocales;
        if(!$this->Visible) return;

        $this->RowNumber = 0;

        $this->DataSource->Parameters["urls"] = CCGetFromGet("s", NULL);
        $this->DataSource->Parameters["expr162"] = N;

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeSelect", $this);


        $this->DataSource->Prepare();
        $this->DataSource->Open();
        $this->HasRecord = $this->DataSource->has_next_record();
        $this->IsEmpty = ! $this->HasRecord;
        $this->Attributes->Show();

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShow", $this);
        if(!$this->Visible) return;

        $GridBlock = "Grid " . $this->ComponentName;
        $ParentPath = $Tpl->block_path;
        $Tpl->block_path = $ParentPath . "/" . $GridBlock;


        if (!$this->IsEmpty) {
            $this->ControlsVisible["date_start"] = $this->date_start->Visible;
            $this->ControlsVisible["ImageLink1"] = $this->ImageLink1->Visible;
            $this->ControlsVisible["ImageLink2"] = $this->ImageLink2->Visible;
            $this->ControlsVisible["thisname"] = $this->thisname->Visible;
            $this->ControlsVisible["thisid"] = $this->thisid->Visible;
            $this->ControlsVisible["date_end"] = $this->date_end->Visible;
            $this->ControlsVisible["item_id"] = $this->item_id->Visible;
            $this->ControlsVisible["ticket_open"] = $this->ticket_open->Visible;
            $this->ControlsVisible["h_s"] = $this->h_s->Visible;
            while ($this->ForceIteration || (($this->RowNumber < $this->PageSize) &&  ($this->HasRecord = $this->DataSource->has_next_record()))) {
                $this->RowNumber++;
                if ($this->HasRecord) {
                    $this->DataSource->next_record();
                    $this->DataSource->SetValues();
                }
                $Tpl->block_path = $ParentPath . "/" . $GridBlock . "/Row";
                $this->date_start->SetValue($this->DataSource->date_start->GetValue());
                $this->ImageLink1->Parameters = CCGetQueryString("QueryString", array("n~", "d~", "e~", "ccsForm"));
                $this->ImageLink1->Parameters = CCAddParam($this->ImageLink1->Parameters, "e~", $this->DataSource->f("event_id"));
                $this->thisname->SetValue($this->DataSource->thisname->GetValue());
                $this->thisid->SetValue($this->DataSource->thisid->GetValue());
                $this->date_end->SetValue($this->DataSource->date_end->GetValue());
                $this->item_id->SetValue($this->DataSource->item_id->GetValue());
                $this->ticket_open->SetValue($this->DataSource->ticket_open->GetValue());
                $this->h_s->SetValue($this->DataSource->h_s->GetValue());
                $this->Attributes->SetValue("rowNumber", $this->RowNumber);
                $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShowRow", $this);
                $this->Attributes->Show();
                $this->date_start->Show();
                $this->ImageLink1->Show();
                $this->ImageLink2->Show();
                $this->thisname->Show();
                $this->thisid->Show();
                $this->date_end->Show();
                $this->item_id->Show();
                $this->ticket_open->Show();
                $this->h_s->Show();
                $Tpl->block_path = $ParentPath . "/" . $GridBlock;
                $Tpl->parse("Row", true);
            }
        }
        else { // Show NoRecords block if no records are found
            $this->Attributes->Show();
            $Tpl->parse("NoRecords", false);
        }

        $errors = $this->GetErrors();
        if(strlen($errors))
        {
            $Tpl->replaceblock("", $errors);
            $Tpl->block_path = $ParentPath;
            return;
        }
        $this->Navigator->PageNumber = $this->DataSource->AbsolutePage;
        $this->Navigator->PageSize = $this->PageSize;
        if ($this->DataSource->RecordsCount == "CCS not counted")
            $this->Navigator->TotalPages = $this->DataSource->AbsolutePage + ($this->DataSource->next_record() ? 1 : 0);
        else
            $this->Navigator->TotalPages = $this->DataSource->PageCount();
        if ($this->Navigator->TotalPages <= 1) {
            $this->Navigator->Visible = false;
        }
        $this->ImageLink3->Parameters = CCGetQueryString("QueryString", array("n~", "d~", "e~", "ccsForm"));
        $this->ImageLink3->Parameters = CCAddParam($this->ImageLink3->Parameters, "n~", 1);
        $this->Sorter_date_start->Show();
        $this->Navigator->Show();
        $this->ImageLink3->Show();
        $this->caption->Show();
        $this->Link1->Show();
        $Tpl->parse();
        $Tpl->block_path = $ParentPath;
        $this->DataSource->close();
    }
//End Show Method

//GetErrors Method @27-FBE6077D
    function GetErrors()
    {
        $errors = "";
        $errors = ComposeStrings($errors, $this->date_start->Errors->ToString());
        $errors = ComposeStrings($errors, $this->ImageLink1->Errors->ToString());
        $errors = ComposeStrings($errors, $this->ImageLink2->Errors->ToString());
        $errors = ComposeStrings($errors, $this->thisname->Errors->ToString());
        $errors = ComposeStrings($errors, $this->thisid->Errors->ToString());
        $errors = ComposeStrings($errors, $this->date_end->Errors->ToString());
        $errors = ComposeStrings($errors, $this->item_id->Errors->ToString());
        $errors = ComposeStrings($errors, $this->ticket_open->Errors->ToString());
        $errors = ComposeStrings($errors, $this->h_s->Errors->ToString());
        $errors = ComposeStrings($errors, $this->Errors->ToString());
        $errors = ComposeStrings($errors, $this->DataSource->Errors->ToString());
        return $errors;
    }
//End GetErrors Method

} //End clix_list Class @27-FCB6E20C

class clsclix_listDataSource extends clsDBConnection1 {  //clix_listDataSource Class @27-E0C69A6C

//DataSource Variables @27-FAC6FEE0
    var $Parent = "";
    var $CCSEvents = "";
    var $CCSEventResult;
    var $ErrorBlock;
    var $CmdExecution;

    var $CountSQL;
    var $wp;


    // Datasource fields
    var $date_start;
    var $thisname;
    var $thisid;
    var $date_end;
    var $item_id;
    var $ticket_open;
    var $h_s;
//End DataSource Variables

//DataSourceClass_Initialize Event @27-B34B924E
    function clsclix_listDataSource(& $Parent)
    {
        $this->Parent = & $Parent;
        $this->ErrorBlock = "Grid clix_list";
        $this->Initialize();
        $this->date_start = new clsField("date_start", ccsDate, array("yyyy", "-", "mm", "-", "dd", " ", "HH", ":", "nn", ":", "ss"));
        
        $this->thisname = new clsField("thisname", ccsDate, array("yyyy", "-", "mm", "-", "dd", " ", "HH", ":", "nn", ":", "ss"));
        
        $this->thisid = new clsField("thisid", ccsText, "");
        
        $this->date_end = new clsField("date_end", ccsDate, array("yyyy", "-", "mm", "-", "dd", " ", "HH", ":", "nn", ":", "ss"));
        
        $this->item_id = new clsField("item_id", ccsText, "");
        
        $this->ticket_open = new clsField("ticket_open", ccsText, "");
        
        $this->h_s = new clsField("h_s", ccsText, "");
        

    }
//End DataSourceClass_Initialize Event

//SetOrder Method @27-C23C07B6
    function SetOrder($SorterName, $SorterDirection)
    {
        $this->Order = "date_start";
        $this->Order = CCGetOrder($this->Order, $SorterName, $SorterDirection, 
            array("Sorter_date_start" => array("date_start", "")));
    }
//End SetOrder Method

//Prepare Method @27-7B2A4467
    function Prepare()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->wp = new clsSQLParameters($this->ErrorBlock);
        $this->wp->AddParameter("1", "urls", ccsInteger, "", "", $this->Parameters["urls"], -1, false);
        $this->wp->AddParameter("2", "expr162", ccsText, "", "", $this->Parameters["expr162"], -1, false);
        $this->wp->Criterion[1] = $this->wp->Operation(opEqual, "events_mst.item_id", $this->wp->GetDBValue("1"), $this->ToSQL($this->wp->GetDBValue("1"), ccsInteger),false);
        $this->wp->Criterion[2] = $this->wp->Operation(opEqual, "events_tran.flg_archived", $this->wp->GetDBValue("2"), $this->ToSQL($this->wp->GetDBValue("2"), ccsText),false);
        $this->Where = $this->wp->opAND(
             false, 
             $this->wp->Criterion[1], 
             $this->wp->Criterion[2]);
    }
//End Prepare Method

//Open Method @27-751BA2A3
    function Open()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildSelect", $this->Parent);
        $this->CountSQL = "SELECT COUNT(*)\n\n" .
        "FROM events_tran INNER JOIN events_mst ON\n\n" .
        "events_tran.item_id = events_mst.item_id";
        $this->SQL = "SELECT item_name, flg_hide_show, date_start, date_end, events_tran.item_id AS events_tran_item_id, if(flg_hide_show='H','Hide in Panel','Show in Panel') AS h_s,\n\n" .
        "event_id, if(flg_ticket='Y','Ticket Event','Open Event') AS ticket_open \n\n" .
        "FROM events_tran INNER JOIN events_mst ON\n\n" .
        "events_tran.item_id = events_mst.item_id {SQL_Where} {SQL_OrderBy}";
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteSelect", $this->Parent);
        if ($this->CountSQL) 
            $this->RecordsCount = CCGetDBValue(CCBuildSQL($this->CountSQL, $this->Where, ""), $this);
        else
            $this->RecordsCount = "CCS not counted";
        $this->query($this->OptimizeSQL(CCBuildSQL($this->SQL, $this->Where, $this->Order)));
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteSelect", $this->Parent);
    }
//End Open Method

//SetValues Method @27-7CF8EA13
    function SetValues()
    {
        $this->date_start->SetDBValue(trim($this->f("date_start")));
        $this->thisname->SetDBValue(trim($this->f("date_start")));
        $this->thisid->SetDBValue($this->f("event_id"));
        $this->date_end->SetDBValue(trim($this->f("date_end")));
        $this->item_id->SetDBValue($this->f("events_tran_item_id"));
        $this->ticket_open->SetDBValue($this->f("ticket_open"));
        $this->h_s->SetDBValue($this->f("h_s"));
    }
//End SetValues Method

} //End clix_listDataSource Class @27-FCB6E20C

class clsRecordclix_rec { //clix_rec Class @48-E00062A6

//Variables @48-D6FF3E86

    // Public variables
    var $ComponentType = "Record";
    var $ComponentName;
    var $Parent;
    var $HTMLFormAction;
    var $PressedButton;
    var $Errors;
    var $ErrorBlock;
    var $FormSubmitted;
    var $FormEnctype;
    var $Visible;
    var $IsEmpty;

    var $CCSEvents = "";
    var $CCSEventResult;

    var $RelativePath = "";

    var $InsertAllowed = false;
    var $UpdateAllowed = false;
    var $DeleteAllowed = false;
    var $ReadAllowed   = false;
    var $EditMode      = false;
    var $ds;
    var $DataSource;
    var $ValidatingControls;
    var $Controls;
    var $Attributes;

    // Class variables
//End Variables

//Class_Initialize Event @48-F1D2FBF1
    function clsRecordclix_rec($RelativePath, & $Parent)
    {

        global $FileName;
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->Visible = true;
        $this->Parent = & $Parent;
        $this->RelativePath = $RelativePath;
        $this->Errors = new clsErrors();
        $this->ErrorBlock = "Record clix_rec/Error";
        $this->DataSource = new clsclix_recDataSource($this);
        $this->ds = & $this->DataSource;
        $this->InsertAllowed = true;
        $this->UpdateAllowed = true;
        $this->ReadAllowed = true;
        if($this->Visible)
        {
            $this->ComponentName = "clix_rec";
            $this->Attributes = new clsAttributes($this->ComponentName . ":");
            $CCSForm = explode(":", CCGetFromGet("ccsForm", ""), 2);
            if(sizeof($CCSForm) == 1)
                $CCSForm[1] = "";
            list($FormName, $FormMethod) = $CCSForm;
            $this->EditMode = ($FormMethod == "Edit");
            $this->FormEnctype = "application/x-www-form-urlencoded";
            $this->FormSubmitted = ($FormName == $this->ComponentName);
            $Method = $this->FormSubmitted ? ccsPost : ccsGet;
            $this->Button_Insert = & new clsButton("Button_Insert", $Method, $this);
            $this->Button_Update = & new clsButton("Button_Update", $Method, $this);
            $this->Button_Delete = & new clsButton("Button_Delete", $Method, $this);
            $this->Button_Cancel = & new clsButton("Button_Cancel", $Method, $this);
            $this->caption = & new clsControl(ccsLabel, "caption", "caption", ccsText, "", CCGetRequestParam("caption", $Method, NULL), $this);
            $this->caption->HTML = true;
            $this->date_start = & new clsControl(ccsTextBox, "date_start", "Start Date & Time", ccsDate, array("dd", "-", "mm", "-", "yyyy", " ", "h", ":", "nn", " ", "AM/PM"), CCGetRequestParam("date_start", $Method, NULL), $this);
            $this->date_end = & new clsControl(ccsTextBox, "date_end", "End Date & Time", ccsDate, array("dd", "-", "mm", "-", "yyyy", " ", "h", ":", "nn", " ", "AM/PM"), CCGetRequestParam("date_end", $Method, NULL), $this);
            $this->promo_code = & new clsControl(ccsTextBox, "promo_code", "Promocode", ccsText, "", CCGetRequestParam("promo_code", $Method, NULL), $this);
            $this->discount = & new clsControl(ccsTextBox, "discount", "Discount", ccsFloat, array(False, 2, Null, "", False, "", "", 1, True, ""), CCGetRequestParam("discount", $Method, NULL), $this);
            $this->disount_type = & new clsControl(ccsRadioButton, "disount_type", "Discount Type", ccsText, "", CCGetRequestParam("disount_type", $Method, NULL), $this);
            $this->disount_type->DSType = dsListOfValues;
            $this->disount_type->Values = array(array("A", "Amount"), array("P", "% age"));
            $this->disount_type->HTML = true;
            $this->expire_count = & new clsControl(ccsTextBox, "expire_count", "Max use limit (no of times)", ccsInteger, "", CCGetRequestParam("expire_count", $Method, NULL), $this);
            $this->expire_date_time = & new clsControl(ccsTextBox, "expire_date_time", "Expire Date and Ttime", ccsDate, array("dd", "-", "mm", "-", "yyyy", " ", "h", ":", "nn", " ", "AM/PM"), CCGetRequestParam("expire_date_time", $Method, NULL), $this);
            $this->ticket_series = & new clsControl(ccsTextBox, "ticket_series", "Ticket Series Code", ccsText, "", CCGetRequestParam("ticket_series", $Method, NULL), $this);
            $this->ticket_max_qty = & new clsControl(ccsTextBox, "ticket_max_qty", "Maximum Tickets Available", ccsInteger, "", CCGetRequestParam("ticket_max_qty", $Method, NULL), $this);
            $this->ticket_expiry_hrs = & new clsControl(ccsTextBox, "ticket_expiry_hrs", "Expiry XX Hours", ccsInteger, "", CCGetRequestParam("ticket_expiry_hrs", $Method, NULL), $this);
            $this->item_id = & new clsControl(ccsHidden, "item_id", "item_id", ccsInteger, "", CCGetRequestParam("item_id", $Method, NULL), $this);
            $this->flg_ticket = & new clsControl(ccsRadioButton, "flg_ticket", "Place Name", ccsText, "", CCGetRequestParam("flg_ticket", $Method, NULL), $this);
            $this->flg_ticket->DSType = dsListOfValues;
            $this->flg_ticket->Values = array(array("N", "Open Event"), array("Y", "Ticket Event"));
            $this->flg_ticket->HTML = true;
            $this->flg_ticket->Required = true;
            $this->flg_hide_show = & new clsControl(ccsRadioButton, "flg_hide_show", "flg_hide_show", ccsText, "", CCGetRequestParam("flg_hide_show", $Method, NULL), $this);
            $this->flg_hide_show->DSType = dsListOfValues;
            $this->flg_hide_show->Values = array(array("H", "Hide in Current Event Panel"), array("S", "Show in Current Event Panel"));
            $this->flg_hide_show->HTML = true;
            $this->flg_hide_show->Required = true;
            $this->date_reg_closing = & new clsControl(ccsTextBox, "date_reg_closing", "Start Date & Time", ccsDate, array("dd", "-", "mm", "-", "yyyy", " ", "h", ":", "nn", " ", "AM/PM"), CCGetRequestParam("date_reg_closing", $Method, NULL), $this);
            if(!$this->FormSubmitted) {
                if(!is_array($this->discount->Value) && !strlen($this->discount->Value) && $this->discount->Value !== false)
                    $this->discount->SetText(0);
                if(!is_array($this->disount_type->Value) && !strlen($this->disount_type->Value) && $this->disount_type->Value !== false)
                    $this->disount_type->SetText('A');
                if(!is_array($this->expire_count->Value) && !strlen($this->expire_count->Value) && $this->expire_count->Value !== false)
                    $this->expire_count->SetText(0);
                if(!is_array($this->expire_date_time->Value) && !strlen($this->expire_date_time->Value) && $this->expire_date_time->Value !== false)
                    $this->expire_date_time->SetValue(time());
                if(!is_array($this->ticket_max_qty->Value) && !strlen($this->ticket_max_qty->Value) && $this->ticket_max_qty->Value !== false)
                    $this->ticket_max_qty->SetText(0);
                if(!is_array($this->ticket_expiry_hrs->Value) && !strlen($this->ticket_expiry_hrs->Value) && $this->ticket_expiry_hrs->Value !== false)
                    $this->ticket_expiry_hrs->SetText(0);
                if(!is_array($this->flg_ticket->Value) && !strlen($this->flg_ticket->Value) && $this->flg_ticket->Value !== false)
                    $this->flg_ticket->SetText('N');
                if(!is_array($this->flg_hide_show->Value) && !strlen($this->flg_hide_show->Value) && $this->flg_hide_show->Value !== false)
                    $this->flg_hide_show->SetText('H');
            }
        }
    }
//End Class_Initialize Event

//Initialize Method @48-354A1FF4
    function Initialize()
    {

        if(!$this->Visible)
            return;

        $this->DataSource->Parameters["urle~"] = CCGetFromGet("e~", NULL);
    }
//End Initialize Method

//Validate Method @48-39C37476
    function Validate()
    {
        global $CCSLocales;
        $Validation = true;
        $Where = "";
        $Validation = ($this->date_start->Validate() && $Validation);
        $Validation = ($this->date_end->Validate() && $Validation);
        $Validation = ($this->promo_code->Validate() && $Validation);
        $Validation = ($this->discount->Validate() && $Validation);
        $Validation = ($this->disount_type->Validate() && $Validation);
        $Validation = ($this->expire_count->Validate() && $Validation);
        $Validation = ($this->expire_date_time->Validate() && $Validation);
        $Validation = ($this->ticket_series->Validate() && $Validation);
        $Validation = ($this->ticket_max_qty->Validate() && $Validation);
        $Validation = ($this->ticket_expiry_hrs->Validate() && $Validation);
        $Validation = ($this->item_id->Validate() && $Validation);
        $Validation = ($this->flg_ticket->Validate() && $Validation);
        $Validation = ($this->flg_hide_show->Validate() && $Validation);
        $Validation = ($this->date_reg_closing->Validate() && $Validation);
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "OnValidate", $this);
        $Validation =  $Validation && ($this->date_start->Errors->Count() == 0);
        $Validation =  $Validation && ($this->date_end->Errors->Count() == 0);
        $Validation =  $Validation && ($this->promo_code->Errors->Count() == 0);
        $Validation =  $Validation && ($this->discount->Errors->Count() == 0);
        $Validation =  $Validation && ($this->disount_type->Errors->Count() == 0);
        $Validation =  $Validation && ($this->expire_count->Errors->Count() == 0);
        $Validation =  $Validation && ($this->expire_date_time->Errors->Count() == 0);
        $Validation =  $Validation && ($this->ticket_series->Errors->Count() == 0);
        $Validation =  $Validation && ($this->ticket_max_qty->Errors->Count() == 0);
        $Validation =  $Validation && ($this->ticket_expiry_hrs->Errors->Count() == 0);
        $Validation =  $Validation && ($this->item_id->Errors->Count() == 0);
        $Validation =  $Validation && ($this->flg_ticket->Errors->Count() == 0);
        $Validation =  $Validation && ($this->flg_hide_show->Errors->Count() == 0);
        $Validation =  $Validation && ($this->date_reg_closing->Errors->Count() == 0);
        return (($this->Errors->Count() == 0) && $Validation);
    }
//End Validate Method

//CheckErrors Method @48-9E513793
    function CheckErrors()
    {
        $errors = false;
        $errors = ($errors || $this->caption->Errors->Count());
        $errors = ($errors || $this->date_start->Errors->Count());
        $errors = ($errors || $this->date_end->Errors->Count());
        $errors = ($errors || $this->promo_code->Errors->Count());
        $errors = ($errors || $this->discount->Errors->Count());
        $errors = ($errors || $this->disount_type->Errors->Count());
        $errors = ($errors || $this->expire_count->Errors->Count());
        $errors = ($errors || $this->expire_date_time->Errors->Count());
        $errors = ($errors || $this->ticket_series->Errors->Count());
        $errors = ($errors || $this->ticket_max_qty->Errors->Count());
        $errors = ($errors || $this->ticket_expiry_hrs->Errors->Count());
        $errors = ($errors || $this->item_id->Errors->Count());
        $errors = ($errors || $this->flg_ticket->Errors->Count());
        $errors = ($errors || $this->flg_hide_show->Errors->Count());
        $errors = ($errors || $this->date_reg_closing->Errors->Count());
        $errors = ($errors || $this->Errors->Count());
        $errors = ($errors || $this->DataSource->Errors->Count());
        return $errors;
    }
//End CheckErrors Method

//MasterDetail @48-ED598703
function SetPrimaryKeys($keyArray)
{
    $this->PrimaryKeys = $keyArray;
}
function GetPrimaryKeys()
{
    return $this->PrimaryKeys;
}
function GetPrimaryKey($keyName)
{
    return $this->PrimaryKeys[$keyName];
}
//End MasterDetail

//Operation Method @48-FA530D83
    function Operation()
    {
        if(!$this->Visible)
            return;

        global $Redirect;
        global $FileName;

        $this->DataSource->Prepare();
        if(!$this->FormSubmitted) {
            $this->EditMode = $this->DataSource->AllParametersSet;
            return;
        }

        if($this->FormSubmitted) {
            $this->PressedButton = $this->EditMode ? "Button_Update" : "Button_Insert";
            if($this->Button_Insert->Pressed) {
                $this->PressedButton = "Button_Insert";
            } else if($this->Button_Update->Pressed) {
                $this->PressedButton = "Button_Update";
            } else if($this->Button_Delete->Pressed) {
                $this->PressedButton = "Button_Delete";
            } else if($this->Button_Cancel->Pressed) {
                $this->PressedButton = "Button_Cancel";
            }
        }
        $Redirect = $FileName . "?" . CCGetQueryString("QueryString", array("ccsForm", "n~", "d~", "e~"));
        if($this->PressedButton == "Button_Delete") {
            if(!CCGetEvent($this->Button_Delete->CCSEvents, "OnClick", $this->Button_Delete)) {
                $Redirect = "";
            }
        } else if($this->PressedButton == "Button_Cancel") {
            if(!CCGetEvent($this->Button_Cancel->CCSEvents, "OnClick", $this->Button_Cancel)) {
                $Redirect = "";
            }
        } else if($this->Validate()) {
            if($this->PressedButton == "Button_Insert") {
                if(!CCGetEvent($this->Button_Insert->CCSEvents, "OnClick", $this->Button_Insert) || !$this->InsertRow()) {
                    $Redirect = "";
                }
            } else if($this->PressedButton == "Button_Update") {
                if(!CCGetEvent($this->Button_Update->CCSEvents, "OnClick", $this->Button_Update) || !$this->UpdateRow()) {
                    $Redirect = "";
                }
            }
        } else {
            $Redirect = "";
        }
        if ($Redirect)
            $this->DataSource->close();
    }
//End Operation Method

//InsertRow Method @48-A06BCAC5
    function InsertRow()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeInsert", $this);
        if(!$this->InsertAllowed) return false;
        $this->DataSource->caption->SetValue($this->caption->GetValue(true));
        $this->DataSource->date_start->SetValue($this->date_start->GetValue(true));
        $this->DataSource->date_end->SetValue($this->date_end->GetValue(true));
        $this->DataSource->promo_code->SetValue($this->promo_code->GetValue(true));
        $this->DataSource->discount->SetValue($this->discount->GetValue(true));
        $this->DataSource->disount_type->SetValue($this->disount_type->GetValue(true));
        $this->DataSource->expire_count->SetValue($this->expire_count->GetValue(true));
        $this->DataSource->expire_date_time->SetValue($this->expire_date_time->GetValue(true));
        $this->DataSource->ticket_series->SetValue($this->ticket_series->GetValue(true));
        $this->DataSource->ticket_max_qty->SetValue($this->ticket_max_qty->GetValue(true));
        $this->DataSource->ticket_expiry_hrs->SetValue($this->ticket_expiry_hrs->GetValue(true));
        $this->DataSource->item_id->SetValue($this->item_id->GetValue(true));
        $this->DataSource->flg_ticket->SetValue($this->flg_ticket->GetValue(true));
        $this->DataSource->flg_hide_show->SetValue($this->flg_hide_show->GetValue(true));
        $this->DataSource->date_reg_closing->SetValue($this->date_reg_closing->GetValue(true));
        $this->DataSource->Insert();
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterInsert", $this);
        return (!$this->CheckErrors());
    }
//End InsertRow Method

//UpdateRow Method @48-EAAA0DA4
    function UpdateRow()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeUpdate", $this);
        if(!$this->UpdateAllowed) return false;
        $this->DataSource->caption->SetValue($this->caption->GetValue(true));
        $this->DataSource->date_start->SetValue($this->date_start->GetValue(true));
        $this->DataSource->date_end->SetValue($this->date_end->GetValue(true));
        $this->DataSource->promo_code->SetValue($this->promo_code->GetValue(true));
        $this->DataSource->discount->SetValue($this->discount->GetValue(true));
        $this->DataSource->disount_type->SetValue($this->disount_type->GetValue(true));
        $this->DataSource->expire_count->SetValue($this->expire_count->GetValue(true));
        $this->DataSource->expire_date_time->SetValue($this->expire_date_time->GetValue(true));
        $this->DataSource->ticket_series->SetValue($this->ticket_series->GetValue(true));
        $this->DataSource->ticket_max_qty->SetValue($this->ticket_max_qty->GetValue(true));
        $this->DataSource->ticket_expiry_hrs->SetValue($this->ticket_expiry_hrs->GetValue(true));
        $this->DataSource->item_id->SetValue($this->item_id->GetValue(true));
        $this->DataSource->flg_ticket->SetValue($this->flg_ticket->GetValue(true));
        $this->DataSource->flg_hide_show->SetValue($this->flg_hide_show->GetValue(true));
        $this->DataSource->date_reg_closing->SetValue($this->date_reg_closing->GetValue(true));
        $this->DataSource->Update();
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterUpdate", $this);
        return (!$this->CheckErrors());
    }
//End UpdateRow Method

//Show Method @48-F45A12D2
    function Show()
    {
        global $CCSUseAmp;
        global $Tpl;
        global $FileName;
        global $CCSLocales;
        $Error = "";

        if(!$this->Visible)
            return;

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeSelect", $this);

        $this->disount_type->Prepare();
        $this->flg_ticket->Prepare();
        $this->flg_hide_show->Prepare();

        $RecordBlock = "Record " . $this->ComponentName;
        $ParentPath = $Tpl->block_path;
        $Tpl->block_path = $ParentPath . "/" . $RecordBlock;
        $this->EditMode = $this->EditMode && $this->ReadAllowed;
        if($this->EditMode) {
            if($this->DataSource->Errors->Count()){
                $this->Errors->AddErrors($this->DataSource->Errors);
                $this->DataSource->Errors->clear();
            }
            $this->DataSource->Open();
            if($this->DataSource->Errors->Count() == 0 && $this->DataSource->next_record()) {
                $this->DataSource->SetValues();
                if(!$this->FormSubmitted){
                    $this->date_start->SetValue($this->DataSource->date_start->GetValue());
                    $this->date_end->SetValue($this->DataSource->date_end->GetValue());
                    $this->promo_code->SetValue($this->DataSource->promo_code->GetValue());
                    $this->discount->SetValue($this->DataSource->discount->GetValue());
                    $this->disount_type->SetValue($this->DataSource->disount_type->GetValue());
                    $this->expire_count->SetValue($this->DataSource->expire_count->GetValue());
                    $this->expire_date_time->SetValue($this->DataSource->expire_date_time->GetValue());
                    $this->ticket_series->SetValue($this->DataSource->ticket_series->GetValue());
                    $this->ticket_max_qty->SetValue($this->DataSource->ticket_max_qty->GetValue());
                    $this->ticket_expiry_hrs->SetValue($this->DataSource->ticket_expiry_hrs->GetValue());
                    $this->item_id->SetValue($this->DataSource->item_id->GetValue());
                    $this->flg_ticket->SetValue($this->DataSource->flg_ticket->GetValue());
                    $this->flg_hide_show->SetValue($this->DataSource->flg_hide_show->GetValue());
                    $this->date_reg_closing->SetValue($this->DataSource->date_reg_closing->GetValue());
                }
            } else {
                $this->EditMode = false;
            }
        }

        if($this->FormSubmitted || $this->CheckErrors()) {
            $Error = "";
            $Error = ComposeStrings($Error, $this->caption->Errors->ToString());
            $Error = ComposeStrings($Error, $this->date_start->Errors->ToString());
            $Error = ComposeStrings($Error, $this->date_end->Errors->ToString());
            $Error = ComposeStrings($Error, $this->promo_code->Errors->ToString());
            $Error = ComposeStrings($Error, $this->discount->Errors->ToString());
            $Error = ComposeStrings($Error, $this->disount_type->Errors->ToString());
            $Error = ComposeStrings($Error, $this->expire_count->Errors->ToString());
            $Error = ComposeStrings($Error, $this->expire_date_time->Errors->ToString());
            $Error = ComposeStrings($Error, $this->ticket_series->Errors->ToString());
            $Error = ComposeStrings($Error, $this->ticket_max_qty->Errors->ToString());
            $Error = ComposeStrings($Error, $this->ticket_expiry_hrs->Errors->ToString());
            $Error = ComposeStrings($Error, $this->item_id->Errors->ToString());
            $Error = ComposeStrings($Error, $this->flg_ticket->Errors->ToString());
            $Error = ComposeStrings($Error, $this->flg_hide_show->Errors->ToString());
            $Error = ComposeStrings($Error, $this->date_reg_closing->Errors->ToString());
            $Error = ComposeStrings($Error, $this->Errors->ToString());
            $Error = ComposeStrings($Error, $this->DataSource->Errors->ToString());
            $Tpl->SetVar("Error", $Error);
            $Tpl->Parse("Error", false);
        }
        $CCSForm = $this->EditMode ? $this->ComponentName . ":" . "Edit" : $this->ComponentName;
        $this->HTMLFormAction = $FileName . "?" . CCAddParam(CCGetQueryString("QueryString", ""), "ccsForm", $CCSForm);
        $Tpl->SetVar("Action", !$CCSUseAmp ? $this->HTMLFormAction : str_replace("&", "&amp;", $this->HTMLFormAction));
        $Tpl->SetVar("HTMLFormName", $this->ComponentName);
        $Tpl->SetVar("HTMLFormEnctype", $this->FormEnctype);
        $this->Button_Insert->Visible = !$this->EditMode && $this->InsertAllowed;
        $this->Button_Update->Visible = $this->EditMode && $this->UpdateAllowed;
        $this->Button_Delete->Visible = $this->EditMode && $this->DeleteAllowed;

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShow", $this);
        $this->Attributes->Show();
        if(!$this->Visible) {
            $Tpl->block_path = $ParentPath;
            return;
        }

        $this->Button_Insert->Show();
        $this->Button_Update->Show();
        $this->Button_Delete->Show();
        $this->Button_Cancel->Show();
        $this->caption->Show();
        $this->date_start->Show();
        $this->date_end->Show();
        $this->promo_code->Show();
        $this->discount->Show();
        $this->disount_type->Show();
        $this->expire_count->Show();
        $this->expire_date_time->Show();
        $this->ticket_series->Show();
        $this->ticket_max_qty->Show();
        $this->ticket_expiry_hrs->Show();
        $this->item_id->Show();
        $this->flg_ticket->Show();
        $this->flg_hide_show->Show();
        $this->date_reg_closing->Show();
        $Tpl->parse();
        $Tpl->block_path = $ParentPath;
        $this->DataSource->close();
    }
//End Show Method

} //End clix_rec Class @48-FCB6E20C

class clsclix_recDataSource extends clsDBConnection1 {  //clix_recDataSource Class @48-1EF28E83

//DataSource Variables @48-9161815A
    var $Parent = "";
    var $CCSEvents = "";
    var $CCSEventResult;
    var $ErrorBlock;
    var $CmdExecution;

    var $InsertParameters;
    var $UpdateParameters;
    var $wp;
    var $AllParametersSet;

    var $InsertFields = array();
    var $UpdateFields = array();

    // Datasource fields
    var $caption;
    var $date_start;
    var $date_end;
    var $promo_code;
    var $discount;
    var $disount_type;
    var $expire_count;
    var $expire_date_time;
    var $ticket_series;
    var $ticket_max_qty;
    var $ticket_expiry_hrs;
    var $item_id;
    var $flg_ticket;
    var $flg_hide_show;
    var $date_reg_closing;
//End DataSource Variables

//DataSourceClass_Initialize Event @48-388BDCE9
    function clsclix_recDataSource(& $Parent)
    {
        $this->Parent = & $Parent;
        $this->ErrorBlock = "Record clix_rec/Error";
        $this->Initialize();
        $this->caption = new clsField("caption", ccsText, "");
        
        $this->date_start = new clsField("date_start", ccsDate, array("yyyy", "-", "mm", "-", "dd", " ", "HH", ":", "nn", ":", "ss", "GMT"));
        
        $this->date_end = new clsField("date_end", ccsDate, array("yyyy", "-", "mm", "-", "dd", " ", "HH", ":", "nn", ":", "ss", "GMT"));
        
        $this->promo_code = new clsField("promo_code", ccsText, "");
        
        $this->discount = new clsField("discount", ccsFloat, "");
        
        $this->disount_type = new clsField("disount_type", ccsText, "");
        
        $this->expire_count = new clsField("expire_count", ccsInteger, "");
        
        $this->expire_date_time = new clsField("expire_date_time", ccsDate, array("yyyy", "-", "mm", "-", "dd", " ", "HH", ":", "nn", ":", "ss", "GMT"));
        
        $this->ticket_series = new clsField("ticket_series", ccsText, "");
        
        $this->ticket_max_qty = new clsField("ticket_max_qty", ccsInteger, "");
        
        $this->ticket_expiry_hrs = new clsField("ticket_expiry_hrs", ccsInteger, "");
        
        $this->item_id = new clsField("item_id", ccsInteger, "");
        
        $this->flg_ticket = new clsField("flg_ticket", ccsText, "");
        
        $this->flg_hide_show = new clsField("flg_hide_show", ccsText, "");
        
        $this->date_reg_closing = new clsField("date_reg_closing", ccsDate, array("yyyy", "-", "mm", "-", "dd", " ", "HH", ":", "nn", ":", "ss", "GMT"));
        

        $this->InsertFields["date_start"] = array("Name" => "date_start", "Value" => "", "DataType" => ccsDate, "OmitIfEmpty" => 1);
        $this->InsertFields["date_end"] = array("Name" => "date_end", "Value" => "", "DataType" => ccsDate, "OmitIfEmpty" => 1);
        $this->InsertFields["promo_code"] = array("Name" => "promo_code", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->InsertFields["discount"] = array("Name" => "discount", "Value" => "", "DataType" => ccsFloat, "OmitIfEmpty" => 1);
        $this->InsertFields["disount_type"] = array("Name" => "disount_type", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->InsertFields["expire_count"] = array("Name" => "expire_count", "Value" => "", "DataType" => ccsInteger, "OmitIfEmpty" => 1);
        $this->InsertFields["expire_date_time"] = array("Name" => "expire_date_time", "Value" => "", "DataType" => ccsDate, "OmitIfEmpty" => 1);
        $this->InsertFields["ticket_series"] = array("Name" => "ticket_series", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->InsertFields["ticket_max_qty"] = array("Name" => "ticket_max_qty", "Value" => "", "DataType" => ccsInteger, "OmitIfEmpty" => 1);
        $this->InsertFields["ticket_expiry_hrs"] = array("Name" => "ticket_expiry_hrs", "Value" => "", "DataType" => ccsInteger, "OmitIfEmpty" => 1);
        $this->InsertFields["item_id"] = array("Name" => "item_id", "Value" => "", "DataType" => ccsInteger, "OmitIfEmpty" => 1);
        $this->InsertFields["flg_ticket"] = array("Name" => "flg_ticket", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->InsertFields["flg_hide_show"] = array("Name" => "flg_hide_show", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->InsertFields["date_reg_closing"] = array("Name" => "date_reg_closing", "Value" => "", "DataType" => ccsDate, "OmitIfEmpty" => 1);
        $this->UpdateFields["date_start"] = array("Name" => "date_start", "Value" => "", "DataType" => ccsDate, "OmitIfEmpty" => 1);
        $this->UpdateFields["date_end"] = array("Name" => "date_end", "Value" => "", "DataType" => ccsDate, "OmitIfEmpty" => 1);
        $this->UpdateFields["promo_code"] = array("Name" => "promo_code", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->UpdateFields["discount"] = array("Name" => "discount", "Value" => "", "DataType" => ccsFloat, "OmitIfEmpty" => 1);
        $this->UpdateFields["disount_type"] = array("Name" => "disount_type", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->UpdateFields["expire_count"] = array("Name" => "expire_count", "Value" => "", "DataType" => ccsInteger, "OmitIfEmpty" => 1);
        $this->UpdateFields["expire_date_time"] = array("Name" => "expire_date_time", "Value" => "", "DataType" => ccsDate, "OmitIfEmpty" => 1);
        $this->UpdateFields["ticket_series"] = array("Name" => "ticket_series", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->UpdateFields["ticket_max_qty"] = array("Name" => "ticket_max_qty", "Value" => "", "DataType" => ccsInteger, "OmitIfEmpty" => 1);
        $this->UpdateFields["ticket_expiry_hrs"] = array("Name" => "ticket_expiry_hrs", "Value" => "", "DataType" => ccsInteger, "OmitIfEmpty" => 1);
        $this->UpdateFields["item_id"] = array("Name" => "item_id", "Value" => "", "DataType" => ccsInteger, "OmitIfEmpty" => 1);
        $this->UpdateFields["flg_ticket"] = array("Name" => "flg_ticket", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->UpdateFields["flg_hide_show"] = array("Name" => "flg_hide_show", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->UpdateFields["date_reg_closing"] = array("Name" => "date_reg_closing", "Value" => "", "DataType" => ccsDate, "OmitIfEmpty" => 1);
    }
//End DataSourceClass_Initialize Event

//Prepare Method @48-0D7AE398
    function Prepare()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->wp = new clsSQLParameters($this->ErrorBlock);
        $this->wp->AddParameter("1", "urle~", ccsInteger, "", "", $this->Parameters["urle~"], "", false);
        $this->AllParametersSet = $this->wp->AllParamsSet();
        $this->wp->Criterion[1] = $this->wp->Operation(opEqual, "event_id", $this->wp->GetDBValue("1"), $this->ToSQL($this->wp->GetDBValue("1"), ccsInteger),false);
        $this->Where = 
             $this->wp->Criterion[1];
    }
//End Prepare Method

//Open Method @48-26C7673E
    function Open()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildSelect", $this->Parent);
        $this->SQL = "SELECT * \n\n" .
        "FROM events_tran {SQL_Where} {SQL_OrderBy}";
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteSelect", $this->Parent);
        $this->PageSize = 1;
        $this->query($this->OptimizeSQL(CCBuildSQL($this->SQL, $this->Where, $this->Order)));
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteSelect", $this->Parent);
    }
//End Open Method

//SetValues Method @48-9C49EBF6
    function SetValues()
    {
        $this->date_start->SetDBValue(trim($this->f("date_start")));
        $this->date_end->SetDBValue(trim($this->f("date_end")));
        $this->promo_code->SetDBValue($this->f("promo_code"));
        $this->discount->SetDBValue(trim($this->f("discount")));
        $this->disount_type->SetDBValue($this->f("disount_type"));
        $this->expire_count->SetDBValue(trim($this->f("expire_count")));
        $this->expire_date_time->SetDBValue(trim($this->f("expire_date_time")));
        $this->ticket_series->SetDBValue($this->f("ticket_series"));
        $this->ticket_max_qty->SetDBValue(trim($this->f("ticket_max_qty")));
        $this->ticket_expiry_hrs->SetDBValue(trim($this->f("ticket_expiry_hrs")));
        $this->item_id->SetDBValue(trim($this->f("item_id")));
        $this->flg_ticket->SetDBValue($this->f("flg_ticket"));
        $this->flg_hide_show->SetDBValue($this->f("flg_hide_show"));
        $this->date_reg_closing->SetDBValue(trim($this->f("date_reg_closing")));
    }
//End SetValues Method

//Insert Method @48-51F589EB
    function Insert()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->CmdExecution = true;
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildInsert", $this->Parent);
        $this->InsertFields["date_start"]["Value"] = $this->date_start->GetDBValue(true);
        $this->InsertFields["date_end"]["Value"] = $this->date_end->GetDBValue(true);
        $this->InsertFields["promo_code"]["Value"] = $this->promo_code->GetDBValue(true);
        $this->InsertFields["discount"]["Value"] = $this->discount->GetDBValue(true);
        $this->InsertFields["disount_type"]["Value"] = $this->disount_type->GetDBValue(true);
        $this->InsertFields["expire_count"]["Value"] = $this->expire_count->GetDBValue(true);
        $this->InsertFields["expire_date_time"]["Value"] = $this->expire_date_time->GetDBValue(true);
        $this->InsertFields["ticket_series"]["Value"] = $this->ticket_series->GetDBValue(true);
        $this->InsertFields["ticket_max_qty"]["Value"] = $this->ticket_max_qty->GetDBValue(true);
        $this->InsertFields["ticket_expiry_hrs"]["Value"] = $this->ticket_expiry_hrs->GetDBValue(true);
        $this->InsertFields["item_id"]["Value"] = $this->item_id->GetDBValue(true);
        $this->InsertFields["flg_ticket"]["Value"] = $this->flg_ticket->GetDBValue(true);
        $this->InsertFields["flg_hide_show"]["Value"] = $this->flg_hide_show->GetDBValue(true);
        $this->InsertFields["date_reg_closing"]["Value"] = $this->date_reg_closing->GetDBValue(true);
        $this->SQL = CCBuildInsert("events_tran", $this->InsertFields, $this);
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteInsert", $this->Parent);
        if($this->Errors->Count() == 0 && $this->CmdExecution) {
            $this->query($this->SQL);
            $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteInsert", $this->Parent);
        }
    }
//End Insert Method

//Update Method @48-55449233
    function Update()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->CmdExecution = true;
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildUpdate", $this->Parent);
        $this->UpdateFields["date_start"]["Value"] = $this->date_start->GetDBValue(true);
        $this->UpdateFields["date_end"]["Value"] = $this->date_end->GetDBValue(true);
        $this->UpdateFields["promo_code"]["Value"] = $this->promo_code->GetDBValue(true);
        $this->UpdateFields["discount"]["Value"] = $this->discount->GetDBValue(true);
        $this->UpdateFields["disount_type"]["Value"] = $this->disount_type->GetDBValue(true);
        $this->UpdateFields["expire_count"]["Value"] = $this->expire_count->GetDBValue(true);
        $this->UpdateFields["expire_date_time"]["Value"] = $this->expire_date_time->GetDBValue(true);
        $this->UpdateFields["ticket_series"]["Value"] = $this->ticket_series->GetDBValue(true);
        $this->UpdateFields["ticket_max_qty"]["Value"] = $this->ticket_max_qty->GetDBValue(true);
        $this->UpdateFields["ticket_expiry_hrs"]["Value"] = $this->ticket_expiry_hrs->GetDBValue(true);
        $this->UpdateFields["item_id"]["Value"] = $this->item_id->GetDBValue(true);
        $this->UpdateFields["flg_ticket"]["Value"] = $this->flg_ticket->GetDBValue(true);
        $this->UpdateFields["flg_hide_show"]["Value"] = $this->flg_hide_show->GetDBValue(true);
        $this->UpdateFields["date_reg_closing"]["Value"] = $this->date_reg_closing->GetDBValue(true);
        $this->SQL = CCBuildUpdate("events_tran", $this->UpdateFields, $this);
        $this->SQL .= strlen($this->Where) ? " WHERE " . $this->Where : $this->Where;
        if (!strlen($this->Where) && $this->Errors->Count() == 0) 
            $this->Errors->addError($CCSLocales->GetText("CCS_CustomOperationError_MissingParameters"));
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteUpdate", $this->Parent);
        if($this->Errors->Count() == 0 && $this->CmdExecution) {
            $this->query($this->SQL);
            $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteUpdate", $this->Parent);
        }
    }
//End Update Method

} //End clix_recDataSource Class @48-FCB6E20C

class clsRecordclix_s { //clix_s Class @107-6D0EFB0C

//Variables @107-D6FF3E86

    // Public variables
    var $ComponentType = "Record";
    var $ComponentName;
    var $Parent;
    var $HTMLFormAction;
    var $PressedButton;
    var $Errors;
    var $ErrorBlock;
    var $FormSubmitted;
    var $FormEnctype;
    var $Visible;
    var $IsEmpty;

    var $CCSEvents = "";
    var $CCSEventResult;

    var $RelativePath = "";

    var $InsertAllowed = false;
    var $UpdateAllowed = false;
    var $DeleteAllowed = false;
    var $ReadAllowed   = false;
    var $EditMode      = false;
    var $ds;
    var $DataSource;
    var $ValidatingControls;
    var $Controls;
    var $Attributes;

    // Class variables
//End Variables

//Class_Initialize Event @107-979EF5D0
    function clsRecordclix_s($RelativePath, & $Parent)
    {

        global $FileName;
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->Visible = true;
        $this->Parent = & $Parent;
        $this->RelativePath = $RelativePath;
        $this->Errors = new clsErrors();
        $this->ErrorBlock = "Record clix_s/Error";
        $this->ReadAllowed = true;
        if($this->Visible)
        {
            $this->ComponentName = "clix_s";
            $this->Attributes = new clsAttributes($this->ComponentName . ":");
            $CCSForm = explode(":", CCGetFromGet("ccsForm", ""), 2);
            if(sizeof($CCSForm) == 1)
                $CCSForm[1] = "";
            list($FormName, $FormMethod) = $CCSForm;
            $this->FormEnctype = "application/x-www-form-urlencoded";
            $this->FormSubmitted = ($FormName == $this->ComponentName);
            $Method = $this->FormSubmitted ? ccsPost : ccsGet;
            $this->s = & new clsControl(ccsListBox, "s", "s", ccsInteger, "", CCGetRequestParam("s", $Method, NULL), $this);
            $this->s->DSType = dsTable;
            $this->s->DataSource = new clsDBConnection1();
            $this->s->ds = & $this->s->DataSource;
            $this->s->DataSource->SQL = "SELECT item_id, item_name \n" .
"FROM events_mst {SQL_Where} {SQL_OrderBy}";
            $this->s->DataSource->Order = "item_name";
            list($this->s->BoundColumn, $this->s->TextColumn, $this->s->DBFormat) = array("item_id", "item_name", "");
            $this->s->DataSource->Order = "item_name";
            $this->Button_DoSearch = & new clsButton("Button_DoSearch", $Method, $this);
        }
    }
//End Class_Initialize Event

//Validate Method @107-A0079428
    function Validate()
    {
        global $CCSLocales;
        $Validation = true;
        $Where = "";
        $Validation = ($this->s->Validate() && $Validation);
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "OnValidate", $this);
        $Validation =  $Validation && ($this->s->Errors->Count() == 0);
        return (($this->Errors->Count() == 0) && $Validation);
    }
//End Validate Method

//CheckErrors Method @107-570F4035
    function CheckErrors()
    {
        $errors = false;
        $errors = ($errors || $this->s->Errors->Count());
        $errors = ($errors || $this->Errors->Count());
        return $errors;
    }
//End CheckErrors Method

//MasterDetail @107-ED598703
function SetPrimaryKeys($keyArray)
{
    $this->PrimaryKeys = $keyArray;
}
function GetPrimaryKeys()
{
    return $this->PrimaryKeys;
}
function GetPrimaryKey($keyName)
{
    return $this->PrimaryKeys[$keyName];
}
//End MasterDetail

//Operation Method @107-050F518A
    function Operation()
    {
        if(!$this->Visible)
            return;

        global $Redirect;
        global $FileName;

        if(!$this->FormSubmitted) {
            return;
        }

        if($this->FormSubmitted) {
            $this->PressedButton = "Button_DoSearch";
            if($this->Button_DoSearch->Pressed) {
                $this->PressedButton = "Button_DoSearch";
            }
        }
        $Redirect = "events_tran.php";
        if($this->Validate()) {
            if($this->PressedButton == "Button_DoSearch") {
                $Redirect = "events_tran.php" . "?" . CCMergeQueryStrings(CCGetQueryString("Form", array("Button_DoSearch", "Button_DoSearch_x", "Button_DoSearch_y", "n~", "d~", "e~")));
                if(!CCGetEvent($this->Button_DoSearch->CCSEvents, "OnClick", $this->Button_DoSearch)) {
                    $Redirect = "";
                }
            }
        } else {
            $Redirect = "";
        }
    }
//End Operation Method

//Show Method @107-90BA5E33
    function Show()
    {
        global $CCSUseAmp;
        global $Tpl;
        global $FileName;
        global $CCSLocales;
        $Error = "";

        if(!$this->Visible)
            return;

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeSelect", $this);

        $this->s->Prepare();

        $RecordBlock = "Record " . $this->ComponentName;
        $ParentPath = $Tpl->block_path;
        $Tpl->block_path = $ParentPath . "/" . $RecordBlock;
        $this->EditMode = $this->EditMode && $this->ReadAllowed;
        if (!$this->FormSubmitted) {
        }

        if($this->FormSubmitted || $this->CheckErrors()) {
            $Error = "";
            $Error = ComposeStrings($Error, $this->s->Errors->ToString());
            $Error = ComposeStrings($Error, $this->Errors->ToString());
            $Tpl->SetVar("Error", $Error);
            $Tpl->Parse("Error", false);
        }
        $CCSForm = $this->EditMode ? $this->ComponentName . ":" . "Edit" : $this->ComponentName;
        $this->HTMLFormAction = $FileName . "?" . CCAddParam(CCGetQueryString("QueryString", ""), "ccsForm", $CCSForm);
        $Tpl->SetVar("Action", !$CCSUseAmp ? $this->HTMLFormAction : str_replace("&", "&amp;", $this->HTMLFormAction));
        $Tpl->SetVar("HTMLFormName", $this->ComponentName);
        $Tpl->SetVar("HTMLFormEnctype", $this->FormEnctype);

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShow", $this);
        $this->Attributes->Show();
        if(!$this->Visible) {
            $Tpl->block_path = $ParentPath;
            return;
        }

        $this->s->Show();
        $this->Button_DoSearch->Show();
        $Tpl->parse();
        $Tpl->block_path = $ParentPath;
    }
//End Show Method

} //End clix_s Class @107-FCB6E20C











//Initialize Page @1-8E23487A
// Variables
$FileName = "";
$Redirect = "";
$Tpl = "";
$TemplateFileName = "";
$BlockToParse = "";
$ComponentName = "";
$Attributes = "";

// Events;
$CCSEvents = "";
$CCSEventResult = "";

$FileName = FileName;
$Redirect = "";
$TemplateFileName = "events_tran.html";
$BlockToParse = "main";
$TemplateEncoding = "UTF-8";
$ContentType = "text/html";
$PathToRoot = "./";
$Charset = $Charset ? $Charset : "utf-8";
//End Initialize Page

//Authenticate User @1-74BBAD6F
CCSecurityRedirect("6666", "");
//End Authenticate User

//Include events file @1-D5C4C808
include_once("./events_tran_events.php");
//End Include events file

//Before Initialize @1-E870CEBC
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeInitialize", $MainPage);
//End Before Initialize

//Initialize Objects @1-A849546D
$DBConnection1 = new clsDBConnection1();
$MainPage->Connections["Connection1"] = & $DBConnection1;
$Attributes = new clsAttributes("page:");
$MainPage->Attributes = & $Attributes;

// Controls
$incl_ClixTop = & new clsincl_ClixTop("", "incl_ClixTop", $MainPage);
$incl_ClixTop->Initialize();
$incl_footer = & new clsincl_footer("", "incl_footer", $MainPage);
$incl_footer->Initialize();
$incl_sidebar = & new clsincl_sidebar("", "incl_sidebar", $MainPage);
$incl_sidebar->Initialize();
$clix_list = & new clsGridclix_list("", $MainPage);
$clix_rec = & new clsRecordclix_rec("", $MainPage);
$clix_s = & new clsRecordclix_s("", $MainPage);
$MainPage->incl_ClixTop = & $incl_ClixTop;
$MainPage->incl_footer = & $incl_footer;
$MainPage->incl_sidebar = & $incl_sidebar;
$MainPage->clix_list = & $clix_list;
$MainPage->clix_rec = & $clix_rec;
$MainPage->clix_s = & $clix_s;
$clix_list->Initialize();
$clix_rec->Initialize();

BindEvents();

$CCSEventResult = CCGetEvent($CCSEvents, "AfterInitialize", $MainPage);

if ($Charset) {
    header("Content-Type: " . $ContentType . "; charset=" . $Charset);
} else {
    header("Content-Type: " . $ContentType);
}
//End Initialize Objects

//Initialize HTML Template @1-51EC165D
$CCSEventResult = CCGetEvent($CCSEvents, "OnInitializeView", $MainPage);
$Tpl = new clsTemplate($FileEncoding, $TemplateEncoding);
$Tpl->LoadTemplate(PathToCurrentPage . $TemplateFileName, $BlockToParse, "UTF-8");
$Tpl->block_path = "/$BlockToParse";
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeShow", $MainPage);
$Attributes->SetValue("pathToRoot", "");
$Attributes->Show();
//End Initialize HTML Template

//Execute Components @1-E50EB8FA
$incl_ClixTop->Operations();
$incl_footer->Operations();
$incl_sidebar->Operations();
$clix_rec->Operation();
$clix_s->Operation();
//End Execute Components

//Go to destination page @1-799D87B4
if($Redirect)
{
    $CCSEventResult = CCGetEvent($CCSEvents, "BeforeUnload", $MainPage);
    $DBConnection1->close();
    header("Location: " . $Redirect);
    $incl_ClixTop->Class_Terminate();
    unset($incl_ClixTop);
    $incl_footer->Class_Terminate();
    unset($incl_footer);
    $incl_sidebar->Class_Terminate();
    unset($incl_sidebar);
    unset($clix_list);
    unset($clix_rec);
    unset($clix_s);
    unset($Tpl);
    exit;
}
//End Go to destination page

//Show Page @1-D8F5BBDF
$incl_ClixTop->Show();
$incl_footer->Show();
$incl_sidebar->Show();
$clix_list->Show();
$clix_rec->Show();
$clix_s->Show();
$Tpl->block_path = "";
$Tpl->Parse($BlockToParse, false);
if (!isset($main_block)) $main_block = $Tpl->GetVar($BlockToParse);
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeOutput", $MainPage);
if ($CCSEventResult) echo $main_block;
//End Show Page

//Unload Page @1-53C117F9
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeUnload", $MainPage);
$DBConnection1->close();
$incl_ClixTop->Class_Terminate();
unset($incl_ClixTop);
$incl_footer->Class_Terminate();
unset($incl_footer);
$incl_sidebar->Class_Terminate();
unset($incl_sidebar);
unset($clix_list);
unset($clix_rec);
unset($clix_s);
unset($Tpl);
//End Unload Page


?>
